/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.registration;

import java.util.ArrayList;
import makeo.gadomancy.common.blocks.tiles.TileExtendedNode;
import makeo.gadomancy.common.node.ExtendedNodeType;
import makeo.gadomancy.common.node.NodeManipulatorResult;
import makeo.gadomancy.common.node.NodeManipulatorResultHandler;
import makeo.gadomancy.common.utils.ResearchHelper;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public class RegisteredManipulations {
    public static NodeManipulatorResult resultBreakCompounds = new NodeManipulatorResult(4, NodeManipulatorResultHandler.ResultType.NEGATIVE){

        @Override
        public boolean affect(World world, INode node) {
            AspectList baseList = node.getAspectsBase();
            AspectList list = node.getAspects();
            for (Aspect a : baseList.getAspects()) {
                if (a.isPrimal()) continue;
                Aspect[] subComponents = a.getComponents();
                int initialValue = baseList.getAmount(a);
                list.remove(a);
                baseList.remove(a);
                baseList.add(subComponents[0], initialValue);
                list.add(subComponents[0], initialValue);
                baseList.add(subComponents[1], initialValue);
                list.add(subComponents[1], initialValue);
                return true;
            }
            return false;
        }
    };
    public static NodeManipulatorResult resultCombineAspects = new NodeManipulatorResult(5, NodeManipulatorResultHandler.ResultType.POSITIVE){

        @Override
        public boolean affect(World world, INode node) {
            AspectList base = node.getAspectsBase();
            if (base.getAspects().length < 2) {
                return false;
            }
            if (base.getAspects().length == 2) {
                if (!NodeManipulatorResultHandler.canCombine(base.getAspects()[0], base.getAspects()[1])) {
                    return false;
                }
                int addition = world.field_73012_v.nextInt(4);
                NodeManipulatorResultHandler.combine(base, base.getAspects()[0], base.getAspects()[1], addition);
                NodeManipulatorResultHandler.combine(node.getAspects(), base.getAspects()[0], base.getAspects()[1], addition);
                return true;
            }
            if (base.getAspects().length > 2) {
                int actuallyCombined = 0;
                int combineCount = world.field_73012_v.nextInt(1) + 1;
                block0: while (base.getAspects().length >= 2) {
                    block9: {
                        int randIndexForA = world.field_73012_v.nextInt(base.getAspects().length);
                        for (int i = 0; i < base.getAspects().length; ++i) {
                            int indexA = (i + randIndexForA) % base.getAspects().length;
                            Aspect a = base.getAspects()[indexA];
                            int randIndexForB = world.field_73012_v.nextInt(base.getAspects().length);
                            for (int j = 0; j < base.getAspects().length; ++j) {
                                int indexB = (j + randIndexForB) % base.getAspects().length;
                                Aspect b = base.getAspects()[indexB];
                                if (NodeManipulatorResultHandler.canCombine(a, b)) {
                                    int addition = world.field_73012_v.nextInt(4);
                                    NodeManipulatorResultHandler.combine(base, a, b, addition);
                                    NodeManipulatorResultHandler.combine(node.getAspects(), a, b, addition);
                                    --combineCount;
                                    ++actuallyCombined;
                                    break block9;
                                }
                                if (base.getAspects().length <= 2) break block0;
                            }
                        }
                        --combineCount;
                    }
                    if (combineCount > 0) continue;
                }
                if (actuallyCombined > 0) {
                    return true;
                }
            }
            return false;
        }
    };
    public static NodeManipulatorResult resultIncreaseModifier = new NodeManipulatorResult(4, NodeManipulatorResultHandler.ResultType.POSITIVE){

        @Override
        public boolean canAffect(World world, INode node) {
            return node.getNodeModifier() != NodeModifier.BRIGHT;
        }

        @Override
        public boolean affect(World world, INode node) {
            if (node.getNodeModifier() == null) {
                node.setNodeModifier(NodeModifier.BRIGHT);
                return true;
            }
            switch (node.getNodeModifier()) {
                case BRIGHT: {
                    return false;
                }
                case PALE: {
                    node.setNodeModifier(null);
                    break;
                }
                case FADING: {
                    node.setNodeModifier(NodeModifier.PALE);
                }
            }
            return true;
        }
    };
    public static NodeManipulatorResult resultDecreaseModifier = new NodeManipulatorResult(5, NodeManipulatorResultHandler.ResultType.NEGATIVE){

        @Override
        public boolean canAffect(World world, INode node) {
            return node.getNodeModifier() != NodeModifier.FADING;
        }

        @Override
        public boolean affect(World world, INode node) {
            if (node.getNodeModifier() == null) {
                node.setNodeModifier(NodeModifier.PALE);
                return true;
            }
            switch (node.getNodeModifier()) {
                case BRIGHT: {
                    node.setNodeModifier(null);
                    break;
                }
                case PALE: {
                    node.setNodeModifier(NodeModifier.FADING);
                    break;
                }
                case FADING: {
                    return false;
                }
            }
            return true;
        }
    };
    public static NodeManipulatorResult resultGainPrimal = new NodeManipulatorResult(3, NodeManipulatorResultHandler.ResultType.POSITIVE){

        @Override
        public boolean affect(World world, INode node) {
            ArrayList primals = Aspect.getPrimalAspects();
            int visSize = node.getAspectsBase().visSize();
            int size = node.getAspectsBase().size();
            int modulo = primals.size();
            int index = world.field_73012_v.nextInt(primals.size());
            for (int i = 0; i < primals.size(); ++i) {
                int get = (index + i) % modulo;
                Aspect rand = (Aspect)primals.get(get);
                if (node.getAspectsBase().getAmount(rand) > 0) continue;
                int randGain = visSize / (size * 2);
                if (randGain > 0) {
                    node.getAspectsBase().add(rand, randGain);
                    node.getAspects().add(rand, randGain);
                    return true;
                }
                return false;
            }
            return false;
        }
    };
    public static NodeManipulatorResult resultSwitchType = new NodeManipulatorResult(2, NodeManipulatorResultHandler.ResultType.NEUTRAL){

        @Override
        public boolean affect(World world, INode node) {
            boolean changed;
            NodeType newType = node.getNodeType();
            int random = world.field_73012_v.nextInt(40);
            if (random > 38) {
                if (node instanceof TileExtendedNode) {
                    TileExtendedNode tNode = (TileExtendedNode)node;
                    if (tNode.getExtendedNodeType() == null || !tNode.getExtendedNodeType().equals((Object)ExtendedNodeType.GROWING)) {
                        newType = NodeType.HUNGRY;
                    }
                } else {
                    newType = NodeType.HUNGRY;
                }
            } else if (random > 37) {
                newType = NodeType.TAINTED;
            } else if (random > 34) {
                newType = NodeType.UNSTABLE;
            } else if (random > 29) {
                newType = NodeType.DARK;
            } else if (random > 24) {
                newType = NodeType.PURE;
            } else if (random > 14) {
                newType = NodeType.NORMAL;
            }
            boolean bl = changed = !newType.equals((Object)node.getNodeType());
            if (changed) {
                node.setNodeType(newType);
            }
            return changed;
        }
    };
    public static NodeManipulatorResult resultApplyGrowing = new NodeManipulatorResult(1, NodeManipulatorResultHandler.ResultType.POSITIVE){

        @Override
        public boolean affect(World world, INode inode) {
            boolean isGrowingAlready;
            if (!(inode instanceof TileExtendedNode)) {
                return false;
            }
            TileExtendedNode node = (TileExtendedNode)inode;
            boolean bl = isGrowingAlready = node.getExtendedNodeType() != null && node.getExtendedNodeType().equals((Object)ExtendedNodeType.GROWING);
            if (isGrowingAlready && node.getNodeType().equals((Object)NodeType.HUNGRY)) {
                isGrowingAlready = false;
            }
            if (!isGrowingAlready) {
                node.setExtendedNodeType(ExtendedNodeType.GROWING);
                ResearchHelper.distributeResearch("gadomancy".toUpperCase() + ".GROWING", node.func_145831_w(), node.field_145851_c, node.field_145848_d, node.field_145849_e, 12.0);
            }
            return isGrowingAlready;
        }
    };
}

