/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import makeo.gadomancy.common.aura.AuraEffectHandler;
import makeo.gadomancy.common.blocks.tiles.SynchronizedTileEntity;
import makeo.gadomancy.common.blocks.tiles.TileAuraPylonTop;
import makeo.gadomancy.common.entities.EntityPermNoClipItem;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXEssentiaTrail;
import thaumcraft.common.entities.EntityPermanentItem;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.items.ItemCrystalEssence;

public class TileAuraPylon
extends SynchronizedTileEntity
implements IAspectContainer,
IEssentiaTransport,
EntityPermNoClipItem.IItemMasterTile {
    private ItemStack crystalEssentiaStack = null;
    private boolean isPartOfMultiblock = false;
    private int timeSinceLastItemInfo = 0;
    private int ticksExisted = 0;
    private Aspect holdingAspect;
    private int amount = 0;
    private int maxAmount = 5;
    private boolean isMasterTile;
    private boolean isInputTile;

    public void func_145845_h() {
        ++this.ticksExisted;
        ++this.timeSinceLastItemInfo;
        if (!this.field_145850_b.field_72995_K) {
            if ((this.ticksExisted & 3) == 0 && this.checkComponents()) {
                return;
            }
            if (this.isInputTile()) {
                this.handleIO();
            }
            if (this.isMasterTile()) {
                TileAuraPylon io = this.getInputTile();
                if (io != null && io.amount > 0) {
                    if ((this.ticksExisted & 0x1F) == 0) {
                        this.drainEssentia(io);
                    }
                    this.doAuraEffects(this.holdingAspect);
                }
                if (this.holdingAspect != null && this.timeSinceLastItemInfo > 8) {
                    this.informItemRemoval();
                }
            }
        } else if (this.isInputTile() && this.holdingAspect != null) {
            this.doEssentiaTrail();
        }
        if (this.isMasterTile() && this.crystalEssentiaStack == null) {
            this.tryVortexPossibleItems();
        }
    }

    @Override
    public boolean canStillHoldItem() {
        return this.isMasterTile();
    }

    @Override
    public void informMaster() {
        this.timeSinceLastItemInfo = 0;
    }

    private void doAuraEffects(Aspect aspect) {
        if (aspect == null) {
            return;
        }
        if (!this.isMasterTile()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        AuraEffectHandler.distributeEffects(aspect, this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.ticksExisted);
    }

    private void drainEssentia(TileAuraPylon io) {
        if (!this.isMasterTile()) {
            return;
        }
        --io.amount;
        this.field_145850_b.func_147471_g(io.field_145851_c, io.field_145848_d, io.field_145849_e);
        io.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    private void doEssentiaTrail() {
        if ((this.ticksExisted & 1) == 0) {
            return;
        }
        TileAuraPylon tile = this.getMasterTile();
        if (tile == null) {
            return;
        }
        TileAuraPylon inputTile = this.getInputTile();
        if (inputTile == null) {
            return;
        }
        Aspect a = inputTile.getAspectType();
        if (a == null) {
            return;
        }
        if (inputTile.amount <= 0) {
            return;
        }
        int count = 5;
        FXEssentiaTrail essentiaTrail = new FXEssentiaTrail(tile.func_145831_w(), (double)inputTile.field_145851_c + 0.5, (double)inputTile.field_145848_d + 0.2, (double)inputTile.field_145849_e + 0.5, (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 1.7, (double)tile.field_145849_e + 0.5, count, a.getColor(), 1.0f);
        essentiaTrail.field_70145_X = true;
        essentiaTrail.field_70181_x = 0.1f + MathHelper.func_76126_a((float)((float)count / 3.0f)) * 0.01f;
        essentiaTrail.field_70159_w = (double)(MathHelper.func_76126_a((float)((float)count / 10.0f)) * 0.001f) + this.field_145850_b.field_73012_v.nextGaussian() * 0.002000000094994903;
        essentiaTrail.field_70179_y = (double)(MathHelper.func_76126_a((float)((float)count / 10.0f)) * 0.001f) + this.field_145850_b.field_73012_v.nextGaussian() * 0.002000000094994903;
        ParticleEngine.instance.addEffect(tile.func_145831_w(), (EntityFX)essentiaTrail);
    }

    private void distributeAspectInformation() {
        if (!this.isMasterTile()) {
            return;
        }
        int count = 1;
        TileEntity iter = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - count, this.field_145849_e);
        while (iter != null && iter instanceof TileAuraPylon) {
            ((TileAuraPylon)iter).holdingAspect = this.holdingAspect;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d - count, this.field_145849_e);
            iter.func_70296_d();
            iter = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - ++count, this.field_145849_e);
        }
    }

    private void tryVortexPossibleItems() {
        TileAuraPylon io = this.getInputTile();
        if (io == null) {
            return;
        }
        int masterY = this.field_145848_d + 1;
        float dst = (float)(masterY - io.field_145848_d) / 2.0f;
        float yC = (float)masterY - dst;
        List entityItems = this.field_145850_b.func_82733_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)((double)yC - 0.5), (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)yC + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(8.0, 8.0, 8.0), new IEntitySelector(){

            public boolean func_82704_a(Entity e) {
                return !(e instanceof EntityPermanentItem) && !(e instanceof EntitySpecialItem) && e instanceof EntityItem && ((EntityItem)e).func_92059_d() != null && ((EntityItem)e).func_92059_d().func_77973_b() instanceof ItemCrystalEssence && ((ItemCrystalEssence)((EntityItem)e).func_92059_d().func_77973_b()).getAspects(((EntityItem)e).func_92059_d()) != null;
            }
        });
        EntityItem dummy = new EntityItem(this.field_145850_b);
        dummy.field_70165_t = (double)this.field_145851_c + 0.5;
        dummy.field_70163_u = (double)yC + 0.5;
        dummy.field_70161_v = (double)this.field_145849_e + 0.5;
        EntityItem entity = null;
        double d0 = Double.MAX_VALUE;
        for (Object entityItem : entityItems) {
            double d1;
            EntityItem entityIt = (EntityItem)entityItem;
            if (entityIt == dummy || !((d1 = dummy.func_70068_e((Entity)entityIt)) <= d0)) continue;
            entity = entityIt;
            d0 = d1;
        }
        if (entity == null) {
            return;
        }
        if (dummy.func_70032_d(entity) < 1.0f && !this.field_145850_b.field_72995_K) {
            ItemStack inter = entity.func_92059_d();
            --inter.field_77994_a;
            this.crystalEssentiaStack = inter.func_77946_l();
            this.crystalEssentiaStack.field_77994_a = 1;
            EntityPermNoClipItem item = new EntityPermNoClipItem(entity.field_70170_p, (float)this.field_145851_c + 0.5f, yC + 0.3f, (float)this.field_145849_e + 0.5f, this.crystalEssentiaStack, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            entity.field_70170_p.func_72838_d((Entity)item);
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            item.field_70290_d = entity.field_70290_d;
            item.field_70292_b = entity.field_70292_b;
            item.field_70145_X = true;
            this.timeSinceLastItemInfo = 0;
            this.holdingAspect = ((ItemCrystalEssence)this.crystalEssentiaStack.func_77973_b()).getAspects(this.crystalEssentiaStack).getAspects()[0];
            this.distributeAspectInformation();
            if (inter.field_77994_a <= 0) {
                entity.func_70106_y();
            }
            entity.field_70145_X = false;
            item.field_145804_b = 60;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        } else {
            entity.field_70145_X = true;
            this.applyMovementVectors(entity);
        }
    }

    private void applyMovementVectors(EntityItem entity) {
        double var3 = ((double)this.field_145851_c + 0.5 - entity.field_70165_t) / 15.0;
        double var5 = ((double)this.field_145848_d + 0.5 - entity.field_70163_u) / 15.0;
        double var7 = ((double)this.field_145849_e + 0.5 - entity.field_70161_v) / 15.0;
        double var9 = Math.sqrt(var3 * var3 + var5 * var5 + var7 * var7);
        double var11 = 1.0 - var9;
        if (var11 > 0.0) {
            var11 *= var11;
            entity.field_70159_w += var3 / var9 * var11 * 0.15;
            entity.field_70181_x += var5 / var9 * var11 * 0.25;
            entity.field_70179_y += var7 / var9 * var11 * 0.15;
        }
    }

    private void handleIO() {
        TileEntity te;
        if (!this.field_145850_b.field_72995_K && (this.ticksExisted & 0xF) == 0 && this.getEssentiaAmount() < this.getMaxAmount() && (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)ForgeDirection.DOWN)) != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(ForgeDirection.UP)) {
                return;
            }
            if (this.holdingAspect != null && ic.getSuctionAmount(ForgeDirection.UP) < this.getSuctionAmount(ForgeDirection.DOWN)) {
                this.addToContainer(this.holdingAspect, ic.takeEssentia(this.holdingAspect, 1, ForgeDirection.UP));
            }
        }
    }

    @Override
    public void informItemRemoval() {
        if (!this.isMasterTile()) {
            return;
        }
        this.crystalEssentiaStack = null;
        this.holdingAspect = null;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        this.distributeAspectInformation();
        TileAuraPylon io = this.getInputTile();
        if (io == null) {
            return;
        }
        io.amount = 0;
        this.field_145850_b.func_147471_g(io.field_145851_c, io.field_145848_d, io.field_145849_e);
        io.func_70296_d();
    }

    @Override
    public EntityPermNoClipItem.ItemChangeTask getAndRemoveScheduledChangeTask() {
        return null;
    }

    @Override
    public void broadcastItemStack(ItemStack itemStack) {
        this.crystalEssentiaStack = itemStack;
    }

    private boolean checkComponents() {
        TileAuraPylon te = this.getMasterTile();
        if (te == null) {
            this.breakTile();
            return true;
        }
        te = this.getInputTile();
        if (te == null) {
            this.breakTile();
            return true;
        }
        if (!this.hasTopTile()) {
            this.breakTile();
            return true;
        }
        return false;
    }

    private boolean hasTopTile() {
        TileAuraPylon master = this.getMasterTile();
        if (master == null) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_147438_o(master.field_145851_c, master.field_145848_d + 1, master.field_145849_e);
        return te != null && te instanceof TileAuraPylonTop;
    }

    private void breakTile() {
        if (!this.isPartOfMultiblock || this.field_145850_b.field_72995_K) {
            return;
        }
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Block pylon = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (pylon != null) {
            ArrayList stacks = pylon.getDrops(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 0);
            for (ItemStack i : stacks) {
                EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, i);
                this.field_145850_b.func_72838_d((Entity)item);
            }
        }
        this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isPartOfMultiblock() {
        return this.isPartOfMultiblock;
    }

    public void setPartOfMultiblock(boolean isPartOfMultiblock) {
        this.isPartOfMultiblock = isPartOfMultiblock;
    }

    public boolean canUpdate() {
        return true;
    }

    public void setTileInformation(boolean isMaster, boolean isInput) {
        this.isMasterTile = isMaster;
        this.isInputTile = isInput;
    }

    public boolean isInputTile() {
        return this.isInputTile;
    }

    public TileAuraPylon getInputTile() {
        if (this.isInputTile()) {
            return this;
        }
        if (this.field_145850_b == null) {
            return null;
        }
        TileEntity superTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (superTile == null || !(superTile instanceof TileAuraPylon)) {
            return null;
        }
        return ((TileAuraPylon)superTile).getInputTile();
    }

    public boolean isMasterTile() {
        return this.isMasterTile;
    }

    public TileAuraPylon getMasterTile() {
        if (this.isMasterTile()) {
            return this;
        }
        if (this.field_145850_b == null) {
            return null;
        }
        TileEntity superTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (superTile == null || !(superTile instanceof TileAuraPylon)) {
            return null;
        }
        return ((TileAuraPylon)superTile).getMasterTile();
    }

    public int getEssentiaAmount() {
        TileAuraPylon io = this.getInputTile();
        if (io == null) {
            return 0;
        }
        return io.amount;
    }

    public Aspect getAspectType() {
        TileAuraPylon io = this.getInputTile();
        if (io == null) {
            return null;
        }
        return io.holdingAspect;
    }

    public int getMaxAmount() {
        TileAuraPylon io = this.getInputTile();
        if (io == null) {
            return 0;
        }
        int max = io.maxAmount;
        int counter = 1;
        TileEntity superTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + counter, this.field_145849_e);
        while (superTile != null && superTile instanceof TileAuraPylon) {
            max += ((TileAuraPylon)superTile).maxAmount;
            superTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + ++counter, this.field_145849_e);
        }
        return max;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        this.isInputTile = compound.func_74767_n("input");
        this.isMasterTile = compound.func_74767_n("master");
        String tag = compound.func_74779_i("aspect");
        this.holdingAspect = tag != null && !tag.equals("") ? Aspect.getAspect((String)tag) : null;
        this.amount = compound.func_74762_e("amount");
        this.maxAmount = compound.func_74762_e("maxAmount");
        this.isPartOfMultiblock = compound.func_74767_n("partOfMultiblock");
        this.crystalEssentiaStack = NBTHelper.getStack(compound, "crystalStack");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        compound.func_74757_a("input", this.isInputTile);
        compound.func_74757_a("master", this.isMasterTile);
        if (this.holdingAspect != null) {
            compound.func_74778_a("aspect", this.holdingAspect.getTag());
        }
        compound.func_74768_a("amount", this.amount);
        compound.func_74768_a("maxAmount", this.maxAmount);
        compound.func_74757_a("partOfMultiblock", this.isPartOfMultiblock);
        if (this.crystalEssentiaStack != null) {
            NBTHelper.setStack(compound, "crystalStack", this.crystalEssentiaStack);
        }
    }

    public AspectList getAspects() {
        TileAuraPylon io = this.getInputTile();
        AspectList al = new AspectList();
        if (io != null && io.holdingAspect != null && io.amount > 0) {
            al.add(io.holdingAspect, io.amount);
        }
        return al;
    }

    public void setAspects(AspectList aspectList) {
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return this.isInputTile() && this.holdingAspect != null && this.holdingAspect.equals(aspect);
    }

    public int addToContainer(Aspect aspect, int amount) {
        if (amount == 0) {
            return amount;
        }
        if (!this.isInputTile()) {
            return 0;
        }
        if (aspect == null) {
            return 0;
        }
        if (this.holdingAspect != null && this.amount < this.getMaxAmount() && aspect == this.holdingAspect) {
            int added = Math.min(amount, this.getMaxAmount() - this.amount);
            this.amount += added;
            amount -= added;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
        return amount;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        if (!this.isInputTile()) {
            return false;
        }
        if (aspect == null || this.holdingAspect == null) {
            return false;
        }
        if (this.amount >= i && this.holdingAspect.equals(aspect)) {
            this.amount -= i;
            if (this.amount <= 0) {
                this.holdingAspect = null;
                this.amount = 0;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList aspectList) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        return this.isInputTile() && this.holdingAspect != null && this.amount >= i && aspect == this.holdingAspect;
    }

    public boolean doesContainerContain(AspectList list) {
        if (!this.isInputTile()) {
            return false;
        }
        if (this.holdingAspect == null) {
            return false;
        }
        for (Aspect a : list.getAspects()) {
            if (this.amount <= 0 || a != this.holdingAspect) continue;
            return true;
        }
        return false;
    }

    public int containerContains(Aspect aspect) {
        return 0;
    }

    public boolean isConnectable(ForgeDirection face) {
        return this.isInputTile() && face == ForgeDirection.DOWN;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return this.isInputTile() && face == ForgeDirection.DOWN;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    public void setSuction(Aspect aspect, int i) {
    }

    public Aspect getSuctionType(ForgeDirection forgeDirection) {
        return this.isInputTile() ? this.holdingAspect : null;
    }

    public int getSuctionAmount(ForgeDirection forgeDirection) {
        if (!this.isInputTile()) {
            return 0;
        }
        if (this.holdingAspect == null) {
            return 0;
        }
        return this.getMinimumSuction();
    }

    public int takeEssentia(Aspect aspect, int amt, ForgeDirection direction) {
        return 0;
    }

    public int addEssentia(Aspect aspect, int amt, ForgeDirection direction) {
        if (!this.isInputTile()) {
            return 0;
        }
        return this.canInputFrom(direction) ? this.amount - this.addToContainer(aspect, this.amount) : 0;
    }

    public Aspect getEssentiaType(ForgeDirection forgeDirection) {
        return this.isInputTile() ? this.holdingAspect : null;
    }

    public int getEssentiaAmount(ForgeDirection forgeDirection) {
        return this.isInputTile() ? this.amount : 0;
    }

    public int getMinimumSuction() {
        return 64;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public boolean isLowestTile() {
        if (this.field_145850_b == null) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return te == null || !(te instanceof TileAuraPylon);
    }
}

