/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import makeo.gadomancy.client.effect.fx.Orbital;
import makeo.gadomancy.common.blocks.tiles.SynchronizedTileEntity;
import makeo.gadomancy.common.registration.AIShutdownWhitelist;
import makeo.gadomancy.common.utils.Injector;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class TileAIShutdown
extends SynchronizedTileEntity
implements IAspectContainer,
IEssentiaTransport {
    private static final Random RAND = new Random();
    private static Map<ChunkCoordinates, List<AffectedEntity>> trackedEntities = Maps.newHashMap();
    private static AxisAlignedBB BOX = AxisAlignedBB.func_72330_a((double)-3.0, (double)-1.0, (double)-3.0, (double)4.0, (double)2.0, (double)4.0);
    private static Injector injEntityLivingBase = new Injector(EntityLivingBase.class);
    public static final int MAX_AMT = 16;
    public Orbital orbital;
    private int ticksExisted = 0;
    private int storedAmount = 0;

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b == null) {
            return;
        }
        ++this.ticksExisted;
        if (!this.field_145850_b.field_72995_K) {
            ChunkCoordinates cc = this.getCoords();
            if (!trackedEntities.containsKey(cc)) {
                trackedEntities.put(cc, Lists.newLinkedList());
            }
            if ((this.ticksExisted & 0xF) == 0) {
                this.killAI();
            }
            if ((this.ticksExisted & 7) == 0) {
                this.handleIO();
            }
            if ((this.ticksExisted & 0x1F) == 0) {
                this.drainDefaultEssentia();
            }
        }
    }

    private void drainDefaultEssentia() {
        this.storedAmount = Math.max(0, this.storedAmount - 1);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    private void handleIO() {
        TileEntity te;
        if (this.storedAmount < 16 && (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)ForgeDirection.UP)) != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(ForgeDirection.DOWN)) {
                return;
            }
            if (ic.getSuctionAmount(ForgeDirection.DOWN) < this.getSuctionAmount(ForgeDirection.UP)) {
                this.addToContainer(Aspect.ENTROPY, ic.takeEssentia(Aspect.ENTROPY, 1, ForgeDirection.DOWN));
            }
        }
    }

    private void killAI() {
        ChunkCoordinates cc = this.getCoords();
        List objEntityList = this.field_145850_b.func_72872_a(EntityLivingBase.class, BOX.func_72329_c().func_72317_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e));
        for (Object o : objEntityList) {
            if (o == null || !(o instanceof EntityLiving) || ((EntityLiving)o).field_70128_L || !this.canAffect((EntityLiving)o)) continue;
            EntityLiving el = (EntityLiving)o;
            if (this.storedAmount <= 0) {
                return;
            }
            AffectedEntity affected = this.removeAI(el);
            trackedEntities.get(cc).add(affected);
        }
    }

    private AffectedEntity removeAI(EntityLiving el) {
        boolean needsRemoval;
        Object entry;
        if (RAND.nextInt(4) == 0) {
            this.storedAmount = Math.max(0, this.storedAmount - 1);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
        UUID uu = el.func_110124_au();
        ArrayList<EntityAITasks.EntityAITaskEntry> tasks = new ArrayList<EntityAITasks.EntityAITaskEntry>(el.field_70714_bg.field_75782_a);
        ArrayList<EntityAITasks.EntityAITaskEntry> targetTasks = new ArrayList<EntityAITasks.EntityAITaskEntry>(el.field_70715_bh.field_75782_a);
        List<Class<? extends EntityAIBase>> entries = AIShutdownWhitelist.getWhitelistedAIClasses(el);
        Iterator iterator = el.field_70714_bg.field_75782_a.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry == null || !(entry instanceof EntityAITasks.EntityAITaskEntry)) continue;
            needsRemoval = true;
            for (Class<? extends EntityAIBase> aiClass : entries) {
                if (!aiClass.isAssignableFrom(((EntityAITasks.EntityAITaskEntry)entry).field_75733_a.getClass())) continue;
                needsRemoval = false;
            }
            if (!needsRemoval) continue;
            iterator.remove();
        }
        iterator = el.field_70715_bh.field_75782_a.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry == null || !(entry instanceof EntityAITasks.EntityAITaskEntry)) continue;
            needsRemoval = true;
            for (Class<? extends EntityAIBase> aiClass : entries) {
                if (!aiClass.isAssignableFrom(((EntityAITasks.EntityAITaskEntry)entry).field_75733_a.getClass())) continue;
                needsRemoval = false;
            }
            if (!needsRemoval) continue;
            iterator.remove();
        }
        injEntityLivingBase.setObject(el);
        injEntityLivingBase.setField("ignoreCollisions", (Object)true);
        injEntityLivingBase.setObject(null);
        return new AffectedEntity(uu, tasks, targetTasks);
    }

    public int getStoredEssentia() {
        return this.storedAmount;
    }

    public boolean canAffect(EntityLiving el) {
        ChunkCoordinates cc = this.getCoords();
        if (!trackedEntities.containsKey(cc)) {
            return false;
        }
        UUID uu = el.func_110124_au();
        for (AffectedEntity ae : trackedEntities.get(cc)) {
            if (!ae.eUUID.equals(uu)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        this.storedAmount = compound.func_74762_e("amount");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        compound.func_74768_a("amount", this.storedAmount);
    }

    public AspectList getAspects() {
        if (this.storedAmount <= 0) {
            return new AspectList();
        }
        return new AspectList().add(Aspect.ENTROPY, this.storedAmount);
    }

    public void setAspects(AspectList list) {
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return aspect == Aspect.ENTROPY;
    }

    public int addToContainer(Aspect aspect, int amount) {
        if (amount == 0) {
            return amount;
        }
        if (aspect == null) {
            return 0;
        }
        if (this.storedAmount < 16) {
            int added = Math.min(amount, 16 - this.storedAmount);
            this.storedAmount += added;
            amount -= added;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
        return amount;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        return false;
    }

    @Deprecated
    public boolean takeFromContainer(AspectList list) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        return false;
    }

    @Deprecated
    public boolean doesContainerContain(AspectList list) {
        return false;
    }

    public int containerContains(Aspect aspect) {
        return 0;
    }

    public boolean isConnectable(ForgeDirection direction) {
        return direction != null && direction.equals((Object)ForgeDirection.UP);
    }

    public boolean canInputFrom(ForgeDirection direction) {
        return this.isConnectable(direction);
    }

    public boolean canOutputTo(ForgeDirection direction) {
        return this.isConnectable(direction);
    }

    public void setSuction(Aspect aspect, int i) {
    }

    public Aspect getSuctionType(ForgeDirection direction) {
        if (!this.isConnectable(direction)) {
            return null;
        }
        return Aspect.ENTROPY;
    }

    public int getSuctionAmount(ForgeDirection direction) {
        if (!this.isConnectable(direction)) {
            return 0;
        }
        return this.getMinimumSuction();
    }

    public int takeEssentia(Aspect aspect, int i, ForgeDirection direction) {
        return 0;
    }

    public int addEssentia(Aspect aspect, int i, ForgeDirection direction) {
        return this.canInputFrom(direction) ? this.addToContainer(aspect, i) : 0;
    }

    public Aspect getEssentiaType(ForgeDirection direction) {
        return Aspect.ENTROPY;
    }

    public int getEssentiaAmount(ForgeDirection direction) {
        if (!this.isConnectable(direction)) {
            return 0;
        }
        return this.storedAmount;
    }

    public int getMinimumSuction() {
        return 64;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public static void removeTrackedEntity(EntityLiving entityLiving) {
        for (ChunkCoordinates cc : trackedEntities.keySet()) {
            for (AffectedEntity ae : trackedEntities.get(cc)) {
                if (!ae.eUUID.equals(entityLiving.func_110124_au())) continue;
                trackedEntities.get(cc).remove(ae);
                entityLiving.field_70714_bg.field_75782_a = ae.tasks;
                entityLiving.field_70715_bh.field_75782_a = ae.targetTasks;
                injEntityLivingBase.setObject(entityLiving);
                injEntityLivingBase.setField("ignoreCollisions", (Object)false);
                injEntityLivingBase.setObject(null);
                return;
            }
        }
    }

    public static void removeTrackedEntities(World world, int x, int y, int z) {
        ChunkCoordinates cc = new ChunkCoordinates(x, y, z);
        if (trackedEntities.containsKey(cc)) {
            for (AffectedEntity ae : trackedEntities.get(cc)) {
                for (Object objE : world.func_72910_y()) {
                    if (objE == null || !(objE instanceof EntityLiving) || ((EntityLiving)objE).field_70128_L || !((EntityLiving)objE).func_110124_au().equals(ae.eUUID)) continue;
                    ((EntityLiving)objE).field_70714_bg.field_75782_a = ae.tasks;
                    ((EntityLiving)objE).field_70715_bh.field_75782_a = ae.targetTasks;
                    injEntityLivingBase.setObject(objE);
                    injEntityLivingBase.setField("ignoreCollisions", (Object)false);
                    injEntityLivingBase.setObject(null);
                }
            }
            trackedEntities.remove(new ChunkCoordinates(x, y, z));
        }
    }

    public static class AffectedEntity {
        public final UUID eUUID;
        public List<EntityAITasks.EntityAITaskEntry> tasks;
        public List<EntityAITasks.EntityAITaskEntry> targetTasks;

        public AffectedEntity(UUID eUUID, List<EntityAITasks.EntityAITaskEntry> tasks, List<EntityAITasks.EntityAITaskEntry> targetTasks) {
            this.eUUID = eUUID;
            this.tasks = tasks;
            this.targetTasks = targetTasks;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AffectedEntity that = (AffectedEntity)o;
            return !(this.eUUID == null ? that.eUUID != null : !this.eUUID.equals(that.eUUID));
        }

        public int hashCode() {
            return this.eUUID != null ? this.eUUID.hashCode() : 0;
        }
    }
}

