/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability.bonus;

import com.xcompwiz.mystcraft.debug.DebugHierarchy;
import com.xcompwiz.mystcraft.debug.DefaultValueCallback;
import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.world.World;

public class InstabilityBonusManager {
    public static final InstabilityBonusManager ZERO = new InstabilityBonusManager();
    private static Set<IInstabilityBonusProvider> bonusproviders = new HashSet<IInstabilityBonusProvider>();
    private Set<IInstabilityBonus> bonuses = new HashSet<IInstabilityBonus>();
    private int total;
    private AgeController controller;

    public static void registerBonusProvider(IInstabilityBonusProvider provider) {
        bonusproviders.add(provider);
    }

    public InstabilityBonusManager() {
    }

    public InstabilityBonusManager(WorldProviderMyst provider, AgeController agecontroller) {
        this.controller = agecontroller;
        for (IInstabilityBonusProvider bprovider : bonusproviders) {
            bprovider.register(this, provider.field_76579_a);
        }
    }

    public void register(IInstabilityBonus provider) {
        this.bonuses.add(provider);
    }

    public int getResult() {
        return this.total;
    }

    public void tick(World world) {
        int total = 0;
        for (IInstabilityBonus bonus : this.bonuses) {
            bonus.tick(world);
            total += bonus.getValue();
        }
        this.total = total;
    }

    public boolean isInstabilityEnabled() {
        return this.controller.isInstabilityEnabled();
    }

    public void registerDebugInfo(DebugHierarchy.DebugNode node) {
        for (final IInstabilityBonus bonus : this.bonuses) {
            node.addChild(bonus.getName().replaceAll("\\.", "_").replaceAll(" ", ""), new DefaultValueCallback(){

                @Override
                public String get(ICommandSender agent) {
                    return "" + bonus.getValue();
                }
            });
        }
    }

    public static interface IInstabilityBonusProvider {
        public void register(InstabilityBonusManager var1, World var2);
    }

    public static interface IInstabilityBonus {
        public String getName();

        public int getValue();

        public void tick(World var1);
    }
}

