/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.word.DrawableWord;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.seasonal.SeasonalManager;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.words.DrawableWordManager;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class GuiUtils {
    private static List<int[]> scissors = new LinkedList<int[]>();

    public static Collection<String> getRegisteredIcons(TextureMap texturemap) {
        try {
            Map local = (Map)ObfuscationReflectionHelper.getPrivateValue(TextureMap.class, (Object)texturemap, (String[])new String[]{"mapUploadedSprites", "field_94252_e"});
            return local.keySet();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawPage(TextureManager renderEngine, float zLevel, ItemStack page, float xSize, float ySize, float x, float y) {
        GuiUtils.drawPageBackground(renderEngine, zLevel, page, xSize, ySize, x, y);
        if (Page.getSymbol(page) != null) {
            IAgeSymbol symbol2 = SymbolManager.getAgeSymbol(Page.getSymbol(page));
            GuiUtils.drawSymbol(renderEngine, zLevel, symbol2, xSize - 1.0f, x + 0.5f, y + (ySize + 1.0f - xSize) / 2.0f);
        } else if (Page.isLinkPanel(page)) {
            GuiUtils.drawGradientRect(x + xSize * 0.15f, y + ySize * 0.15f, x + xSize * 0.85f, y + ySize * 0.5f, -16777216, -16777216, zLevel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawPageBackground(TextureManager renderEngine, float zLevel, ItemStack page, float xSize, float ySize, float x, float y) {
        GL11.glDisable((int)3042);
        renderEngine.func_110577_a(Assets.GUIs.book_page_left);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (page == null) {
            GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
        }
        GuiUtils.drawTexturedModalRect(x, y, 156.0f, 0.0f, 30.0f, 40.0f, zLevel, xSize, ySize);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSymbol(TextureManager renderEngine, float zLevel, IAgeSymbol symbol2, float scale, float x, float y) {
        if (SeasonalManager.drawSymbol(renderEngine, zLevel, symbol2, scale, x, y)) {
            return;
        }
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (symbol2 == null) {
            GuiUtils.drawWord(renderEngine, zLevel, null, scale, x, y);
            return;
        }
        float s = (scale /= 2.0f) / 2.4142137f;
        float o = s * 1.4142135f;
        String[] words = symbol2.getPoem();
        if (words == null) {
            GuiUtils.drawWord(renderEngine, zLevel, DrawableWordManager.getDrawableWord(null), s * 2.0f, x + o, y + o);
            return;
        }
        if (words.length > 0) {
            GuiUtils.drawWord(renderEngine, zLevel, DrawableWordManager.getDrawableWord(words[0]), 2.0f * s, x + o, y);
        }
        if (words.length > 1) {
            GuiUtils.drawWord(renderEngine, zLevel, DrawableWordManager.getDrawableWord(words[1]), 2.0f * s, x + o * 2.0f, y + o);
        }
        if (words.length > 2) {
            GuiUtils.drawWord(renderEngine, zLevel, DrawableWordManager.getDrawableWord(words[2]), 2.0f * s, x + o, y + o * 2.0f);
        }
        if (words.length > 3) {
            GuiUtils.drawWord(renderEngine, zLevel, DrawableWordManager.getDrawableWord(words[3]), 2.0f * s, x, y + o);
        }
        GL11.glDisable((int)3042);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawWord(TextureManager renderEngine, float zLevel, DrawableWord word, float scale, float x, float y) {
        ArrayList<Integer> components = null;
        ArrayList<Integer> colors = null;
        ResourceLocation imagesource = null;
        if (word != null) {
            components = word.components();
            colors = word.colors();
            imagesource = word.imageSource();
        }
        if (imagesource == null) {
            imagesource = DrawableWord.word_components;
        }
        renderEngine.func_110577_a(imagesource);
        if (components == null || components.size() == 0) {
            components = new ArrayList();
            components.add(0);
            colors = new ArrayList();
        }
        for (int c = 0; c < components.size(); ++c) {
            int color = 0;
            if (c < colors.size()) {
                color = colors.get(c);
            } else if (colors.size() > 0) {
                color = colors.get(0);
            }
            GuiUtils.drawComponent(scale, zLevel, components.get(c), color, x, y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawComponent(float drawscale, float zLevel, int iconIndex, int color, float x, float y) {
        int iconSize = 64;
        int imgSize = 512;
        float transform = 0.001953125f;
        int iconX = iconIndex % 8 * 64;
        int iconY = iconIndex / 8 * 64;
        float fRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float fGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float fBlue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)fRed, (float)fGreen, (float)fBlue, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + drawscale), (double)zLevel, (double)((float)(iconX + 0) * 0.001953125f), (double)((float)(iconY + 64) * 0.001953125f));
        tessellator.func_78374_a((double)(x + drawscale), (double)(y + drawscale), (double)zLevel, (double)((float)(iconX + 64) * 0.001953125f), (double)((float)(iconY + 64) * 0.001953125f));
        tessellator.func_78374_a((double)(x + drawscale), (double)(y + 0.0f), (double)zLevel, (double)((float)(iconX + 64) * 0.001953125f), (double)((float)(iconY + 0) * 0.001953125f));
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel, (double)((float)(iconX + 0) * 0.001953125f), (double)((float)(iconY + 0) * 0.001953125f));
        tessellator.func_78381_a();
    }

    public static String getHoverText(IAgeSymbol symbol2) {
        if (symbol2 != null) {
            return symbol2.displayName();
        }
        return "?";
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexturedModalRect(float x, float y, float u, float v, float width, float height, float zLevel, float xSize, float ySize) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(x + 0.0f), (double)(y + ySize), (double)zLevel, (double)((u + 0.0f) * var7), (double)((v + height) * var8));
        var9.func_78374_a((double)(x + xSize), (double)(y + ySize), (double)zLevel, (double)((u + width) * var7), (double)((v + height) * var8));
        var9.func_78374_a((double)(x + xSize), (double)(y + 0.0f), (double)zLevel, (double)((u + width) * var7), (double)((v + 0.0f) * var8));
        var9.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel, (double)((u + 0.0f) * var7), (double)((v + 0.0f) * var8));
        var9.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getIconSafe(IIcon icon) {
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawIcon(int x, int y, IIcon icon, int xSize, int ySize, double zLevel) {
        if (icon == null) {
            LoggerUtils.warn("Error attepting to render icon: null icon object.", new Object[0]);
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + ySize), zLevel, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + xSize), (double)(y + ySize), zLevel, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + xSize), (double)(y + 0), zLevel, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), zLevel, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawIconRepeating(TextureManager render, IIcon icon, int color, int left, int top, int width, int height, float zLevel) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int x = 0;
        int y = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        for (x = 0; x < width; x += 16) {
            for (y = 0; y < height; y += 16) {
                drawWidth = Math.min(width - x, 16);
                drawHeight = Math.min(height - y, 16);
                GuiUtils.drawIcon(left + x, top + y, icon, drawWidth, drawHeight, zLevel);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawFluid(TextureManager render, Fluid fluid, int left, int top, int width, int height, float zLevel) {
        IIcon icon = fluid.getIcon();
        if (icon == null) {
            LoggerUtils.warn("Error attepting to render fluid (%s): null icon object.", fluid.getName());
            return;
        }
        int color = fluid.getColor();
        render.func_110577_a(fluid.getSpriteNumber() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
        GuiUtils.drawIconRepeating(render, icon, color, left, top, width, height, zLevel);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawFluid(TextureManager render, FluidStack fluidstack, int left, int top, int width, int height, float zLevel) {
        Fluid fluid = fluidstack.getFluid();
        IIcon icon = fluid.getIcon(fluidstack);
        if (icon == null) {
            LoggerUtils.warn("Error attepting to render fluid (%s): null icon object.", fluid.getName());
            return;
        }
        int color = fluid.getColor(fluidstack);
        render.func_110577_a(fluid.getSpriteNumber() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
        GuiUtils.drawIconRepeating(render, icon, color, left, top, width, height, zLevel);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTooltip(FontRenderer fontRenderer, int xcoord, int ycoord, float zLevel, List<String> list, int maxwidth, int maxheight) {
        if (list.size() > 0) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int width = 0;
            for (int k2 = 0; k2 < list.size(); ++k2) {
                int i3 = fontRenderer.func_78256_a(list.get(k2));
                if (i3 <= width) continue;
                width = i3;
            }
            int height = 8;
            if (list.size() > 1) {
                height += (list.size() - 1) * 10;
            }
            if (xcoord + width + 28 >= maxwidth) {
                xcoord -= width + 28;
            }
            if (ycoord + height + 6 >= maxheight) {
                ycoord -= height + 6;
            }
            zLevel = 300.0f;
            int color = -267386864;
            GuiUtils.drawGradientRect(xcoord - 3, ycoord - 4, xcoord + width + 3, ycoord - 3, color, color, zLevel);
            GuiUtils.drawGradientRect(xcoord - 3, ycoord + height + 3, xcoord + width + 3, ycoord + height + 4, color, color, zLevel);
            GuiUtils.drawGradientRect(xcoord - 3, ycoord - 3, xcoord + width + 3, ycoord + height + 3, color, color, zLevel);
            GuiUtils.drawGradientRect(xcoord - 4, ycoord - 3, xcoord - 3, ycoord + height + 3, color, color, zLevel);
            GuiUtils.drawGradientRect(xcoord + width + 3, ycoord - 3, xcoord + width + 4, ycoord + height + 3, color, color, zLevel);
            int color1 = 0x505000FF;
            int color2 = (color1 & 0xFEFEFE) >> 1 | color1 & 0xFF000000;
            GuiUtils.drawGradientRect(xcoord - 3, ycoord - 3 + 1, xcoord - 3 + 1, ycoord + height + 3 - 1, color1, color2, zLevel);
            GuiUtils.drawGradientRect(xcoord + width + 2, ycoord - 3 + 1, xcoord + width + 3, ycoord + height + 3 - 1, color1, color2, zLevel);
            GuiUtils.drawGradientRect(xcoord - 3, ycoord - 3, xcoord + width + 3, ycoord - 3 + 1, color1, color1, zLevel);
            GuiUtils.drawGradientRect(xcoord - 3, ycoord + height + 2, xcoord + width + 3, ycoord + height + 3, color2, color2, zLevel);
            for (int i = 0; i < list.size(); ++i) {
                String str = list.get(i);
                str = "\u00a7F" + str;
                fontRenderer.func_78261_a(str, xcoord, ycoord, -1);
                ycoord += 10;
            }
            zLevel = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74520_c();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGradientRect(float par1, float par2, float par3, float par4, int color1, int color2, float zLevel) {
        float var7 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(color1 & 0xFF) / 255.0f;
        float var11 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(color2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator var15 = Tessellator.field_78398_a;
        var15.func_78382_b();
        var15.func_78369_a(var8, var9, var10, var7);
        var15.func_78377_a((double)par3, (double)par2, (double)zLevel);
        var15.func_78377_a((double)par1, (double)par2, (double)zLevel);
        var15.func_78369_a(var12, var13, var14, var11);
        var15.func_78377_a((double)par1, (double)par4, (double)zLevel);
        var15.func_78377_a((double)par3, (double)par4, (double)zLevel);
        var15.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static boolean contains(int mouseX, int mouseY, int guiLeft, int guiTop, int width, int height) {
        if (mouseX < guiLeft) {
            return false;
        }
        if (mouseX >= guiLeft + width) {
            return false;
        }
        if (mouseY < guiTop) {
            return false;
        }
        return mouseY < guiTop + height;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSprite(int x, int y, int xOffset, int yOffset, float zLevel) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Assets.Vanilla.slot_tex);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + 18), (double)zLevel, (double)((float)(xOffset + 0) * 0.0078125f), (double)((float)(yOffset + 18) * 0.0078125f));
        tessellator.func_78374_a((double)(x + 18), (double)(y + 18), (double)zLevel, (double)((float)(xOffset + 18) * 0.0078125f), (double)((float)(yOffset + 18) * 0.0078125f));
        tessellator.func_78374_a((double)(x + 18), (double)(y + 0), (double)zLevel, (double)((float)(xOffset + 18) * 0.0078125f), (double)((float)(yOffset + 0) * 0.0078125f));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)zLevel, (double)((float)(xOffset + 0) * 0.0078125f), (double)((float)(yOffset + 0) * 0.0078125f));
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSprite(int x, int y, int xSize, int ySize, int xOffset, int yOffset, float zLevel) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Assets.Vanilla.slot_tex);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + ySize), (double)zLevel, (double)((float)(xOffset + 0) * 0.0078125f), (double)((float)(yOffset + 18) * 0.0078125f));
        tessellator.func_78374_a((double)(x + xSize), (double)(y + ySize), (double)zLevel, (double)((float)(xOffset + 18) * 0.0078125f), (double)((float)(yOffset + 18) * 0.0078125f));
        tessellator.func_78374_a((double)(x + xSize), (double)(y + 0), (double)zLevel, (double)((float)(xOffset + 18) * 0.0078125f), (double)((float)(yOffset + 0) * 0.0078125f));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)zLevel, (double)((float)(xOffset + 0) * 0.0078125f), (double)((float)(yOffset + 0) * 0.0078125f));
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawScaledText(String text, int x, int y, int width, int height, int textcolor) {
        GL11.glPushMatrix();
        float scale = 1.0f;
        int xPad = 0;
        int yPad = 0;
        int textWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        if (textWidth > width) {
            scale = (float)width / (float)textWidth;
        }
        GL11.glTranslatef((float)(x + xPad), (float)(y + yPad), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(text, 0, 0, textcolor);
        GL11.glPopMatrix();
    }

    public static void startGlScissor(int guiLeft, int guiTop, int xSize, int ySize) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        double scaleW = (double)mc.field_71443_c / reso.func_78327_c();
        double scaleH = (double)mc.field_71440_d / reso.func_78324_d();
        GL11.glEnable((int)3089);
        int x = (int)Math.floor((double)guiLeft * scaleW);
        int y = (int)Math.floor((double)mc.field_71440_d - (double)(guiTop + ySize) * scaleH);
        int width = (int)Math.floor((double)(guiLeft + xSize) * scaleW) - (int)Math.floor((double)guiLeft * scaleW);
        int height = (int)Math.floor((double)mc.field_71440_d - (double)guiTop * scaleH) - (int)Math.floor((double)mc.field_71440_d - (double)(guiTop + ySize) * scaleH);
        if (scissors.size() > 0) {
            int[] c = scissors.get(0);
            width = Math.min(width + x, c[2] + c[0]);
            height = Math.min(height + y, c[3] + c[1]);
            x = Math.max(x, c[0]);
            y = Math.max(y, c[1]);
            width -= x;
            height -= y;
        }
        scissors.add(0, new int[]{x, y, width, height});
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public static void endGlScissor() {
        scissors.remove(0);
        if (scissors.size() == 0) {
            GL11.glDisable((int)3089);
        } else {
            int[] c = scissors.get(0);
            GL11.glScissor((int)c[0], (int)c[1], (int)c[2], (int)c[3]);
        }
    }
}

