/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.item.IProgrammable;
import pneumaticCraft.client.AreaShowManager;
import pneumaticCraft.common.NBTUtil;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.ItemProgrammingPuzzle;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.progwidgets.IAreaProvider;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.IVariableWidget;
import pneumaticCraft.common.progwidgets.WidgetRegistrator;
import pneumaticCraft.common.tileentity.IGUITextFieldSensitive;
import pneumaticCraft.common.tileentity.TileEntityBase;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityProgrammer
extends TileEntityBase
implements IInventory,
IGUITextFieldSensitive {
    public final List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    @GuiSynced
    public int redstoneMode;
    private ItemStack[] inventory = new ItemStack[1];
    public static final int PROGRAM_SLOT = 0;
    public int translatedX;
    public int translatedY;
    public int zoomState;
    public boolean showInfo = true;
    public boolean showFlow = true;
    @GuiSynced
    public boolean canUndo;
    @GuiSynced
    public boolean canRedo;
    private NBTTagList history = new NBTTagList();
    private int historyIndex;

    public TileEntityProgrammer() {
        this.saveToHistory();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.history = tag.func_150295_c("history", 10);
        if (this.history.func_74745_c() == 0) {
            this.saveToHistory();
        }
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        this.readProgWidgetsFromNBT(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
        tag.func_74782_a("history", (NBTBase)this.history);
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        this.writeProgWidgetsToNBT(tag);
    }

    public void readProgWidgetsFromNBT(NBTTagCompound tag) {
        this.progWidgets.clear();
        TileEntityProgrammer.getWidgetsFromNBT(tag, this.progWidgets);
    }

    public void writeProgWidgetsToNBT(NBTTagCompound tag) {
        TileEntityProgrammer.setWidgetsToNBT(this.progWidgets, tag);
    }

    public static List<IProgWidget> getWidgetsFromNBT(NBTTagCompound tag) {
        ArrayList<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
        TileEntityProgrammer.getWidgetsFromNBT(tag, progWidgets);
        return progWidgets;
    }

    public static void getWidgetsFromNBT(NBTTagCompound tag, List<IProgWidget> progWidgets) {
        NBTTagList widgetTags = tag.func_150295_c("widgets", 10);
        block0: for (int i = 0; i < widgetTags.func_74745_c(); ++i) {
            NBTTagCompound widgetTag = widgetTags.func_150305_b(i);
            String widgetName = widgetTag.func_74779_i("name");
            for (IProgWidget widget : WidgetRegistrator.registeredWidgets) {
                if (!widgetName.equals(widget.getWidgetString())) continue;
                IProgWidget addedWidget = widget.copy();
                addedWidget.readFromNBT(widgetTag);
                progWidgets.add(addedWidget);
                continue block0;
            }
        }
        TileEntityProgrammer.updatePuzzleConnections(progWidgets);
    }

    public static void setWidgetsToNBT(List<IProgWidget> widgets, NBTTagCompound tag) {
        NBTTagList widgetTags = new NBTTagList();
        for (IProgWidget widget : widgets) {
            NBTTagCompound widgetTag = new NBTTagCompound();
            widget.writeToNBT(widgetTag);
            widgetTags.func_74742_a((NBTBase)widgetTag);
        }
        tag.func_74782_a("widgets", (NBTBase)widgetTags);
    }

    public static void updatePuzzleConnections(List<IProgWidget> progWidgets) {
        Class<? extends IProgWidget>[] parameters;
        for (IProgWidget widget : progWidgets) {
            widget.setParent(null);
            parameters = widget.getParameters();
            if (parameters != null) {
                for (int i = 0; i < parameters.length * 2; ++i) {
                    widget.setParameter(i, null);
                }
            }
            if (!widget.hasStepOutput()) continue;
            widget.setOutputWidget(null);
        }
        for (IProgWidget checkedWidget : progWidgets) {
            parameters = checkedWidget.getParameters();
            if (parameters != null) {
                for (IProgWidget widget : progWidgets) {
                    if (widget == checkedWidget || checkedWidget.getX() + checkedWidget.getWidth() / 2 != widget.getX()) continue;
                    for (int i = 0; i < parameters.length; ++i) {
                        if (!checkedWidget.canSetParameter(i) || parameters[i] != widget.returnType() || checkedWidget.getY() + i * 11 != widget.getY()) continue;
                        checkedWidget.setParameter(i, widget);
                        widget.setParent(checkedWidget);
                    }
                }
            }
            if (!checkedWidget.hasStepOutput()) continue;
            for (IProgWidget widget : progWidgets) {
                if (!widget.hasStepInput() || widget.getX() != checkedWidget.getX() || widget.getY() != checkedWidget.getY() + checkedWidget.getHeight() / 2) continue;
                checkedWidget.setOutputWidget(widget);
            }
        }
        for (IProgWidget checkedWidget : progWidgets) {
            if (checkedWidget.returnType() != null || (parameters = checkedWidget.getParameters()) == null) continue;
            for (int i = 0; i < parameters.length; ++i) {
                if (!checkedWidget.canSetParameter(i)) continue;
                for (IProgWidget widget : progWidgets) {
                    if (parameters[i] != widget.returnType() || widget == checkedWidget || widget.getX() + widget.getWidth() / 2 != checkedWidget.getX() || widget.getY() != checkedWidget.getY() + i * 11) continue;
                    IProgWidget root = widget;
                    while (root.getParent() != null) {
                        root = root.getParent();
                    }
                    checkedWidget.setParameter(i + parameters.length, root);
                }
            }
        }
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        switch (buttonID) {
            case 0: {
                if (++this.redstoneMode <= 1) break;
                this.redstoneMode = 0;
                break;
            }
            case 1: {
                NBTTagCompound tag;
                NBTTagCompound nBTTagCompound = tag = this.inventory[0] != null ? this.inventory[0].func_77978_p() : null;
                if (tag != null) {
                    this.readProgWidgetsFromNBT(tag);
                    break;
                }
                this.progWidgets.clear();
                break;
            }
            case 2: {
                this.tryProgramDrone(player);
                break;
            }
            case 9: {
                this.undo();
                break;
            }
            case 10: {
                this.redo();
            }
        }
        this.sendDescriptionPacket();
    }

    @Override
    public void setText(int textFieldID, String text) {
        if (textFieldID == 0 && this.inventory[0] != null) {
            this.inventory[0].func_151001_c(text);
        }
    }

    @Override
    public String getText(int textFieldID) {
        return this.inventory[0] != null ? this.inventory[0].func_82833_r() : "";
    }

    private void tryProgramDrone(EntityPlayer player) {
        if (this.inventory[0] != null) {
            NBTTagCompound tag;
            if (player == null || !player.field_71075_bZ.field_75098_d) {
                IInventory neighbor;
                List<ItemStack> requiredStacks = this.getRequiredPuzzleStacks();
                for (ItemStack stack : requiredStacks) {
                    if (this.hasEnoughPuzzleStacks(player, stack)) continue;
                    return;
                }
                for (ItemStack stack : requiredStacks) {
                    int left = stack.field_77994_a;
                    if (player != null) {
                        for (int i = 0; !(i >= player.field_71071_by.func_70302_i_() || PneumaticCraftUtils.areStacksEqual(stack, player.field_71071_by.func_70301_a(i), true, true, false, false) && (left -= player.field_71071_by.func_70298_a((int)i, (int)left).field_77994_a) <= 0); ++i) {
                        }
                    }
                    if (left <= 0) continue;
                    for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                        ItemStack neighborStack;
                        int slot;
                        neighbor = IOHelper.getInventoryForTE(this.func_145831_w().func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ));
                        int[] nArray = IOHelper.getAccessibleSlotsForInventory(neighbor, d.getOpposite());
                        int n = nArray.length;
                        for (int i = 0; !(i >= n || IOHelper.canExtractItemFromInventory(neighbor, stack, slot = nArray[i], d.getOpposite().ordinal()) && PneumaticCraftUtils.areStacksEqual(neighborStack = neighbor.func_70301_a(slot), stack, true, true, false, false) && (left -= neighbor.func_70298_a((int)slot, (int)left).field_77994_a) <= 0); ++i) {
                        }
                    }
                }
                List<ItemStack> returnedStacks = this.getReturnedPuzzleStacks();
                for (ItemStack stack : returnedStacks) {
                    for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                        neighbor = IOHelper.getInventoryForTE(this.func_145831_w().func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ));
                        stack = IOHelper.insert(neighbor, stack, d.getOpposite().ordinal(), false);
                        if (stack == null) break;
                    }
                    if (player != null && stack != null && !player.field_71071_by.func_70441_a(stack)) {
                        player.func_71019_a(stack.func_77946_l(), false);
                        stack = null;
                    }
                    if (stack == null) continue;
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, stack));
                }
            }
            if ((tag = this.inventory[0].func_77978_p()) == null) {
                tag = new NBTTagCompound();
                this.inventory[0].func_77982_d(tag);
            }
            this.writeProgWidgetsToNBT(tag);
        }
    }

    public List<ItemStack> getRequiredPuzzleStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (((IProgrammable)this.inventory[0].func_77973_b()).usesPieces(this.inventory[0])) {
            Map<Integer, Integer> tePieces = TileEntityProgrammer.getPuzzleSummary(this.progWidgets);
            Map<Integer, Integer> dronePieces = TileEntityProgrammer.getPuzzleSummary(TileEntityProgrammer.getProgWidgets(this.inventory[0]));
            for (Integer includedWidget : tePieces.keySet()) {
                Integer existingWidgets = dronePieces.get(includedWidget);
                if (existingWidgets != null) {
                    Integer neededWidgets = tePieces.get(includedWidget);
                    if (neededWidgets <= existingWidgets) continue;
                    ItemStack stack = ItemProgrammingPuzzle.getStackForColor(includedWidget);
                    stack.field_77994_a = (neededWidgets - existingWidgets) * this.inventory[0].field_77994_a;
                    stacks.add(stack);
                    continue;
                }
                ItemStack stack = ItemProgrammingPuzzle.getStackForColor(includedWidget);
                stack.field_77994_a = tePieces.get(includedWidget) * this.inventory[0].field_77994_a;
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public List<ItemStack> getReturnedPuzzleStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (((IProgrammable)this.inventory[0].func_77973_b()).usesPieces(this.inventory[0])) {
            Map<Integer, Integer> tePieces = TileEntityProgrammer.getPuzzleSummary(this.progWidgets);
            Map<Integer, Integer> dronePieces = TileEntityProgrammer.getPuzzleSummary(TileEntityProgrammer.getProgWidgets(this.inventory[0]));
            for (Integer availableWidget : dronePieces.keySet()) {
                Integer requiredWidget = tePieces.get(availableWidget);
                if (requiredWidget != null) {
                    Integer availableWidgets = dronePieces.get(availableWidget);
                    if (availableWidgets <= requiredWidget) continue;
                    ItemStack stack = ItemProgrammingPuzzle.getStackForColor(availableWidget);
                    stack.field_77994_a = (availableWidgets - requiredWidget) * this.inventory[0].field_77994_a;
                    while (stack.field_77994_a > stack.func_77976_d()) {
                        stacks.add(stack.func_77979_a(stack.func_77976_d()));
                    }
                    stacks.add(stack);
                    continue;
                }
                ItemStack stack = ItemProgrammingPuzzle.getStackForColor(availableWidget);
                stack.field_77994_a = dronePieces.get(availableWidget) * this.inventory[0].field_77994_a;
                while (stack.field_77994_a > stack.func_77976_d()) {
                    stacks.add(stack.func_77979_a(stack.func_77976_d()));
                }
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public static List<IProgWidget> getProgWidgets(ItemStack iStack) {
        if (NBTUtil.hasTag(iStack, "widgets")) {
            return TileEntityProgrammer.getWidgetsFromNBT(iStack.func_77978_p());
        }
        return new ArrayList<IProgWidget>();
    }

    public boolean hasEnoughPuzzleStacks(EntityPlayer player, ItemStack stack) {
        int amountLeft = stack.field_77994_a;
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack playerStack = player.field_71071_by.func_70301_a(i);
                if (!PneumaticCraftUtils.areStacksEqual(playerStack, stack, true, true, false, false) || (amountLeft -= playerStack.field_77994_a) > 0) continue;
                return true;
            }
        }
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            IInventory neighbor = IOHelper.getInventoryForTE(this.func_145831_w().func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ));
            for (int slot : IOHelper.getAccessibleSlotsForInventory(neighbor, d.getOpposite())) {
                ItemStack neighborStack;
                if (!IOHelper.canExtractItemFromInventory(neighbor, stack, slot, d.getOpposite().ordinal()) || !PneumaticCraftUtils.areStacksEqual(neighborStack = neighbor.func_70301_a(slot), stack, true, true, false, false) || (amountLeft -= neighborStack.field_77994_a) > 0) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<Integer, Integer> getPuzzleSummary(List<IProgWidget> widgets) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (IProgWidget widget : widgets) {
            if (widget.getCraftingColorIndex() == -1) continue;
            if (!map.containsKey(widget.getCraftingColorIndex())) {
                map.put(widget.getCraftingColorIndex(), 1);
                continue;
            }
            map.put(widget.getCraftingColorIndex(), (Integer)map.get(widget.getCraftingColorIndex()) + 1);
        }
        return map;
    }

    public Set<String> getAllVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (IProgWidget widget : this.progWidgets) {
            if (!(widget instanceof IVariableWidget)) continue;
            ((IVariableWidget)((Object)widget)).addVariables(variables);
        }
        variables.remove("");
        return variables;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        if (this.redstoneMode == 1 && slot == 0 && itemStack != null) {
            this.tryProgramDrone(null);
        }
    }

    public String func_145825_b() {
        return Blockss.programmer.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i != 0 || itemstack == null || itemstack.func_77973_b() instanceof IProgrammable && ((IProgrammable)itemstack.func_77973_b()).canProgram(itemstack);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    public boolean previewArea(int widgetX, int widgetY) {
        for (IProgWidget w : this.progWidgets) {
            if (w.getX() != widgetX || w.getY() != widgetY || !(w instanceof IAreaProvider)) continue;
            HashSet<ChunkPosition> area = new HashSet<ChunkPosition>();
            ((IAreaProvider)((Object)w)).getArea(area);
            AreaShowManager.getInstance().showArea(area, 65280, (TileEntity)this);
        }
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void saveToHistory() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeProgWidgetsToNBT(tag);
        if (this.history.func_74745_c() == 0 || !this.history.func_150305_b(this.historyIndex).equals((Object)tag)) {
            while (this.history.func_74745_c() > this.historyIndex + 1) {
                this.history.func_74744_a(this.historyIndex + 1);
            }
            this.history.func_74742_a((NBTBase)tag);
            if (this.history.func_74745_c() > 20) {
                this.history.func_74744_a(0);
            }
            this.historyIndex = this.history.func_74745_c() - 1;
            this.updateUndoRedoState();
        }
    }

    public void undo() {
        if (this.canUndo) {
            --this.historyIndex;
            this.readProgWidgetsFromNBT(this.history.func_150305_b(this.historyIndex));
            this.updateUndoRedoState();
        }
    }

    public void redo() {
        if (this.canRedo) {
            ++this.historyIndex;
            this.readProgWidgetsFromNBT(this.history.func_150305_b(this.historyIndex));
            this.updateUndoRedoState();
        }
    }

    private void updateUndoRedoState() {
        this.canUndo = this.historyIndex > 0;
        this.canRedo = this.historyIndex < this.history.func_74745_c() - 1;
    }
}

