/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.network.LazySynced;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketPlaySound;
import pneumaticCraft.common.network.PacketSetEntityMotion;
import pneumaticCraft.common.network.PacketSpawnParticle;
import pneumaticCraft.common.thirdparty.computercraft.LuaConstant;
import pneumaticCraft.common.thirdparty.computercraft.LuaMethod;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IRedstoneControl;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityAirCannon
extends TileEntityPneumaticBase
implements ISidedInventory,
IInventory,
IMinWorkingPressure,
IRedstoneControl {
    private ItemStack[] inventory;
    private final Random rand = new Random();
    @DescSynced
    @LazySynced
    public float rotationAngle;
    @DescSynced
    @LazySynced
    public float heightAngle;
    @DescSynced
    public float targetRotationAngle;
    @DescSynced
    public float targetHeightAngle;
    @GuiSynced
    public boolean doneTurning = false;
    private boolean redstonePowered = false;
    @GuiSynced
    public int gpsX;
    @GuiSynced
    public int gpsY;
    @GuiSynced
    public int gpsZ;
    @GuiSynced
    public boolean coordWithinReach;
    @GuiSynced
    public int redstoneMode;
    private int oldRangeUpgrades;
    private boolean externalControl;
    private boolean entityUpgradeInserted;
    private boolean dispenserUpgradeInserted;
    private final List<EntityItem> trackedItems = new ArrayList<EntityItem>();
    private Set<UUID> trackedItemIds;
    private ChunkPosition lastInsertingInventory;
    private ForgeDirection lastInsertingInventorySide;
    @GuiSynced
    public boolean insertingInventoryHasSpace = true;
    private final int INVENTORY_SIZE = 6;
    public final int CANNON_SLOT = 0;
    public final int GPS_SLOT = 1;
    public final int UPGRADE_SLOT_1 = 2;
    public final int UPGRADE_SLOT_2 = 3;
    public final int UPGRADE_SLOT_3 = 4;
    public final int UPGRADE_SLOT_4 = 5;

    public TileEntityAirCannon() {
        super(5.0f, 7.0f, 2000);
        this.inventory = new ItemStack[6];
        this.setUpgradeSlots(2, 3, 4, 5);
    }

    @Override
    public void func_145845_h() {
        int curRangeUpgrades;
        if (this.inventory[1] != null && this.inventory[1].func_77973_b() == Itemss.GPSTool && !this.externalControl && this.inventory[1].field_77990_d != null) {
            NBTTagCompound gpsTag = this.inventory[1].field_77990_d;
            int destinationX = gpsTag.func_74762_e("x");
            int destinationY = gpsTag.func_74762_e("y");
            int destinationZ = gpsTag.func_74762_e("z");
            if (destinationX != this.gpsX || destinationY != this.gpsY || destinationZ != this.gpsZ) {
                this.gpsX = destinationX;
                this.gpsY = destinationY;
                this.gpsZ = destinationZ;
                this.updateDestination();
            }
        }
        if ((curRangeUpgrades = Math.min(8, this.getUpgrades(8, this.getUpgradeSlots()))) != this.oldRangeUpgrades) {
            this.oldRangeUpgrades = curRangeUpgrades;
            if (!this.externalControl) {
                this.updateDestination();
            }
        }
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            boolean isEntityTrackerUpgradeInserted;
            boolean isDispenserUpgradeInserted = this.getUpgrades(1) > 0;
            boolean bl = isEntityTrackerUpgradeInserted = this.getUpgrades(3) > 0;
            if (this.dispenserUpgradeInserted != isDispenserUpgradeInserted || this.entityUpgradeInserted != isEntityTrackerUpgradeInserted) {
                this.dispenserUpgradeInserted = isDispenserUpgradeInserted;
                this.entityUpgradeInserted = isEntityTrackerUpgradeInserted;
                this.updateDestination();
            }
        }
        this.doneTurning = true;
        float speedMultiplier = this.getSpeedMultiplierFromUpgrades(this.getUpgradeSlots());
        if (this.rotationAngle < this.targetRotationAngle) {
            this.rotationAngle = this.rotationAngle < this.targetRotationAngle - 20.0f ? (this.rotationAngle += 3.0f * speedMultiplier) : (this.rotationAngle += 0.5f * speedMultiplier);
            if (this.rotationAngle > this.targetRotationAngle) {
                this.rotationAngle = this.targetRotationAngle;
            }
            this.doneTurning = false;
        }
        if (this.rotationAngle > this.targetRotationAngle) {
            this.rotationAngle = this.rotationAngle > this.targetRotationAngle + 20.0f ? (this.rotationAngle -= 3.0f * speedMultiplier) : (this.rotationAngle -= 0.5f * speedMultiplier);
            if (this.rotationAngle < this.targetRotationAngle) {
                this.rotationAngle = this.targetRotationAngle;
            }
            this.doneTurning = false;
        }
        if (this.heightAngle < this.targetHeightAngle) {
            this.heightAngle = this.heightAngle < this.targetHeightAngle - 20.0f ? (this.heightAngle += 3.0f * speedMultiplier) : (this.heightAngle += 0.5f * speedMultiplier);
            if (this.heightAngle > this.targetHeightAngle) {
                this.heightAngle = this.targetHeightAngle;
            }
            this.doneTurning = false;
        }
        if (this.heightAngle > this.targetHeightAngle) {
            this.heightAngle = this.heightAngle > this.targetHeightAngle + 20.0f ? (this.heightAngle -= 3.0f * speedMultiplier) : (this.heightAngle -= 0.5f * speedMultiplier);
            if (this.heightAngle < this.targetHeightAngle) {
                this.heightAngle = this.targetHeightAngle;
            }
            this.doneTurning = false;
        }
        this.updateTrackedItems();
        super.func_145845_h();
    }

    private void updateTrackedItems() {
        if (this.trackedItemIds != null) {
            this.trackedItems.clear();
            for (Entity entity : this.field_145850_b.field_72996_f) {
                if (!this.trackedItemIds.contains(entity.func_110124_au()) || !(entity instanceof EntityItem)) continue;
                this.trackedItems.add((EntityItem)entity);
            }
            this.trackedItemIds = null;
        }
        Iterator<EntityItem> iterator = this.trackedItems.iterator();
        block1: while (iterator.hasNext()) {
            EntityItem item = iterator.next();
            if (item.field_70170_p != this.field_145850_b || item.field_70128_L) {
                iterator.remove();
                continue;
            }
            HashMap<ChunkPosition, ForgeDirection> positions = new HashMap<ChunkPosition, ForgeDirection>();
            double range = 0.2;
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                double posX = item.field_70165_t + (double)d.offsetX * range;
                double posY = item.field_70163_u + (double)d.offsetY * range;
                double posZ = item.field_70161_v + (double)d.offsetZ * range;
                positions.put(new ChunkPosition((int)Math.floor(posX), (int)Math.floor(posY), (int)Math.floor(posZ)), d.getOpposite());
            }
            for (Map.Entry entry : positions.entrySet()) {
                ChunkPosition pos = (ChunkPosition)entry.getKey();
                TileEntity te = this.field_145850_b.func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                IInventory inv = IOHelper.getInventoryForTE(te);
                ItemStack remainder = IOHelper.insert(inv, item.func_92059_d(), ((ForgeDirection)entry.getValue()).ordinal(), false);
                if (remainder != null) {
                    item.func_92058_a(remainder);
                    continue;
                }
                item.func_70106_y();
                iterator.remove();
                this.lastInsertingInventory = new ChunkPosition(te.field_145851_c, te.field_145848_d, te.field_145849_e);
                this.lastInsertingInventorySide = (ForgeDirection)entry.getValue();
                continue block1;
            }
        }
    }

    private void updateDestination() {
        this.doneTurning = false;
        double payloadFrictionY = 0.98;
        double payloadFrictionX = 0.98;
        double payloadGravity = 0.04;
        if (this.getUpgrades(3) > 0) {
            payloadFrictionY = 0.98;
            payloadFrictionX = 0.91;
            payloadGravity = 0.08;
        } else if (this.getUpgrades(1, this.getUpgradeSlots()) > 0 && this.inventory[0] != null) {
            Item item = this.inventory[0].func_77973_b();
            if (item == Items.field_151068_bn || item == Items.field_151062_by || item == Items.field_151110_aK || item == Items.field_151126_ay) {
                payloadFrictionY = 0.99;
                payloadGravity = 0.03;
            } else if (item == Items.field_151032_g) {
                payloadFrictionY = 0.99;
                payloadGravity = 0.05;
            } else if (item == Items.field_151143_au || item == Items.field_151108_aI || item == Items.field_151140_bW || item == Items.field_151142_bV || item == Items.field_151109_aJ) {
                payloadFrictionY = 0.95;
            }
            if (item == Items.field_151068_bn) {
                payloadGravity = 0.05;
            } else if (item == Items.field_151062_by) {
                payloadGravity = 0.07;
            }
            payloadFrictionX = payloadFrictionY;
            if (item == Items.field_151124_az) {
                payloadFrictionX = 0.99;
                payloadFrictionY = 0.95;
            }
            if (item == Items.field_151063_bx) {
                payloadFrictionY = 0.98;
                payloadFrictionX = 0.91;
                payloadGravity = 0.08;
            }
        }
        double deltaX = this.gpsX - this.field_145851_c;
        double deltaZ = this.gpsZ - this.field_145849_e;
        float calculatedRotationAngle = deltaX >= 0.0 && deltaZ < 0.0 ? (float)(Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0) : (deltaX >= 0.0 && deltaZ >= 0.0 ? (float)(Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0) + 90.0f : (deltaX < 0.0 && deltaZ >= 0.0 ? (float)(Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0) + 180.0f : (float)(Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0) + 270.0f));
        double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double deltaY = this.gpsY - this.field_145848_d;
        float calculatedHeightAngle = this.calculateBestHeightAngle(distance, deltaY, this.getForce(), payloadGravity, payloadFrictionX, payloadFrictionY);
        this.setTargetAngles(calculatedRotationAngle, calculatedHeightAngle);
    }

    private float calculateBestHeightAngle(double distance, double deltaY, float force, double payloadGravity, double payloadFrictionX, double payloadFrictionY) {
        double bestAngle = 0.0;
        double bestDistance = 3.4028234663852886E38;
        if (payloadGravity == 0.0) {
            return 90.0f - (float)(Math.atan(deltaY / distance) * 180.0 / Math.PI);
        }
        for (double i = 0.7853981633974483; i < 1.5707963267948966; i += 0.001) {
            double motionX = Math.cos(i) * (double)force;
            double posX = 0.0;
            double posY = 0.0;
            for (double motionY = Math.sin(i) * (double)force; posY > deltaY || motionY > 0.0; motionY *= payloadFrictionY) {
                posX += motionX;
                posY += motionY;
                motionY -= payloadGravity;
                motionX *= payloadFrictionX;
            }
            double distanceToTarget = Math.abs(distance - posX);
            if (!(distanceToTarget < bestDistance)) continue;
            bestDistance = distanceToTarget;
            bestAngle = i;
        }
        this.coordWithinReach = bestDistance < 1.5;
        return 90.0f - (float)(bestAngle * 180.0 / Math.PI);
    }

    public synchronized void setTargetAngles(float rotationAngle, float heightAngle) {
        this.targetRotationAngle = rotationAngle;
        this.targetHeightAngle = heightAngle;
        if (!this.field_145850_b.field_72995_K) {
            this.scheduleDescriptionPacket();
        }
    }

    public double[] getVelocityVector(float angleX, float angleZ, float force) {
        double[] velocities = new double[]{Math.sin((double)angleZ / 180.0 * Math.PI), Math.cos((double)angleX / 180.0 * Math.PI), Math.cos((double)angleZ / 180.0 * Math.PI) * -1.0};
        velocities[0] = velocities[0] * Math.sin((double)angleX / 180.0 * Math.PI);
        velocities[2] = velocities[2] * Math.sin((double)angleX / 180.0 * Math.PI);
        double vectorTotal = velocities[0] * velocities[0] + velocities[1] * velocities[1] + velocities[2] * velocities[2];
        vectorTotal = (double)force / vectorTotal;
        int i = 0;
        while (i < 3) {
            int n = i++;
            velocities[n] = velocities[n] * vectorTotal;
        }
        return velocities;
    }

    public boolean hasCoordinate() {
        return this.gpsX != 0 || this.gpsY != 0 || this.gpsZ != 0;
    }

    @Override
    protected void disperseAir() {
        super.disperseAir();
        List<Pair<ForgeDirection, IAirHandler>> teList = this.getConnectedPneumatics();
        if (teList.size() == 0) {
            this.airLeak(ForgeDirection.getOrientation((int)this.func_145832_p()));
        }
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        return ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) == side;
    }

    public float getForce() {
        return 2.0f + (float)this.oldRangeUpgrades;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return Blockss.airCannon.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int i;
        super.func_145839_a(tag);
        this.redstonePowered = tag.func_74767_n("redstonePowered");
        this.targetRotationAngle = tag.func_74760_g("targetRotationAngle");
        this.targetHeightAngle = tag.func_74760_g("targetHeightAngle");
        this.rotationAngle = tag.func_74760_g("rotationAngle");
        this.heightAngle = tag.func_74760_g("heightAngle");
        this.gpsX = tag.func_74762_e("gpsX");
        this.gpsY = tag.func_74762_e("gpsY");
        this.gpsZ = tag.func_74762_e("gpsZ");
        this.redstoneMode = tag.func_74764_b("fireOnRightAngle") ? (tag.func_74767_n("fireOnRightAngle") ? 0 : 1) : (int)tag.func_74771_c("redstoneMode");
        this.coordWithinReach = tag.func_74767_n("targetWithinReach");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.trackedItemIds = new HashSet<UUID>();
        tagList = tag.func_150295_c("trackedItems", 10);
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound t = tagList.func_150305_b(i);
            this.trackedItemIds.add(new UUID(t.func_74763_f("UUIDMost"), t.func_74763_f("UUIDLeast")));
        }
        if (tag.func_74764_b("inventoryX")) {
            this.lastInsertingInventory = new ChunkPosition(tag.func_74762_e("inventoryX"), tag.func_74762_e("inventoryY"), tag.func_74762_e("inventoryZ"));
            this.lastInsertingInventorySide = ForgeDirection.getOrientation((int)tag.func_74771_c("inventorySide"));
        } else {
            this.lastInsertingInventory = null;
            this.lastInsertingInventorySide = null;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("redstonePowered", this.redstonePowered);
        tag.func_74776_a("targetRotationAngle", this.targetRotationAngle);
        tag.func_74776_a("targetHeightAngle", this.targetHeightAngle);
        tag.func_74776_a("rotationAngle", this.rotationAngle);
        tag.func_74776_a("heightAngle", this.heightAngle);
        tag.func_74768_a("gpsX", this.gpsX);
        tag.func_74768_a("gpsY", this.gpsY);
        tag.func_74768_a("gpsZ", this.gpsZ);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74757_a("targetWithinReach", this.coordWithinReach);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
        tagList = new NBTTagList();
        for (EntityItem entity : this.trackedItems) {
            UUID uuid = entity.func_110124_au();
            NBTTagCompound t = new NBTTagCompound();
            t.func_74772_a("UUIDMost", uuid.getMostSignificantBits());
            t.func_74772_a("UUIDLeast", uuid.getLeastSignificantBits());
            tagList.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("trackedItems", (NBTBase)tagList);
        if (this.lastInsertingInventory != null) {
            tag.func_74768_a("inventoryX", this.lastInsertingInventory.field_151329_a);
            tag.func_74768_a("inventoryY", this.lastInsertingInventory.field_151327_b);
            tag.func_74768_a("inventoryZ", this.lastInsertingInventory.field_151328_c);
            tag.func_74774_a("inventorySide", (byte)this.lastInsertingInventorySide.ordinal());
        }
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i == 1 && itemstack != null && itemstack.func_77973_b() != Itemss.GPSTool) {
            return false;
        }
        return i <= 1 || i > 5 || itemstack == null || itemstack.func_77973_b() == Itemss.machineUpgrade;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{1, 2, 3, 4, 5, 0};
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            if (++this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
            if (this.redstoneMode == 2 && this.getUpgrades(4) == 0) {
                this.redstoneMode = 0;
            }
        }
    }

    public void onNeighbourBlockChange(int x, int y, int z, Block block) {
        if (!(block.isAir((IBlockAccess)this.field_145850_b, x, y, z) || !this.field_145850_b.func_72864_z(x, y, z) || this.redstonePowered || this.redstoneMode == 0 && !this.doneTurning || this.redstoneMode == 2 && !this.inventoryCanCarry())) {
            this.fire();
            this.redstonePowered = true;
        } else if (!this.field_145850_b.func_72864_z(x, y, z) && this.redstonePowered) {
            this.redstonePowered = false;
        }
    }

    private boolean inventoryCanCarry() {
        this.insertingInventoryHasSpace = true;
        if (this.lastInsertingInventory == null) {
            return true;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.lastInsertingInventory.field_151329_a, this.lastInsertingInventory.field_151327_b, this.lastInsertingInventory.field_151328_c);
        IInventory inv = IOHelper.getInventoryForTE(te);
        if (inv != null) {
            ItemStack remainder = IOHelper.insert(inv, this.inventory[0].func_77946_l(), this.lastInsertingInventorySide.ordinal(), true);
            this.insertingInventoryHasSpace = remainder == null;
            return this.insertingInventoryHasSpace;
        }
        this.lastInsertingInventory = null;
        this.lastInsertingInventorySide = null;
        return true;
    }

    private synchronized boolean fire() {
        Entity itemShot = this.getCloseEntityIfUpgraded();
        if (this.getPressure(ForgeDirection.UNKNOWN) >= 2.0f && (itemShot != null || this.inventory[0] != null)) {
            double[] velocity = this.getVelocityVector(this.heightAngle, this.rotationAngle, this.getForce());
            this.addAir((int)(-500.0f * this.getForce()), ForgeDirection.UNKNOWN);
            boolean shootingInventory = false;
            if (itemShot == null) {
                shootingInventory = true;
                itemShot = this.getPayloadEntity();
                if (itemShot instanceof EntityItem) {
                    this.inventory[0] = null;
                    if (this.getUpgrades(4) > 0) {
                        this.trackedItems.add((EntityItem)itemShot);
                    }
                } else {
                    --this.inventory[0].field_77994_a;
                    if (this.inventory[0].field_77994_a <= 0) {
                        this.inventory[0] = null;
                    }
                }
            } else if (itemShot instanceof EntityPlayer) {
                EntityPlayerMP entityplayermp = (EntityPlayerMP)itemShot;
                if (entityplayermp.field_71135_a.func_147362_b().func_150724_d()) {
                    entityplayermp.func_70634_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.8, (double)this.field_145849_e + 0.5);
                }
            }
            if (itemShot.func_70115_ae()) {
                itemShot.func_70078_a((Entity)null);
            }
            itemShot.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.8, (double)this.field_145849_e + 0.5);
            NetworkHandler.sendToAllAround((IMessage)new PacketSetEntityMotion(itemShot, velocity[0], velocity[1], velocity[2]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
            if (itemShot instanceof EntityFireball) {
                velocity[0] = velocity[0] * 0.05;
                velocity[1] = velocity[1] * 0.05;
                velocity[2] = velocity[2] * 0.05;
            }
            itemShot.field_70159_w = velocity[0];
            itemShot.field_70181_x = velocity[1];
            itemShot.field_70179_y = velocity[2];
            itemShot.field_70122_E = false;
            itemShot.field_70132_H = false;
            itemShot.field_70123_F = false;
            itemShot.field_70124_G = false;
            if (itemShot instanceof EntityLivingBase) {
                ((EntityLivingBase)itemShot).func_70637_d(true);
            }
            if (shootingInventory && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72838_d(itemShot);
            }
            for (int i = 0; i < 10; ++i) {
                double velX = velocity[0] * 0.4 + (this.rand.nextGaussian() - 0.5) * 0.05;
                double velY = velocity[1] * 0.4 + (this.rand.nextGaussian() - 0.5) * 0.05;
                double velZ = velocity[2] * 0.4 + (this.rand.nextGaussian() - 0.5) * 0.05;
                NetworkHandler.sendToAllAround(new PacketSpawnParticle("largesmoke", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.7, (double)this.field_145849_e + 0.5, velX, velY, velZ), this.field_145850_b);
            }
            NetworkHandler.sendToAllAround(new PacketPlaySound("pneumaticcraft:airCannon", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, this.rand.nextFloat() / 4.0f + 0.75f, true), this.field_145850_b);
            return true;
        }
        return false;
    }

    private Entity getPayloadEntity() {
        Item item;
        if (this.getUpgrades(1, this.getUpgradeSlots()) > 0) {
            item = this.inventory[0].func_77973_b();
            if (item == Item.func_150898_a((Block)Blocks.field_150335_W)) {
                EntityTNTPrimed tnt = new EntityTNTPrimed(this.field_145850_b);
                tnt.field_70516_a = 80;
                return tnt;
            }
            if (item == Items.field_151062_by) {
                return new EntityExpBottle(this.field_145850_b);
            }
            if (item == Items.field_151068_bn) {
                EntityPotion potion = new EntityPotion(this.field_145850_b);
                potion.func_82340_a(this.inventory[0].func_77960_j());
                return potion;
            }
            if (item == Items.field_151032_g) {
                return new EntityArrow(this.field_145850_b);
            }
            if (item == Items.field_151110_aK) {
                return new EntityEgg(this.field_145850_b);
            }
            if (item == Items.field_151126_ay) {
                return new EntitySnowball(this.field_145850_b);
            }
            if (item == Items.field_151063_bx) {
                return ItemMonsterPlacer.func_77840_a((World)this.field_145850_b, (int)this.inventory[0].func_77960_j(), (double)0.0, (double)0.0, (double)0.0);
            }
            if (item == Items.field_151143_au) {
                return new EntityMinecartEmpty(this.field_145850_b);
            }
            if (item == Items.field_151108_aI) {
                return new EntityMinecartChest(this.field_145850_b);
            }
            if (item == Items.field_151109_aJ) {
                return new EntityMinecartFurnace(this.field_145850_b);
            }
            if (item == Items.field_151140_bW) {
                return new EntityMinecartHopper(this.field_145850_b);
            }
            if (item == Items.field_151142_bV) {
                return new EntityMinecartTNT(this.field_145850_b);
            }
            if (item == Items.field_151124_az) {
                return new EntityBoat(this.field_145850_b);
            }
        }
        item = new EntityItem(this.field_145850_b);
        item.func_92058_a(this.inventory[0].func_77946_l());
        item.field_70292_b = 4800;
        item.lifespan += Math.min(this.getUpgrades(2, this.getUpgradeSlots()) * 600, 4800);
        return item;
    }

    private Entity getCloseEntityIfUpgraded() {
        int entityUpgrades = this.getUpgrades(3);
        if (entityUpgrades > 0) {
            entityUpgrades = Math.min(entityUpgrades, 5);
            List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - entityUpgrades), (double)(this.field_145848_d - entityUpgrades), (double)(this.field_145849_e - entityUpgrades), (double)(this.field_145851_c + 1 + entityUpgrades), (double)(this.field_145848_d + 1 + entityUpgrades), (double)(this.field_145849_e + 1 + entityUpgrades)));
            Entity closestEntity = null;
            for (Entity entity : entities) {
                if (closestEntity != null && !(PneumaticCraftUtils.distBetween(closestEntity.field_70165_t, closestEntity.field_70163_u, closestEntity.field_70161_v, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) > PneumaticCraftUtils.distBetween(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5))) continue;
                closestEntity = entity;
            }
            return closestEntity;
        }
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public String getType() {
        return "airCannon";
    }

    @Override
    protected void addLuaMethods() {
        super.addLuaMethods();
        this.luaMethods.add(new LuaConstant("getMinWorkingPressure", 2.0f));
        this.luaMethods.add(new LuaMethod("setTargetLocation"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 3) {
                    TileEntityAirCannon.this.gpsX = ((Double)args[0]).intValue();
                    TileEntityAirCannon.this.gpsY = ((Double)args[1]).intValue();
                    TileEntityAirCannon.this.gpsZ = ((Double)args[2]).intValue();
                    TileEntityAirCannon.this.updateDestination();
                    return new Object[]{TileEntityAirCannon.this.coordWithinReach};
                }
                throw new IllegalArgumentException("setTargetLocation requires 3 parameters (x,y,z)");
            }
        });
        this.luaMethods.add(new LuaMethod("fire"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{TileEntityAirCannon.this.fire()};
                }
                throw new IllegalArgumentException("fire doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("isDoneTurning"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{TileEntityAirCannon.this.doneTurning};
                }
                throw new IllegalArgumentException("isDoneTurning doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("setRotationAngle"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityAirCannon.this.setTargetAngles(((Double)args[0]).floatValue(), TileEntityAirCannon.this.targetHeightAngle);
                    return null;
                }
                throw new IllegalArgumentException("setRotationAngle does take one argument!");
            }
        });
        this.luaMethods.add(new LuaMethod("setHeightAngle"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityAirCannon.this.setTargetAngles(TileEntityAirCannon.this.targetRotationAngle, 90.0f - ((Double)args[0]).floatValue());
                    return null;
                }
                throw new IllegalArgumentException("setHeightAngle does take one argument!");
            }
        });
        this.luaMethods.add(new LuaMethod("setExternalControl"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityAirCannon.this.externalControl = (Boolean)args[0];
                    return null;
                }
                throw new IllegalArgumentException("setExternalControl does take one argument!");
            }
        });
    }

    @Override
    public float getMinWorkingPressure() {
        return 2.0f;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }
}

