/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.cofh;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.drone.IBlockInteractHandler;
import pneumaticCraft.api.drone.ICustomBlockInteract;
import pneumaticCraft.api.drone.IDrone;
import pneumaticCraft.common.thirdparty.cofh.CoFHCore;
import pneumaticCraft.lib.Textures;

public class DroneInteractRFImport
implements ICustomBlockInteract {
    @Override
    public String getName() {
        return "rfImport";
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_RF_IM;
    }

    @Override
    public boolean doInteract(ChunkPosition pos, IDrone drone, IBlockInteractHandler interactHandler, boolean simulate) {
        IEnergyStorage droneEnergy = CoFHCore.getEnergyStorage(drone);
        if (droneEnergy.getEnergyStored() == droneEnergy.getMaxEnergyStored()) {
            interactHandler.abort();
            return false;
        }
        TileEntity te = drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        if (te instanceof IEnergyProvider) {
            IEnergyProvider provider = (IEnergyProvider)te;
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                int transferedEnergy;
                if (!interactHandler.getSides()[d.ordinal()] || (transferedEnergy = droneEnergy.receiveEnergy(provider.extractEnergy(d, interactHandler.useCount() ? interactHandler.getRemainingCount() : Integer.MAX_VALUE, true), true)) <= 0) continue;
                if (!simulate) {
                    interactHandler.decreaseCount(transferedEnergy);
                    droneEnergy.receiveEnergy(transferedEnergy, false);
                    provider.extractEnergy(d, transferedEnergy, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int getCraftingColorIndex() {
        return 4;
    }
}

