/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetDigAndPlace;
import pneumaticCraft.common.ai.DroneAIBlockInteraction;
import pneumaticCraft.common.progwidgets.IBlockOrdered;
import pneumaticCraft.common.progwidgets.IMaxActions;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;

public abstract class ProgWidgetDigAndPlace
extends ProgWidgetAreaItemBase
implements IBlockOrdered,
IMaxActions {
    private IBlockOrdered.EnumOrder order;
    private int maxActions = 1;
    private boolean useMaxActions;

    @Override
    public IBlockOrdered.EnumOrder getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(IBlockOrdered.EnumOrder order) {
        this.order = order;
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add("Order: " + this.order.getLocalizedName());
    }

    public ProgWidgetDigAndPlace(IBlockOrdered.EnumOrder order) {
        this.order = order;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetDigAndPlace<ProgWidgetDigAndPlace>(this, guiProgrammer);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("order", this.order.ordinal());
        tag.func_74757_a("useMaxActions", this.useMaxActions);
        tag.func_74768_a("maxActions", this.maxActions);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.order = IBlockOrdered.EnumOrder.values()[tag.func_74762_e("order")];
        this.useMaxActions = tag.func_74767_n("useMaxActions");
        this.maxActions = tag.func_74762_e("maxActions");
    }

    @Override
    public String getExtraStringInfo() {
        return this.order.getLocalizedName();
    }

    @Override
    public void setMaxActions(int maxActions) {
        this.maxActions = maxActions;
    }

    @Override
    public int getMaxActions() {
        return this.maxActions;
    }

    @Override
    public void setUseMaxActions(boolean useMaxActions) {
        this.useMaxActions = useMaxActions;
    }

    @Override
    public boolean useMaxActions() {
        return this.useMaxActions;
    }

    protected DroneAIBlockInteraction setupMaxActions(DroneAIBlockInteraction ai, IMaxActions widget) {
        if (widget.useMaxActions()) {
            ai.setMaxActions(widget.getMaxActions());
        }
        return ai;
    }
}

