/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import pneumaticCraft.common.block.tubes.ModuleLogistics;
import pneumaticCraft.common.block.tubes.TubeModule;
import pneumaticCraft.common.network.LocationIntPacket;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.tileentity.TileEntityPressureTube;

public class PacketUpdateLogisticModule
extends LocationIntPacket<PacketUpdateLogisticModule> {
    private int side;
    private int colorIndex;
    private int status;

    public PacketUpdateLogisticModule() {
    }

    public PacketUpdateLogisticModule(ModuleLogistics logisticsModule, int action) {
        super(logisticsModule.getTube().x(), logisticsModule.getTube().y(), logisticsModule.getTube().z());
        this.side = logisticsModule.getDirection().ordinal();
        this.colorIndex = logisticsModule.getColorChannel();
        this.status = action > 0 ? 1 + action : (logisticsModule.hasPower() ? 1 : 0);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.side);
        buf.writeByte(this.colorIndex);
        buf.writeByte(this.status);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.side = buf.readByte();
        this.colorIndex = buf.readByte();
        this.status = buf.readByte();
    }

    @Override
    public void handleClientSide(PacketUpdateLogisticModule message, EntityPlayer player) {
        TubeModule module;
        TileEntityPressureTube te = ModInteractionUtils.getInstance().getTube(message.getTileEntity(player.field_70170_p));
        if (te != null && (module = te.modules[message.side]) instanceof ModuleLogistics) {
            ((ModuleLogistics)module).onUpdatePacket(message.status, message.colorIndex);
        }
    }

    @Override
    public void handleServerSide(PacketUpdateLogisticModule message, EntityPlayer player) {
    }
}

