/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.block.pneumaticPlants.BlockPneumaticPlantBase;
import pneumaticCraft.common.item.ItemPneumatic;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketSpawnParticle;

public class ItemPlasticPlants
extends ItemPneumatic {
    public static final int SQUID_PLANT_DAMAGE = 0;
    public static final int FIRE_FLOWER_DAMAGE = 1;
    public static final int CREEPER_PLANT_DAMAGE = 2;
    public static final int SLIME_PLANT_DAMAGE = 3;
    public static final int RAIN_PLANT_DAMAGE = 4;
    public static final int ENDER_PLANT_DAMAGE = 5;
    public static final int LIGHTNING_PLANT_DAMAGE = 6;
    public static final int ADRENALINE_PLANT_DAMAGE = 7;
    public static final int BURST_PLANT_DAMAGE = 8;
    public static final int POTION_PLANT_DAMAGE = 9;
    public static final int REPULSION_PLANT_DAMAGE = 10;
    public static final int HELIUM_PLANT_DAMAGE = 11;
    public static final int CHOPPER_PLANT_DAMAGE = 12;
    public static final int MUSIC_PLANT_DAMAGE = 13;
    public static final int PROPULSION_PLANT_DAMAGE = 14;
    public static final int FLYING_FLOWER_DAMAGE = 15;
    private static Random rand = new Random();
    public static final String[] PLANT_NAMES = new String[]{"Squid Plant", "Fire Flower", "Creeper Plant", "Slime Plant", "Rain Plant", "Ender Plant", "Lightning Plant", "Adrenaline Plant", "Burst Plant", "Potion Plant", "Repulsion Plant", "Helium Plant", "Chopper Plant", "Music Plant", "Propulsion Plant", "Flying Flower"};
    public static final boolean[] NEEDS_GENERATION = new boolean[]{true, true, true, true, true, false, true, false, true, true, true, true, true, false, true, true};
    private IIcon[] texture;

    public ItemPlasticPlants() {
        this.func_77627_a(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.texture = new IIcon[16];
        this.texture[0] = this.registerSeed(reg, "pneumaticcraft:plants/squidPlant");
        this.texture[1] = this.registerSeed(reg, "pneumaticcraft:plants/fireFlower");
        this.texture[2] = this.registerSeed(reg, "pneumaticcraft:plants/creeperPlant");
        this.texture[3] = this.registerSeed(reg, "pneumaticcraft:plants/slimePlant");
        this.texture[4] = this.registerSeed(reg, "pneumaticcraft:plants/rainPlant");
        this.texture[5] = this.registerSeed(reg, "pneumaticcraft:plants/enderPlant");
        this.texture[6] = this.registerSeed(reg, "pneumaticcraft:plants/lightningPlant");
        this.texture[7] = this.registerSeed(reg, "pneumaticcraft:plants/adrenalinePlant");
        this.texture[8] = this.registerSeed(reg, "pneumaticcraft:plants/burstPlant");
        this.texture[9] = this.registerSeed(reg, "pneumaticcraft:plants/potionPlant");
        this.texture[10] = this.registerSeed(reg, "pneumaticcraft:plants/repulsionPlant");
        this.texture[11] = this.registerSeed(reg, "pneumaticcraft:plants/heliumPlant");
        this.texture[12] = this.registerSeed(reg, "pneumaticcraft:plants/chopperPlant");
        this.texture[13] = this.registerSeed(reg, "pneumaticcraft:plants/musicPlant");
        this.texture[14] = this.registerSeed(reg, "pneumaticcraft:plants/propulsionPlant");
        this.texture[15] = this.registerSeed(reg, "pneumaticcraft:plants/flyingFlower");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon registerSeed(IIconRegister register, String texture) {
        return register.func_94245_a(texture + "Seeds");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.texture[meta % 16];
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + stack.func_77960_j();
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs tab, List subItems) {
        this.addSubItems(subItems);
    }

    public void addSubItems(List items) {
        for (int i = 0; i < 16; ++i) {
            if (i == 7 || i == 13) continue;
            items.add(new ItemStack((Item)this, 1, i));
        }
    }

    public static Map<Block, ItemStack> getBlockToSeedMap() {
        HashMap<Block, ItemStack> blockToSeedMap = new HashMap<Block, ItemStack>();
        ArrayList seeds = new ArrayList();
        ((ItemPlasticPlants)Itemss.plasticPlant).addSubItems(seeds);
        for (ItemStack seed : seeds) {
            blockToSeedMap.put(ItemPlasticPlants.getPlantBlockIDFromSeed(seed.func_77960_j()), seed);
        }
        return blockToSeedMap;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        BlockPneumaticPlantBase plant = (BlockPneumaticPlantBase)ItemPlasticPlants.getPlantBlockIDFromSeed(stack.func_77960_j());
        if (side != (plant.isPlantHanging() ? 0 : 1)) {
            return false;
        }
        if (player.func_82247_a(x, y, z, side, stack) && player.func_82247_a(x, y + (plant.isPlantHanging() ? -1 : 1), z, side, stack)) {
            if (plant.func_149718_j(world, x, y + (plant.isPlantHanging() ? -1 : 1), z) && world.func_147437_c(x, y + (plant.isPlantHanging() ? -1 : 1), z)) {
                world.func_147465_d(x, y + (plant.isPlantHanging() ? -1 : 1), z, (Block)plant, 7, 3);
                --stack.field_77994_a;
                return true;
            }
            return false;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int z;
        int y;
        int x;
        MovingObjectPosition mop;
        BlockPneumaticPlantBase plant = (BlockPneumaticPlantBase)ItemPlasticPlants.getPlantBlockIDFromSeed(stack.func_77960_j());
        if (plant == Blockss.squidPlant && (mop = this.func_77621_a(world, player, true)) != null && player.func_82247_a(x = mop.field_72311_b, y = mop.field_72312_c, z = mop.field_72309_d, 1, stack) && player.func_82247_a(x, y + 1, z, 1, stack) && plant.func_149718_j(world, x, y + 1, z) && world.func_147437_c(x, y + 1, z)) {
            --stack.field_77994_a;
            world.func_147465_d(x, y + 1, z, Blockss.squidPlant, 7, 3);
        }
        return stack;
    }

    public static void onEntityConstruction(Entity entity) {
        if (entity instanceof EntityItem && ((EntityItem)entity).getExtendedProperties("PneumaticCraft_Active") == null) {
            entity.registerExtendedProperties("PneumaticCraft_Active", (IExtendedEntityProperties)new ActivityProperty(true));
        }
    }

    public static boolean isActive(EntityItem entityItem) {
        ActivityProperty prop = (ActivityProperty)entityItem.getExtendedProperties("PneumaticCraft_Active");
        return prop == null || prop.active;
    }

    public static void markInactive(EntityItem entityItem) {
        ((ActivityProperty)entityItem.getExtendedProperties((String)"PneumaticCraft_Active")).active = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List infoList, boolean par4) {
        infoList.add(EnumChatFormatting.RED + "Plastic plants are being removed in favor of Oil!");
        infoList.add(EnumChatFormatting.RED + "They only exist still to provide a smooth transition towards the Oil system!");
        switch (stack.func_77960_j()) {
            case 0: {
                infoList.add("Soil: Water");
                break;
            }
            case 1: 
            case 11: {
                infoList.add("Soil: Netherrack");
                break;
            }
            case 5: {
                infoList.add("Soil: End Stone");
                break;
            }
            default: {
                infoList.add("Soil: Dirt, Grass or Farmland");
            }
        }
        infoList.add(I18n.func_135052_a((String)"gui.tooltip.plasticPlant.plant", (Object[])new Object[0]));
    }

    public static Block getPlantBlockIDFromSeed(int seedMetadata) {
        switch (seedMetadata % 16) {
            case 0: {
                return Blockss.squidPlant;
            }
            case 1: {
                return Blockss.fireFlower;
            }
            case 2: {
                return Blockss.creeperPlant;
            }
            case 3: {
                return Blockss.slimePlant;
            }
            case 4: {
                return Blockss.rainPlant;
            }
            case 5: {
                return Blockss.enderPlant;
            }
            case 6: {
                return Blockss.lightningPlant;
            }
            case 7: {
                return Blockss.adrenalinePlant;
            }
            case 8: {
                return Blockss.burstPlant;
            }
            case 9: {
                return Blockss.potionPlant;
            }
            case 10: {
                return Blockss.repulsionPlant;
            }
            case 11: {
                return Blockss.heliumPlant;
            }
            case 12: {
                return Blockss.chopperPlant;
            }
            case 13: {
                return Blockss.musicPlant;
            }
            case 14: {
                return Blockss.propulsionPlant;
            }
            case 15: {
                return Blockss.flyingFlower;
            }
        }
        throw new IllegalArgumentException("[PneumaticCraft] Wrong metadata for seed! Meta: " + seedMetadata);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        boolean isDelayOver;
        MotionProperties motProps = (MotionProperties)entityItem.getExtendedProperties("plasticPlant");
        double oldMotionX = entityItem.field_70159_w;
        double oldMotionY = entityItem.field_70181_x;
        double oldMotionZ = entityItem.field_70179_y;
        if (motProps != null) {
            oldMotionX = motProps.oldMotionX;
            oldMotionY = motProps.oldMotionY;
            oldMotionZ = motProps.oldMotionZ;
        }
        ItemStack stack = entityItem.func_92059_d();
        int itemDamage = stack.func_77960_j();
        if (motProps == null && (itemDamage % 16 == 14 || itemDamage % 16 == 10)) {
            motProps = new MotionProperties();
            entityItem.registerExtendedProperties("plasticPlant", (IExtendedEntityProperties)motProps);
        }
        if (motProps != null) {
            motProps.update((Entity)entityItem);
        }
        boolean bl = isDelayOver = ItemPlasticPlants.isActive(entityItem) || entityItem.field_70292_b > 60 && entityItem.field_145804_b == 0;
        if (entityItem.field_70122_E || Math.abs(entityItem.field_70181_x) < 0.13 && (itemDamage % 16 == 11 || itemDamage % 16 == 0)) {
            if (!this.handleRepulsionBehaviour(entityItem, oldMotionX, oldMotionY, oldMotionZ)) {
                return false;
            }
            if (!this.handlePropulsionBehaviour(entityItem, oldMotionX, oldMotionZ)) {
                return false;
            }
            if (!entityItem.field_70170_p.field_72995_K) {
                Block blockID = ItemPlasticPlants.getPlantBlockIDFromSeed(itemDamage % 16);
                int landedBlockX = (int)Math.floor(entityItem.field_70165_t);
                int landedBlockY = (int)Math.floor(entityItem.field_70163_u);
                int landedBlockZ = (int)Math.floor(entityItem.field_70161_v);
                boolean canSustain = false;
                canSustain = ((BlockPneumaticPlantBase)blockID).func_149718_j(entityItem.field_70170_p, landedBlockX, landedBlockY, landedBlockZ);
                if (itemDamage % 16 == 1 && !canSustain && !this.isInChamber(entityItem.field_70170_p.func_147439_a(landedBlockX, landedBlockY - 1, landedBlockZ)) && Blocks.field_150480_ab.func_149742_c(entityItem.field_70170_p, landedBlockX, landedBlockY, landedBlockZ) && entityItem.field_70170_p.func_147437_c(landedBlockX, landedBlockY, landedBlockZ)) {
                    entityItem.field_70170_p.func_147449_b(landedBlockX, landedBlockY, landedBlockZ, (Block)Blocks.field_150480_ab);
                }
                if (canSustain && isDelayOver && entityItem.field_70170_p.func_147437_c(landedBlockX, landedBlockY, landedBlockZ)) {
                    entityItem.field_70170_p.func_147465_d(landedBlockX, landedBlockY, landedBlockZ, blockID, itemDamage > 15 || !ItemPlasticPlants.isActive(entityItem) ? 0 : 7, 3);
                    entityItem.func_85030_a("mob.chicken.plop", 1.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                    for (int i = 0; i < 10; ++i) {
                        this.spawnParticle(entityItem.field_70170_p, "explode", entityItem.field_70165_t + rand.nextDouble() - 0.5, entityItem.field_70163_u + rand.nextDouble() - 0.5, entityItem.field_70161_v + rand.nextDouble() - 0.5, 0.0, 0.0, 0.0);
                    }
                    if (stack.field_77994_a == 1) {
                        entityItem.func_70106_y();
                    } else {
                        --stack.field_77994_a;
                    }
                }
            }
        }
        if (itemDamage % 16 == 0 && entityItem.field_70170_p.func_72875_a(entityItem.field_70121_D.func_72331_e(0.003, 0.003, 0.003), Material.field_151586_h)) {
            entityItem.field_70181_x += 0.06;
        }
        if (itemDamage % 16 == 11) {
            entityItem.field_70181_x += 0.08;
        }
        if (itemDamage % 16 == 15) {
            entityItem.field_70181_x += 0.04;
            if (entityItem.field_70292_b % 60 == 0) {
                entityItem.field_70159_w += (rand.nextDouble() - 0.5) * 0.1;
                entityItem.field_70181_x += (rand.nextDouble() - 0.6) * 0.1;
                entityItem.field_70179_y += (rand.nextDouble() - 0.5) * 0.1;
            }
        }
        return false;
    }

    private boolean isInChamber(Block block) {
        return block == Blockss.pressureChamberInterface || block == Blockss.pressureChamberValve || block == Blockss.pressureChamberWall;
    }

    private boolean handlePropulsionBehaviour(EntityItem entityItem, double oldMotionX, double oldMotionZ) {
        int itemDamage = entityItem.func_92059_d().func_77960_j();
        if (itemDamage == 14) {
            boolean flag;
            boolean bl = flag = Math.sqrt(entityItem.field_70159_w * entityItem.field_70159_w + entityItem.field_70179_y * entityItem.field_70179_y) < 0.1;
            if (Math.sqrt(entityItem.field_70159_w * entityItem.field_70159_w + entityItem.field_70179_y * entityItem.field_70179_y) < 0.3 && entityItem.field_70173_aa < 200) {
                entityItem.field_70159_w = oldMotionX * 1.1;
                entityItem.field_70179_y = oldMotionZ * 1.1;
            }
            return flag;
        }
        return true;
    }

    private boolean handleRepulsionBehaviour(EntityItem entityItem, double oldMotionX, double oldMotionY, double oldMotionZ) {
        int itemDamage = entityItem.func_92059_d().func_77960_j();
        if (itemDamage == 10) {
            if (oldMotionY < -0.2) {
                entityItem.field_70159_w = oldMotionX;
                entityItem.field_70181_x = -oldMotionY;
                entityItem.field_70179_y = oldMotionZ;
                return false;
            }
            if (oldMotionY > 0.0) {
                return false;
            }
        }
        return true;
    }

    private void spawnParticle(World world, String particleName, double spawnX, double spawnY, double spawnZ, double spawnMotX, double spawnMotY, double spawnMotZ) {
        NetworkHandler.sendToAllAround(new PacketSpawnParticle(particleName, spawnX, spawnY, spawnZ, spawnMotX, spawnMotY, spawnMotZ), world);
    }

    public static class MotionProperties
    implements IExtendedEntityProperties {
        public double oldMotionX;
        public double oldMotionY;
        public double oldMotionZ;

        public void saveNBTData(NBTTagCompound compound) {
        }

        public void loadNBTData(NBTTagCompound compound) {
        }

        public void init(Entity entity, World world) {
        }

        public void update(Entity entity) {
            this.oldMotionX = entity.field_70165_t - entity.field_70169_q;
            this.oldMotionY = entity.field_70163_u - entity.field_70167_r;
            this.oldMotionZ = entity.field_70161_v - entity.field_70166_s;
        }
    }

    public static class ActivityProperty
    implements IExtendedEntityProperties {
        public boolean active;

        public ActivityProperty(boolean active) {
            this.active = active;
        }

        public void saveNBTData(NBTTagCompound compound) {
            if (this.active) {
                compound.func_74757_a("PneumaticCraft_Active", this.active);
            }
        }

        public void loadNBTData(NBTTagCompound compound) {
            this.active = compound.func_74767_n("PneumaticCraft_Active");
        }

        public void init(Entity entity, World world) {
        }
    }
}

