/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import pneumaticCraft.common.config.ISubConfig;

public abstract class JsonConfig
implements ISubConfig {
    protected File file;
    private final boolean inInit;

    public JsonConfig(boolean inInit) {
        this.inInit = inInit;
    }

    @Override
    public void init(File file) throws IOException {
        this.file = file;
        if (this.inInit) {
            if (file.exists()) {
                this.readFromFile();
                this.writeToFile();
            } else {
                file.createNewFile();
                this.writeToFile();
            }
        }
    }

    @Override
    public void postInit() throws IOException {
        if (!this.inInit) {
            if (this.file.exists()) {
                this.readFromFile();
                this.writeToFile();
            } else {
                this.file.createNewFile();
                this.writeToFile();
            }
        }
    }

    public void writeToFile() throws IOException {
        JsonObject root = new JsonObject();
        this.writeToJson(root);
        String jsonString = root.toString();
        JsonParser parser = new JsonParser();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonElement el = parser.parse(jsonString);
        FileUtils.write((File)this.file, (CharSequence)gson.toJson(el));
    }

    private void readFromFile() throws IOException {
        JsonParser parser = new JsonParser();
        JsonObject root = (JsonObject)parser.parse(FileUtils.readFileToString((File)this.file));
        this.readFromJson(root);
    }

    protected abstract void writeToJson(JsonObject var1);

    protected abstract void readFromJson(JsonObject var1);
}

