/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.common.semiblock.IProvidingInventoryListener;
import pneumaticCraft.common.semiblock.ISpecificProvider;
import pneumaticCraft.common.semiblock.ISpecificRequester;
import pneumaticCraft.common.semiblock.SemiBlockLogistics;
import pneumaticCraft.common.util.IOHelper;

public class LogisticsManager {
    private final List<SemiBlockLogistics>[] logistics = new List[4];

    public LogisticsManager() {
        for (int i = 0; i < this.logistics.length; ++i) {
            this.logistics[i] = new ArrayList<SemiBlockLogistics>();
        }
    }

    public void clearLogistics() {
        for (List<SemiBlockLogistics> list : this.logistics) {
            list.clear();
        }
    }

    public void addLogisticFrame(SemiBlockLogistics frame) {
        this.logistics[frame.getPriority()].add(frame);
    }

    public PriorityQueue<LogisticsTask> getTasks(Object holdingStack) {
        ItemStack item = holdingStack instanceof ItemStack ? (ItemStack)holdingStack : null;
        FluidStack fluid = holdingStack instanceof FluidStack ? (FluidStack)holdingStack : null;
        PriorityQueue<LogisticsTask> tasks = new PriorityQueue<LogisticsTask>();
        for (int priority = this.logistics.length - 1; priority >= 0; --priority) {
            for (SemiBlockLogistics requester : this.logistics[priority]) {
                for (int i = 0; i < priority; ++i) {
                    for (SemiBlockLogistics provider : this.logistics[i]) {
                        int requestedAmount;
                        if (!provider.shouldProvideTo(priority)) continue;
                        if (item != null) {
                            requestedAmount = LogisticsManager.getRequestedAmount(requester, item);
                            if (requestedAmount <= 0) continue;
                            ItemStack stack = item.func_77946_l();
                            stack.field_77994_a = requestedAmount;
                            tasks.add(new LogisticsTask(provider, requester, stack));
                            return tasks;
                        }
                        if (fluid != null) {
                            requestedAmount = LogisticsManager.getRequestedAmount(requester, fluid);
                            if (requestedAmount <= 0) continue;
                            fluid = fluid.copy();
                            fluid.amount = requestedAmount;
                            tasks.add(new LogisticsTask(provider, requester, new SemiBlockLogistics.FluidStackWrapper(fluid)));
                            return tasks;
                        }
                        this.tryProvide(provider, requester, tasks);
                    }
                }
            }
        }
        return tasks;
    }

    private void tryProvide(SemiBlockLogistics provider, SemiBlockLogistics requester, PriorityQueue<LogisticsTask> tasks) {
        IInventory providingInventory = IOHelper.getInventoryForTE(provider.getTileEntity());
        if (providingInventory != null) {
            if (requester instanceof IProvidingInventoryListener) {
                ((IProvidingInventoryListener)((Object)requester)).notify(provider.getTileEntity());
            }
            for (int i = 0; i < providingInventory.func_70302_i_(); ++i) {
                int requestedAmount;
                ItemStack providingStack = providingInventory.func_70301_a(i);
                if (providingStack == null || provider instanceof ISpecificProvider && !((ISpecificProvider)((Object)provider)).canProvide(providingStack) || !IOHelper.canExtractItemFromInventory(providingInventory, providingStack, i, 0) || (requestedAmount = LogisticsManager.getRequestedAmount(requester, providingStack)) <= 0) continue;
                ItemStack stack = providingStack.func_77946_l();
                stack.field_77994_a = requestedAmount;
                tasks.add(new LogisticsTask(provider, requester, stack));
            }
        }
        if (provider.getTileEntity() instanceof IFluidHandler) {
            IFluidHandler providingTank = (IFluidHandler)provider.getTileEntity();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                int requestedAmount;
                FluidStack providingStack = providingTank.drain(d, 16000, false);
                if (providingStack == null || provider instanceof ISpecificProvider && !((ISpecificProvider)((Object)provider)).canProvide(providingStack) || !providingTank.canDrain(d, providingStack.getFluid()) || (requestedAmount = LogisticsManager.getRequestedAmount(requester, providingStack)) <= 0) continue;
                FluidStack stack = providingStack.copy();
                stack.amount = requestedAmount;
                tasks.add(new LogisticsTask(provider, requester, new SemiBlockLogistics.FluidStackWrapper(stack)));
            }
        }
    }

    public static int getRequestedAmount(SemiBlockLogistics requester, ItemStack providingStack) {
        ForgeDirection d;
        int requestedAmount;
        TileEntity te = requester.getTileEntity();
        if (!(te instanceof IInventory)) {
            return 0;
        }
        int n = requestedAmount = requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).amountRequested(providingStack) : providingStack.field_77994_a;
        if (requestedAmount == 0) {
            return 0;
        }
        providingStack = providingStack.func_77946_l();
        providingStack.field_77994_a = requestedAmount;
        ItemStack remainder = providingStack.func_77946_l();
        remainder.field_77994_a += requester.getIncomingItems(providingStack);
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        int n2 = forgeDirectionArray.length;
        for (int i = 0; i < n2 && (remainder = IOHelper.insert(te, remainder, d = forgeDirectionArray[i], true)) != null; ++i) {
        }
        if (remainder != null) {
            providingStack.field_77994_a -= remainder.field_77994_a;
        }
        if (providingStack.field_77994_a <= 0) {
            return 0;
        }
        return providingStack.field_77994_a;
    }

    public static int getRequestedAmount(SemiBlockLogistics requester, FluidStack providingStack) {
        int requestedAmount;
        int n = requestedAmount = requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).amountRequested(providingStack) : providingStack.amount;
        if (requestedAmount == 0) {
            return 0;
        }
        providingStack = providingStack.copy();
        providingStack.amount = requestedAmount;
        FluidStack remainder = providingStack.copy();
        remainder.amount += requester.getIncomingFluid(remainder.getFluid());
        TileEntity te = requester.getTileEntity();
        if (te instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)te;
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                int fluidFilled = fluidHandler.fill(d, remainder, false);
                if (fluidFilled <= 0) continue;
                remainder.amount -= fluidFilled;
                break;
            }
        }
        providingStack.amount -= remainder.amount;
        if (providingStack.amount <= 0) {
            return 0;
        }
        return providingStack.amount;
    }

    public static class LogisticsTask
    implements Comparable<LogisticsTask> {
        public final SemiBlockLogistics provider;
        public final SemiBlockLogistics requester;
        public final ItemStack transportingItem;
        public final SemiBlockLogistics.FluidStackWrapper transportingFluid;

        public LogisticsTask(SemiBlockLogistics provider, SemiBlockLogistics requester, ItemStack transportingItem) {
            this.provider = provider;
            this.requester = requester;
            this.transportingItem = transportingItem;
            this.transportingFluid = null;
        }

        public LogisticsTask(SemiBlockLogistics provider, SemiBlockLogistics requester, SemiBlockLogistics.FluidStackWrapper transportingFluid) {
            this.provider = provider;
            this.requester = requester;
            this.transportingFluid = transportingFluid;
            this.transportingItem = null;
        }

        public void informRequester() {
            if (this.transportingItem != null) {
                this.requester.informIncomingStack(this.transportingItem);
            } else {
                this.requester.informIncomingStack(this.transportingFluid);
            }
        }

        public boolean isStillValid(Object stack) {
            if (this.transportingItem != null && stack instanceof ItemStack) {
                int requestedAmount = LogisticsManager.getRequestedAmount(this.requester, (ItemStack)stack);
                return requestedAmount == ((ItemStack)stack).field_77994_a;
            }
            if (this.transportingFluid != null && stack instanceof FluidStack) {
                int requestedAmount = LogisticsManager.getRequestedAmount(this.requester, (FluidStack)stack);
                return requestedAmount == ((FluidStack)stack).amount;
            }
            return false;
        }

        @Override
        public int compareTo(LogisticsTask task) {
            int value = this.transportingItem != null ? this.transportingItem.field_77994_a * 100 : this.transportingFluid.stack.amount;
            int otherValue = task.transportingItem != null ? task.transportingItem.field_77994_a * 100 : task.transportingFluid.stack.amount;
            return otherValue - value;
        }
    }
}

