/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class DroneClaimManager {
    private static Map<Integer, DroneClaimManager> claimManagers = new HashMap<Integer, DroneClaimManager>();
    private final Map<ChunkPosition, Integer> currentPositions = new HashMap<ChunkPosition, Integer>();
    private static final int TIMEOUT = 4;

    public static DroneClaimManager getInstance(World world) {
        DroneClaimManager manager = claimManagers.get(world.field_73011_w.field_76574_g);
        if (manager == null) {
            manager = new DroneClaimManager();
            claimManagers.put(world.field_73011_w.field_76574_g, manager);
        }
        return manager;
    }

    public void update() {
        Iterator<Map.Entry<ChunkPosition, Integer>> iterator = this.currentPositions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ChunkPosition, Integer> entry = iterator.next();
            if (entry.getValue() < 4) {
                entry.setValue(entry.getValue() + 1);
                continue;
            }
            iterator.remove();
        }
    }

    public boolean isClaimed(ChunkPosition pos) {
        return this.currentPositions.containsKey(pos);
    }

    public void claim(ChunkPosition pos) {
        this.currentPositions.put(pos, 0);
    }
}

