/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.ai.DroneClaimManager;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.config.AmadronOfferPeriodicConfig;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketServerTickTime;
import pneumaticCraft.common.recipes.AmadronOfferManager;
import pneumaticCraft.common.tileentity.TileEntityElectrostaticCompressor;

public class TickHandlerPneumaticCraft {
    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            this.checkLightning(world);
            DroneClaimManager.getInstance(world).update();
            if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0 && event.world.func_72820_D() % (long)(24000 / AmadronOfferPeriodicConfig.timesPerDay) == 1L) {
                AmadronOfferManager.getInstance().shufflePeriodicOffers();
            }
            if (!event.world.field_72995_K && event.world.func_82737_E() % 100L == 0L) {
                double tickTime = MathHelper.func_76127_a((long[])MinecraftServer.func_71276_C().field_71311_j) * 1.0E-6;
                NetworkHandler.sendToDimension(new PacketServerTickTime(tickTime), event.world.field_73011_w.field_76574_g);
                if (event.world.func_82737_E() % 600L == 0L) {
                    AmadronOfferManager.getInstance().tryRestockCustomOffers();
                }
            }
        }
    }

    private void checkLightning(World world) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < world.field_73007_j.size(); ++i) {
            Entity entity = (Entity)world.field_73007_j.get(i);
            if (entity.field_70173_aa != 1 || !(entity instanceof EntityLightningBolt)) continue;
            this.handleElectrostaticGeneration(world, entity);
        }
    }

    private void handleElectrostaticGeneration(World world, Entity entity) {
        ArrayList<int[]> coordList = new ArrayList<int[]>();
        TickHandlerPneumaticCraft.getElectrostaticGrid(coordList, world, (int)Math.round(entity.field_70165_t), (int)Math.round(entity.field_70163_u), (int)Math.round(entity.field_70161_v));
        ArrayList<TileEntityElectrostaticCompressor> compressors = new ArrayList<TileEntityElectrostaticCompressor>();
        for (int[] coord : coordList) {
            TileEntity te;
            if (world.func_147439_a(coord[0], coord[1], coord[2]) != Blockss.electrostaticCompressor || !((te = world.func_147438_o(coord[0], coord[1], coord[2])) instanceof TileEntityElectrostaticCompressor)) continue;
            compressors.add((TileEntityElectrostaticCompressor)te);
        }
        for (TileEntityElectrostaticCompressor compressor : compressors) {
            compressor.addAir(200000 / compressors.size(), ForgeDirection.UNKNOWN);
            compressor.onStruckByLightning();
        }
    }

    public static void getElectrostaticGrid(List<int[]> list, World world, int x, int y, int z) {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (world.func_147439_a(x + d.offsetX, y + d.offsetY, z + d.offsetZ) != Blocks.field_150411_aY && world.func_147439_a(x + d.offsetX, y + d.offsetY, z + d.offsetZ) != Blockss.electrostaticCompressor || TickHandlerPneumaticCraft.listContainsCoord(list, x + d.offsetX, y + d.offsetY, z + d.offsetZ)) continue;
            int[] coord = new int[]{x + d.offsetX, y + d.offsetY, z + d.offsetZ};
            list.add(coord);
            TickHandlerPneumaticCraft.getElectrostaticGrid(list, world, x + d.offsetX, y + d.offsetY, z + d.offsetZ);
        }
    }

    private static boolean listContainsCoord(List<int[]> list, int x, int y, int z) {
        for (int i = 0; i < list.size(); ++i) {
            int[] coord = list.get(i);
            if (coord[0] != x || coord[1] != y || coord[2] != z) continue;
            return true;
        }
        return false;
    }
}

