/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.api.client.pneumaticHelmet.IHackableBlock;
import pneumaticCraft.api.client.pneumaticHelmet.IHackableEntity;
import pneumaticCraft.api.item.IPressurizable;
import pneumaticCraft.client.render.pneumaticArmor.UpgradeRenderHandlerList;
import pneumaticCraft.client.render.pneumaticArmor.hacking.HackableHandler;
import pneumaticCraft.common.item.ItemPneumaticArmor;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketHackingBlockFinish;
import pneumaticCraft.common.network.PacketHackingEntityFinish;
import pneumaticCraft.common.util.WorldAndCoord;

public class CommonHUDHandler {
    private final HashMap<String, CommonHUDHandler> playerHudHandlers = new HashMap();
    public int rangeUpgradesInstalled;
    public int speedUpgradesInstalled;
    public boolean[] upgradeRenderersInserted;
    public boolean[] upgradeRenderersEnabled;
    public int ticksExisted;
    public float helmetPressure;
    private int hackTime;
    private WorldAndCoord hackedBlock;
    private Entity hackedEntity;

    public CommonHUDHandler() {
        this.upgradeRenderersInserted = new boolean[UpgradeRenderHandlerList.instance().upgradeRenderers.size()];
        this.upgradeRenderersEnabled = new boolean[UpgradeRenderHandlerList.instance().upgradeRenderers.size()];
    }

    public static CommonHUDHandler getHandlerForPlayer(EntityPlayer player) {
        CommonHUDHandler handler = PneumaticCraft.proxy.getCommonHudHandler().playerHudHandlers.get(player.func_70005_c_());
        if (handler != null) {
            return handler;
        }
        PneumaticCraft.proxy.getCommonHudHandler().playerHudHandlers.put(player.func_70005_c_(), new CommonHUDHandler());
        return CommonHUDHandler.getHandlerForPlayer(player);
    }

    @SideOnly(value=Side.CLIENT)
    public static CommonHUDHandler getHandlerForPlayer() {
        return CommonHUDHandler.getHandlerForPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            if (this == PneumaticCraft.proxy.getCommonHudHandler()) {
                CommonHUDHandler.getHandlerForPlayer(player).tickEnd(event);
            } else {
                ItemStack helmetStack = player.func_82169_q(3);
                if (helmetStack != null && helmetStack.func_77973_b() == Itemss.pneumaticHelmet) {
                    this.helmetPressure = ((IPressurizable)helmetStack.func_77973_b()).getPressure(helmetStack);
                    if (this.ticksExisted == 0) {
                        this.checkHelmetInventory(helmetStack);
                    }
                    ++this.ticksExisted;
                    if (!player.field_70170_p.field_72995_K && this.ticksExisted > this.getStartupTime() && !player.field_71075_bZ.field_75098_d) {
                        ((IPressurizable)helmetStack.func_77973_b()).addAir(helmetStack, (int)(-UpgradeRenderHandlerList.instance().getAirUsage(player, false)));
                    }
                } else {
                    this.ticksExisted = 0;
                }
                if (!player.field_70170_p.field_72995_K) {
                    this.handleHacking(player);
                }
            }
        }
    }

    private void handleHacking(EntityPlayer player) {
        if (this.hackedBlock != null) {
            IHackableBlock hackableBlock = HackableHandler.getHackableForCoord(this.hackedBlock, player);
            if (hackableBlock != null) {
                if (++this.hackTime >= hackableBlock.getHackTime(this.hackedBlock.world, this.hackedBlock.x, this.hackedBlock.y, this.hackedBlock.z, player)) {
                    hackableBlock.onHackFinished(player.field_70170_p, this.hackedBlock.x, this.hackedBlock.y, this.hackedBlock.z, player);
                    PneumaticCraft.proxy.getHackTickHandler().trackBlock(this.hackedBlock, hackableBlock);
                    NetworkHandler.sendToAllAround(new PacketHackingBlockFinish(this.hackedBlock), player.field_70170_p);
                    this.setHackedBlock(null);
                }
            } else {
                this.setHackedBlock(null);
            }
        } else if (this.hackedEntity != null) {
            IHackableEntity hackableEntity = HackableHandler.getHackableForEntity(this.hackedEntity, player);
            if (hackableEntity != null) {
                if (++this.hackTime >= hackableEntity.getHackTime(this.hackedEntity, player)) {
                    hackableEntity.onHackFinished(this.hackedEntity, player);
                    PneumaticCraft.proxy.getHackTickHandler().trackEntity(this.hackedEntity, hackableEntity);
                    NetworkHandler.sendToAllAround(new PacketHackingEntityFinish(this.hackedEntity), new NetworkRegistry.TargetPoint(this.hackedEntity.field_70170_p.field_73011_w.field_76574_g, this.hackedEntity.field_70165_t, this.hackedEntity.field_70163_u, this.hackedEntity.field_70161_v, 64.0));
                    this.setHackedEntity(null);
                }
            } else {
                this.setHackedEntity(null);
            }
        }
    }

    public void checkHelmetInventory(ItemStack helmetStack) {
        ItemStack[] helmetStacks = ItemPneumaticArmor.getUpgradeStacks(helmetStack);
        this.rangeUpgradesInstalled = ItemPneumaticArmor.getUpgrades(8, helmetStack);
        this.speedUpgradesInstalled = ItemPneumaticArmor.getUpgrades(5, helmetStack);
        this.upgradeRenderersInserted = new boolean[UpgradeRenderHandlerList.instance().upgradeRenderers.size()];
        for (int i = 0; i < UpgradeRenderHandlerList.instance().upgradeRenderers.size(); ++i) {
            this.upgradeRenderersInserted[i] = UpgradeRenderHandlerList.instance().upgradeRenderers.get(i).isEnabled(helmetStacks);
        }
    }

    public int getSpeedFromUpgrades() {
        return 1 + this.speedUpgradesInstalled;
    }

    public int getStartupTime() {
        return 200 / this.getSpeedFromUpgrades();
    }

    public void setHackedBlock(WorldAndCoord blockPos) {
        this.hackedBlock = blockPos;
        this.hackedEntity = null;
        this.hackTime = 0;
    }

    public void setHackedEntity(Entity entity) {
        this.hackedEntity = entity;
        this.hackedBlock = null;
        this.hackTime = 0;
    }
}

