/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.pneumaticArmor;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.api.client.pneumaticHelmet.BlockTrackEvent;
import pneumaticCraft.api.client.pneumaticHelmet.IBlockTrackEntry;
import pneumaticCraft.api.client.pneumaticHelmet.IOptionPage;
import pneumaticCraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import pneumaticCraft.client.gui.pneumaticHelmet.GuiBlockTrackOptions;
import pneumaticCraft.client.gui.widget.GuiAnimatedStat;
import pneumaticCraft.client.render.pneumaticArmor.ArmorMessage;
import pneumaticCraft.client.render.pneumaticArmor.HUDHandler;
import pneumaticCraft.client.render.pneumaticArmor.RenderBlockTarget;
import pneumaticCraft.client.render.pneumaticArmor.SearchUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.blockTracker.BlockTrackEntryList;
import pneumaticCraft.common.CommonHUDHandler;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketDescriptionPacketRequest;

public class BlockTrackUpgradeHandler
implements IUpgradeRenderHandler {
    private static final int BLOCK_TRACKING_RANGE = 30;
    private final List<RenderBlockTarget> blockTargets = new ArrayList<RenderBlockTarget>();
    private GuiAnimatedStat blockTrackInfo;
    private int statX;
    private int statY;
    private boolean statLeftSided;
    public int[] blockTypeCount;
    private int ticksExisted;
    private int updateInterval = 20;
    private static final int MAX_TIME = 10;
    private long accTime;

    @Override
    public String getUpgradeName() {
        return "blockTracker";
    }

    @Override
    public void initConfig(Configuration config) {
        this.statX = config.get("Helmet_Options.Block_Tracker", "stat X", -1).getInt();
        this.statY = config.get("Helmet_Options.Block_Tracker", "stat Y", 46).getInt();
        this.statLeftSided = config.get("Helmet_Options.Block_Tracker", "stat leftsided", true).getBoolean(true);
    }

    @Override
    public void saveToConfig() {
        Configuration config = Config.config;
        config.load();
        config.get("Helmet_Options.Block_Tracker", "stat X", -1).set(this.blockTrackInfo.getBaseX());
        config.get("Helmet_Options.Block_Tracker", "stat Y", 46).set(this.blockTrackInfo.getBaseY());
        config.get("Helmet_Options.Block_Tracker", "stat leftsided", true).set(this.blockTrackInfo.isLeftSided());
        this.statX = this.blockTrackInfo.getBaseX();
        this.statY = this.blockTrackInfo.getBaseY();
        this.statLeftSided = this.blockTrackInfo.isLeftSided();
        config.save();
    }

    @Override
    public void update(EntityPlayer player, int rangeUpgrades) {
        int i;
        ++this.ticksExisted;
        SearchUpgradeHandler searchHandler = HUDHandler.instance().getSpecificRenderer(SearchUpgradeHandler.class);
        if (this.ticksExisted % this.updateInterval == 0) {
            int timeTaken = (int)this.accTime / this.updateInterval;
            this.updateInterval = this.updateInterval * timeTaken / 10;
            if (this.updateInterval <= 1) {
                this.updateInterval = 2;
            }
            this.accTime = 0L;
            this.ticksExisted = 0;
        }
        this.accTime -= System.currentTimeMillis();
        int blockTrackRange = 30 + Math.min(rangeUpgrades, 5) * 5;
        int baseX = (int)Math.floor(player.field_70165_t) - blockTrackRange;
        int baseY = (int)Math.floor(player.field_70163_u) - blockTrackRange + blockTrackRange * (this.ticksExisted % this.updateInterval) / (this.updateInterval / 2);
        int maxY = (int)Math.floor(player.field_70163_u) - blockTrackRange + blockTrackRange * (this.ticksExisted % this.updateInterval + 1) / (this.updateInterval / 2);
        baseY = MathHelper.func_76125_a((int)baseY, (int)0, (int)255);
        maxY = MathHelper.func_76125_a((int)maxY, (int)0, (int)255);
        int baseZ = (int)Math.floor(player.field_70161_v) - blockTrackRange;
        ChunkCache chunkCache = new ChunkCache(player.field_70170_p, baseX, baseY, baseZ, baseX + 2 * blockTrackRange, maxY, baseZ + 2 * blockTrackRange, 0);
        for (i = baseX; i <= baseX + 2 * blockTrackRange; ++i) {
            for (int j = baseY; j < maxY; ++j) {
                for (int k = baseZ; k <= baseZ + 2 * blockTrackRange; ++k) {
                    List<IBlockTrackEntry> entries;
                    TileEntity te;
                    if (player.func_70011_f((double)i, (double)j, (double)k) > (double)blockTrackRange || MinecraftForge.EVENT_BUS.post((Event)new BlockTrackEvent(player.field_70170_p, i, j, k, te = chunkCache.func_147438_o(i, j, k)))) continue;
                    if (searchHandler != null && te instanceof IInventory) {
                        searchHandler.checkInventoryForItems(te);
                    }
                    if ((entries = BlockTrackEntryList.instance.getEntriesForCoordinate((IBlockAccess)chunkCache, i, j, k, te)).isEmpty()) continue;
                    boolean inList = false;
                    for (int l = 0; l < this.blockTargets.size(); ++l) {
                        if (!this.blockTargets.get(l).isSameTarget(player.field_70170_p, i, j, k)) continue;
                        inList = true;
                        this.blockTargets.get((int)l).ticksExisted = Math.abs(this.blockTargets.get((int)l).ticksExisted);
                        this.blockTargets.get(l).setTileEntity(te);
                        break;
                    }
                    if (inList) continue;
                    boolean sentUpdate = false;
                    for (IBlockTrackEntry entry : entries) {
                        if (!entry.shouldBeUpdatedFromServer(te) || sentUpdate) continue;
                        NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(i, j, k));
                        sentUpdate = true;
                    }
                    this.addBlockTarget(new RenderBlockTarget(player.field_70170_p, player, i, j, k, te, this));
                    for (IBlockTrackEntry entry : entries) {
                        if (this.countBlockTrackersOfType(entry) != entry.spamThreshold() + 1) continue;
                        HUDHandler.instance().addMessage(new ArmorMessage(I18n.func_135052_a((String)"blockTracker.message.stopSpam", (Object[])new Object[]{I18n.func_135052_a((String)entry.getEntryName(), (Object[])new Object[0])}), new ArrayList<String>(), 60, 0x7700AA00));
                    }
                }
            }
        }
        this.accTime += System.currentTimeMillis();
        for (i = 0; i < this.blockTargets.size(); ++i) {
            RenderBlockTarget blockTarget = this.blockTargets.get(i);
            boolean wasNegative = blockTarget.ticksExisted < 0;
            blockTarget.ticksExisted += CommonHUDHandler.getHandlerForPlayer(player).getSpeedFromUpgrades();
            if (blockTarget.ticksExisted >= 0 && wasNegative) {
                blockTarget.ticksExisted = -1;
            }
            blockTarget.update();
            if (!(blockTarget.getDistanceToEntity((Entity)player) > (double)(blockTrackRange + 5)) && blockTarget.isTargetStillValid()) continue;
            if (blockTarget.ticksExisted > 0) {
                blockTarget.ticksExisted = -60;
                continue;
            }
            if (blockTarget.ticksExisted != -1) continue;
            this.removeBlockTarget(i);
            --i;
        }
        ArrayList<String> textList = new ArrayList<String>();
        RenderBlockTarget focusedTarget = null;
        for (RenderBlockTarget blockTarget : this.blockTargets) {
            if (!blockTarget.isInitialized() || !blockTarget.isPlayerLooking()) continue;
            focusedTarget = blockTarget;
            break;
        }
        if (focusedTarget != null) {
            this.blockTrackInfo.setTitle(focusedTarget.stat.getTitle());
            textList.addAll(focusedTarget.textList);
        } else {
            this.blockTrackInfo.setTitle("Current tracked blocks:");
            if (this.blockTypeCount == null || this.ticksExisted % 40 == 0) {
                this.blockTypeCount = new int[BlockTrackEntryList.instance.trackList.size()];
                for (RenderBlockTarget target : this.blockTargets) {
                    for (IBlockTrackEntry validEntry : target.getApplicableEntries()) {
                        int n = BlockTrackEntryList.instance.trackList.indexOf(validEntry);
                        this.blockTypeCount[n] = this.blockTypeCount[n] + 1;
                    }
                }
            }
            for (int i2 = 0; i2 < this.blockTypeCount.length; ++i2) {
                if (this.blockTypeCount[i2] <= 0) continue;
                textList.add(this.blockTypeCount[i2] + " " + I18n.func_135052_a((String)BlockTrackEntryList.instance.trackList.get(i2).getEntryName(), (Object[])new Object[0]));
            }
            if (textList.size() == 0) {
                textList.add("Tracking no blocks currently.");
            }
        }
        this.blockTrackInfo.setText(textList);
    }

    private void addBlockTarget(RenderBlockTarget blockTarget) {
        this.blockTargets.add(blockTarget);
    }

    private void removeBlockTarget(int index) {
        this.blockTargets.remove(index);
    }

    public int countBlockTrackersOfType(IBlockTrackEntry type) {
        int typeIndex = BlockTrackEntryList.instance.trackList.indexOf(type);
        if (this.blockTypeCount == null || typeIndex >= this.blockTypeCount.length) {
            return 0;
        }
        return this.blockTypeCount[typeIndex];
    }

    @Override
    public void render3D(float partialTicks) {
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (RenderBlockTarget blockTarget : this.blockTargets) {
            blockTarget.render(partialTicks);
        }
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    @Override
    public void render2D(float partialTicks, boolean helmetEnabled) {
    }

    @Override
    public boolean isEnabled(ItemStack[] upgradeStacks) {
        for (ItemStack stack : upgradeStacks) {
            if (stack == null || stack.func_77973_b() != Itemss.machineUpgrade || stack.func_77960_j() != 4) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.blockTypeCount = null;
        this.ticksExisted = 0;
        this.blockTrackInfo = null;
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f * (1.0f + (float)Math.min(5, rangeUpgrades) * 5.0f / 30.0f) * (float)CommonHUDHandler.getHandlerForPlayer(player).getSpeedFromUpgrades();
    }

    @Override
    public IOptionPage getGuiOptionsPage() {
        return new GuiBlockTrackOptions(this);
    }

    @Override
    public GuiAnimatedStat getAnimatedStat() {
        if (this.blockTrackInfo == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
            this.blockTrackInfo = new GuiAnimatedStat(null, "Current tracked blocks:", new ItemStack(Itemss.machineUpgrade, 1, 4), this.statX != -1 ? this.statX : sr.func_78326_a() - 2, this.statY, 0x3000AA00, null, this.statLeftSided);
            this.blockTrackInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.blockTrackInfo;
    }

    public void hack() {
        for (RenderBlockTarget target : this.blockTargets) {
            target.hack();
        }
    }

    public RenderBlockTarget getTargetForCoord(int x, int y, int z) {
        for (RenderBlockTarget target : this.blockTargets) {
            if (!target.isSameTarget(null, x, y, z)) continue;
            return target;
        }
        return null;
    }

    public boolean scroll(MouseEvent event) {
        for (RenderBlockTarget target : this.blockTargets) {
            if (!target.scroll(event)) continue;
            this.getAnimatedStat().handleMouseWheel(event.dwheel);
            return true;
        }
        return false;
    }
}

