/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui.widget;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.gui.widget.WidgetBase;
import pneumaticCraft.lib.Textures;

public class WidgetTank
extends WidgetBase {
    private final IFluidTank tank;

    public WidgetTank(int id, int x, int y, IFluidTank tank) {
        super(id, x, y, 16, 64);
        this.tank = tank;
    }

    public WidgetTank(int x, int y, FluidStack stack) {
        super(-1, x, y, 16, 64);
        this.tank = new FluidTank(stack, 16000);
    }

    public WidgetTank(int x, int y, int width, int height, FluidStack stack) {
        super(-1, x, y, width, height);
        this.tank = new FluidTank(stack, stack.amount);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        GL11.glDisable((int)2896);
        Fluid fluid = this.tank.getFluid() != null ? this.tank.getFluid().getFluid() : null;
        IIcon icon = fluid != null ? fluid.getStillIcon() : null;
        int amt = this.tank.getFluidAmount();
        int capacity = this.tank.getCapacity();
        int height = 64;
        int width = 16;
        if (fluid != null && icon != null && amt > 0 && capacity > 0) {
            double moved;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            double fluidPercentage = (double)amt / (double)capacity;
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)height, (double)0.0);
            GL11.glEnable((int)3042);
            for (double fluidHeight = (double)height * fluidPercentage; fluidHeight > 0.0; fluidHeight -= moved) {
                moved = Math.min(fluidHeight, (double)icon.func_94216_b());
                GL11.glTranslated((double)0.0, (double)(-moved), (double)0.0);
                Tessellator t = Tessellator.field_78398_a;
                t.func_78382_b();
                t.func_78378_d(fluid.getColor(this.tank.getFluid()));
                t.func_78374_a((double)this.x, (double)this.y, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g() + (double)(icon.func_94210_h() - icon.func_94206_g()) * (1.0 - moved / (double)icon.func_94216_b()));
                t.func_78374_a((double)this.x, (double)this.y + moved, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
                t.func_78374_a((double)(this.x + width), (double)this.y + moved, 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
                t.func_78374_a((double)(this.x + width), (double)this.y, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g() + (double)(icon.func_94210_h() - icon.func_94206_g()) * (1.0 - moved / (double)icon.func_94216_b()));
                t.func_78381_a();
            }
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WIDGET_TANK);
        Gui.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)16, (int)64, (float)16.0f, (float)64.0f);
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shift) {
        Fluid fluid = null;
        int amt = 0;
        int capacity = 0;
        if (this.tank.getFluid() != null) {
            fluid = this.tank.getFluid().getFluid();
            amt = this.tank.getFluidAmount();
        }
        capacity = this.tank.getCapacity();
        if (fluid == null || amt == 0 || capacity == 0) {
            curTip.add(amt + "/" + capacity + " mb");
            curTip.add(EnumChatFormatting.GRAY + I18n.func_135052_a((String)"gui.liquid.empty", (Object[])new Object[0]));
        } else {
            curTip.add(amt + "/" + capacity + " mb");
            curTip.add(EnumChatFormatting.GRAY + fluid.getLocalizedName(new FluidStack(fluid, amt)));
        }
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @SideOnly(value=Side.CLIENT)
    public FluidTank getTank() {
        return (FluidTank)this.tank;
    }
}

