/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import xaero.common.core.IXaeroMinimapModelRenderer;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.LivingEntityRotationResetter;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;

public class EntityIconPrerenderer {
    private static final ModelRenderer[] ONE_RENDERER_ARRAY = new ModelRenderer[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private ImprovedFramebuffer modelRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer iconScaleFramebuffer;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private LivingEntityRotationResetter livingEntityRotationResetter;
    public static boolean DETECTING_MODEL_RENDERS;
    private Render modelRenderDetectionEntityRenderer;
    private Class<?> modelRenderDetectionEntityModelClass;
    private List<ModelRenderDetectionElement> modelRenderDetectionList;
    private ModelRenderDetectionElement lastModelRenderDetected;
    private ByteBuffer reusableByteBuffer64 = BufferUtils.createByteBuffer((int)64);
    private FloatBuffer reusableFloatBuffer16 = this.reusableByteBuffer64.asFloatBuffer();

    public EntityIconPrerenderer() {
        this.modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.iconScaleFramebuffer = new ImprovedFramebuffer(64, 64, false);
        OpenGLException.checkGLError();
        GL11.glDeleteTextures((int)this.iconScaleFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer();
        this.livingEntityRotationResetter = new LivingEntityRotationResetter();
        this.modelRenderFramebuffer.func_147612_c();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.field_147621_c, (int)this.modelRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GL11.glBindTexture((int)3553, (int)0);
        this.iconRenderFramebuffer.func_147612_c();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_147621_c, (int)this.iconRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GL11.glBindTexture((int)3553, (int)0);
        this.modelRenderDetectionList = new ArrayList<ModelRenderDetectionElement>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.out.println("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public int prerender(Render entityRenderer, Entity entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, EntityIconModelConfig modelConfig, boolean debug) {
        EntityLivingBase livingEntity;
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        ImprovedFramebuffer iconScaleFramebuffer = this.iconScaleFramebuffer;
        int finalIconSize = iconScaleFramebuffer.field_147621_c;
        OpenGLException.checkGLError();
        modelRenderFramebuffer.func_147610_a(true);
        int farPlane = 500;
        this.setupMatrices(finalIconSize, farPlane);
        OpenGLException.checkGLError();
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DETECTING_MODEL_RENDERS = true;
        this.modelRenderDetectionEntityRenderer = entityRenderer;
        this.modelRenderDetectionEntityModelClass = null;
        this.modelRenderDetectionList.clear();
        this.lastModelRenderDetected = null;
        GL11.glDisable((int)2884);
        if (RenderManager.field_78727_a.field_78734_h != null) {
            GL11.glPushMatrix();
            try {
                entityRenderer.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
                OpenGLException.checkGLError();
            }
            catch (Exception e) {
                this.modelRenderDetectionList.clear();
                System.out.println("Exception when calling the full entity renderer before rendering the icon. " + EntityList.func_75621_b((Entity)entity));
                e.printStackTrace();
            }
            GL11.glPopMatrix();
            while (GL11.glGetError() != 0) {
            }
        } else {
            System.out.println("Render info was null for entity " + EntityList.func_75621_b((Entity)entity));
        }
        GL11.glDisable((int)2929);
        GL13.glActiveTexture((int)33985);
        GL11.glDisable((int)3553);
        GL13.glActiveTexture((int)33984);
        RenderHelper.func_74518_a();
        DETECTING_MODEL_RENDERS = false;
        ModelBase entityModel = this.getEntityRendererModel(entityRenderer);
        if (entityModel == null) {
            this.endModelRendering(modelRenderFramebuffer);
            defaultFramebuffer.func_147610_a(true);
            this.restoreMatrices(helper);
            return -1;
        }
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16640);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)2884);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        if (debug) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)10.0f, (float)-10.0f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-65536);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            GL11.glEnable((int)3042);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(finalIconSize / 2), (float)(finalIconSize / 2), (float)-450.0f);
        GL11.glTranslatef((float)modelConfig.offsetX, (float)(-modelConfig.offsetY), (float)0.0f);
        int mainScale = finalIconSize / 2;
        GL11.glScalef((float)mainScale, (float)(-mainScale), (float)(-mainScale));
        if (scale < 1.0f) {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
        GL11.glScalef((float)modelConfig.baseScale, (float)modelConfig.baseScale, (float)modelConfig.baseScale);
        GL11.glRotatef((float)modelConfig.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)modelConfig.rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)modelConfig.rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
        EntityIconDefinitions.customTransformation(entityModel, entity, this);
        EntityLivingBase entityLivingBase = livingEntity = entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        if (livingEntity != null) {
            this.livingEntityRotationResetter.rememberAndResetValues(livingEntity);
        }
        boolean renderedSomething = this.renderIcon(entityRenderer, entityModel, this.modelRenderDetectionList, entity, modelConfig);
        if (livingEntity != null) {
            this.livingEntityRotationResetter.restore(livingEntity);
        }
        EntityIconDefinitions.customPostRenderTransformation(entityModel, entity);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        if (debug) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)9.0f, (float)10.0f, (float)-10.0f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16711936);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        this.endModelRendering(modelRenderFramebuffer);
        int entityScaledIconTextureId = -1;
        if (renderedSomething) {
            iconRenderFramebuffer.func_147610_a(true);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16384);
            GL11.glDisable((int)3042);
            if (debug) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)18.0f, (float)10.0f, (float)-10.0f);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16776961);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            modelRenderFramebuffer.func_147612_c();
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)0.05f);
            GL11.glEnable((int)3042);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)1);
            for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                    if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                    helper.drawMyTexturedModalRect(shadowOffsetX, finalIconSize + shadowOffsetY, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
                }
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            if (debug) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)27.0f, (float)10.0f, (float)-10.0f);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16711681);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            GL11.glEnable((int)3042);
            iconRenderFramebuffer.func_147609_e();
            iconRenderFramebuffer.func_147612_c();
            iconRenderFramebuffer.generateMipmaps();
            GL11.glBindTexture((int)3553, (int)0);
            entityScaledIconTextureId = GL11.glGenTextures();
            OpenGLException.checkGLError();
            GL11.glBindTexture((int)3553, (int)entityScaledIconTextureId);
            EntityIconPrerenderer.setupIconTextureParams();
            OpenGLException.checkGLError();
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)iconScaleFramebuffer.field_147621_c, (int)iconScaleFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
            GL11.glBindTexture((int)3553, (int)0);
            OpenGLException.checkGLError();
            iconScaleFramebuffer.func_147610_a(true);
            iconScaleFramebuffer.setFramebufferTexture(entityScaledIconTextureId);
            iconScaleFramebuffer.func_147611_b();
            iconRenderFramebuffer.func_147612_c();
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3042);
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)36.0f, (float)10.0f, (float)-10.0f);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-256);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBindTexture((int)3553, (int)0);
        }
        this.restoreMatrices(helper);
        iconScaleFramebuffer.func_147609_e();
        defaultFramebuffer.func_147610_a(true);
        return entityScaledIconTextureId;
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)finalIconSize, (double)0.0, (double)finalIconSize, (double)-1.0, (double)farPlane);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
    }

    private void restoreMatrices(MinimapRendererHelper helper) {
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        helper.defaultOrtho();
        GL11.glMatrixMode((int)5888);
    }

    private void endModelRendering(ImprovedFramebuffer modelRenderFramebuffer) {
        modelRenderFramebuffer.func_147609_e();
        GL11.glEnable((int)3042);
        RenderHelper.func_74519_b();
        RenderHelper.func_74518_a();
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
    }

    public static void setupIconTextureParams() {
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    private ModelRenderer renderModel(Render entityRenderer, ModelBase entityModel, Entity entity, EntityIconModelConfig modelConfig, ModelRenderer mainPart, ArrayList<ModelRenderer> renderedModels, int entityTexture, boolean forceFieldCheck, boolean fullModelIcon, ModelRenderDetectionElement mrde) {
        boolean isChildBU = entityModel.field_78091_s;
        entityModel.field_78091_s = false;
        if (entityTexture > 0) {
            this.setupModelRenderType(entityTexture, mrde);
            if (modelConfig.modelMainPartFieldAliases != null && !modelConfig.modelMainPartFieldAliases.isEmpty()) {
                mainPart = this.searchSuperclassFields(entityModel, renderedModels, mainPart, modelConfig.modelMainPartFieldAliases, true, modelConfig.modelPartsRotationReset, mrde);
            }
            if (!fullModelIcon && !forceFieldCheck && entityModel instanceof ModelBiped) {
                ModelRenderer headRenderer = ((ModelBiped)entityModel).field_78116_c;
                if (mainPart == null) {
                    mainPart = headRenderer;
                }
                ModelRenderer headWearRenderer = ((ModelBiped)entityModel).field_78114_d;
                this.entityModelPartsRenderer.renderPart(headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                this.entityModelPartsRenderer.renderPart(headWearRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
            } else if (!fullModelIcon && !forceFieldCheck && entityModel instanceof ModelQuadruped) {
                ModelRenderer headRenderer = ((ModelQuadruped)entityModel).field_78150_a;
                if (headRenderer != null) {
                    if (mainPart == null) {
                        mainPart = headRenderer;
                    }
                    this.entityModelPartsRenderer.renderPart(headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
            } else {
                if (modelConfig.modelPartsFields == null) {
                    mainPart = this.searchSuperclassFields(entityModel, renderedModels, mainPart, (List<String>)EntityIconDefinitions.HEAD_HARDCODED_NAMES, true, modelConfig.modelPartsRotationReset, mrde);
                }
                Object headPartsFields = EntityIconDefinitions.HEAD_PARTS_HARDCODED_NAMES;
                if (fullModelIcon) {
                    headPartsFields = null;
                } else if (modelConfig.modelPartsFields != null) {
                    headPartsFields = modelConfig.modelPartsFields;
                }
                mainPart = this.searchSuperclassFields(entityModel, renderedModels, mainPart, (List<String>)headPartsFields, false, modelConfig.modelPartsRotationReset, mrde);
            }
            this.clearModelRenderType();
        }
        entityModel.field_78091_s = isChildBU;
        return mainPart;
    }

    private void setupModelRenderType(int entityTexture, ModelRenderDetectionElement mrde) {
        int blendAlphaSrcFactor = mrde.blendAlphaSrcFactor;
        int blendAlphaDestFactor = mrde.blendAlphaDestFactor;
        if (mrde.blendDestFactor == 1 && mrde.blendSrcFactor != 0) {
            blendAlphaSrcFactor = 0;
            blendAlphaDestFactor = 1;
        }
        GL14.glBlendFuncSeparate((int)mrde.blendSrcFactor, (int)mrde.blendDestFactor, (int)blendAlphaSrcFactor, (int)blendAlphaDestFactor);
        GL11.glColorMask((boolean)mrde.colorMaskR, (boolean)mrde.colorMaskG, (boolean)mrde.colorMaskB, (boolean)mrde.colorMaskA);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)mrde.depthMask);
        GL11.glDepthFunc((int)(mrde.depthTest ? mrde.depthFunc : 519));
        if (mrde.cullFace) {
            GL11.glEnable((int)2884);
        }
        GL11.glCullFace((int)mrde.cullMode);
        GL11.glBindTexture((int)3553, (int)entityTexture);
    }

    private void clearModelRenderType() {
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glCullFace((int)1029);
        GL11.glDisable((int)2884);
        GL11.glBindTexture((int)3553, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelBase getLivingModel(RendererLivingEntity entityRenderer) {
        boolean accessibleBU = EntityIconDefinitions.livingEntityMainModelField.isAccessible();
        try {
            EntityIconDefinitions.livingEntityMainModelField.setAccessible(true);
            ModelBase modelBase = (ModelBase)EntityIconDefinitions.livingEntityMainModelField.get(entityRenderer);
            return modelBase;
        }
        catch (Exception e) {
            e.printStackTrace();
            ModelBase modelBase = null;
            return modelBase;
        }
        finally {
            EntityIconDefinitions.livingEntityMainModelField.setAccessible(accessibleBU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelRenderer[] handleDeclaredField(Field f, ModelBase entityModel, String matchedFilterElement) throws IllegalArgumentException, IllegalAccessException {
        boolean accessibleBU = f.isAccessible();
        try {
            f.setAccessible(true);
            Object fieldValue = f.get(entityModel);
            if (fieldValue == null) {
                ModelRenderer[] modelRendererArray = null;
                return modelRendererArray;
            }
            if (fieldValue instanceof ModelRenderer[] || fieldValue instanceof Collection) {
                ModelRenderer[] collectionArray = null;
                if (fieldValue instanceof ModelRenderer[]) {
                    collectionArray = (ModelRenderer[])fieldValue;
                } else if (fieldValue instanceof Collection) {
                    Collection collection = (Collection)fieldValue;
                    try {
                        collectionArray = collection.toArray(ONE_RENDERER_ARRAY);
                    }
                    catch (ArrayStoreException ase) {
                        throw new IllegalArgumentException("Field " + f.getName() + " is not a collection of model parts (ModelRenderer on forge).", ase);
                    }
                }
                if (collectionArray.length > 0) {
                    if (matchedFilterElement != null && matchedFilterElement.endsWith("]")) {
                        int lastStartBracket = matchedFilterElement.lastIndexOf(91);
                        if (lastStartBracket == -1) {
                            throw new IllegalArgumentException("Model part field name " + matchedFilterElement + " ends with ] but is missing [!");
                        }
                        try {
                            String[] indicesString = matchedFilterElement.substring(lastStartBracket + 1, matchedFilterElement.length() - 1).split("[,;]");
                            ModelRenderer[] result = indicesString.length == 1 ? ONE_RENDERER_ARRAY : new ModelRenderer[indicesString.length];
                            for (int i = 0; i < indicesString.length; ++i) {
                                String indexString = indicesString[i];
                                int elementIndex = Integer.parseInt(indexString.trim());
                                result[i] = collectionArray[elementIndex];
                            }
                            ModelRenderer[] modelRendererArray = result;
                            return modelRendererArray;
                        }
                        catch (Exception nfe) {
                            throw new IllegalArgumentException("Invalid element index/indices in " + matchedFilterElement + "!", nfe);
                        }
                    }
                    ModelRenderer[] modelRendererArray = collectionArray;
                    return modelRendererArray;
                }
                throw new IllegalArgumentException("Empty collection referenced " + matchedFilterElement + "!");
            }
            EntityIconPrerenderer.ONE_RENDERER_ARRAY[0] = (ModelRenderer)fieldValue;
            ModelRenderer[] modelRendererArray = ONE_RENDERER_ARRAY;
            return modelRendererArray;
        }
        finally {
            f.setAccessible(accessibleBU);
        }
    }

    public ModelRenderer searchSuperclassFields(ModelBase entityModel, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Class<?> modelClass = entityModel.getClass();
        while (modelClass != ModelBase.class) {
            Field[] declaredModelFields = modelClass.getDeclaredFields();
            mainPart = this.handleFields(entityModel, declaredModelFields, renderedModels, mainPart, filter, justOne, zeroRotation, mrde);
            if ((!justOne || mainPart == null) && (modelClass = modelClass.getSuperclass()) != null) continue;
        }
        return mainPart;
    }

    public ModelRenderer handleFields(ModelBase entityModel, Field[] declaredModelFields, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        block9: for (Field f : declaredModelFields) {
            try {
                f.getType().asSubclass(ModelRenderer.class);
            }
            catch (ClassCastException cce) {
                try {
                    f.getType().asSubclass(ModelRenderer[].class);
                }
                catch (ClassCastException cce1) {
                    try {
                        f.getType().asSubclass(Collection.class);
                    }
                    catch (ClassCastException cce2) {
                        continue;
                    }
                }
            }
            try {
                ModelRenderer[] renderers;
                String comparisonName = f.getDeclaringClass().getName() + ";" + f.getName();
                String matchedFilterElement = null;
                if (filter != null && (matchedFilterElement = this.passesFilter(comparisonName, filter)) == null || (renderers = EntityIconPrerenderer.handleDeclaredField(f, entityModel, matchedFilterElement)) == null) continue;
                for (ModelRenderer mr : renderers) {
                    if (mainPart == null) {
                        mainPart = mr;
                    }
                    this.entityModelPartsRenderer.renderPart(mr, renderedModels, mainPart, zeroRotation, mrde);
                    if (justOne) break block9;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return mainPart;
    }

    private String passesFilter(String entry, List<String> filter) {
        for (String f : filter) {
            if (f.equals(entry)) {
                return f;
            }
            int indexOfBracket = f.lastIndexOf(91);
            if (indexOfBracket == -1 || !f.substring(0, indexOfBracket).equals(entry)) continue;
            return f;
        }
        return null;
    }

    public void generateMipmaps() {
        this.modelRenderFramebuffer.generateMipmaps();
    }

    private void onModelRenderDetection(ModelBase model, float red, float green, float blue, float alpha) {
        int textureId = GL11.glGetInteger((int)32873);
        int blendSrcFactor = GL11.glGetInteger((int)32969);
        int blendDestFactor = GL11.glGetInteger((int)32968);
        int blendAlphaSrcFactor = GL11.glGetInteger((int)32971);
        int blendAlphaDestFactor = GL11.glGetInteger((int)32970);
        int depthFunc = GL11.glGetInteger((int)2932);
        boolean depthTest = GL11.glIsEnabled((int)2929);
        boolean depthMask = GL11.glGetBoolean((int)2930);
        this.reusableByteBuffer64.clear();
        GL11.glGetBoolean((int)3107, (ByteBuffer)this.reusableByteBuffer64);
        boolean colorMaskR = this.reusableByteBuffer64.get(0) != 0;
        boolean colorMaskG = this.reusableByteBuffer64.get(1) != 0;
        boolean colorMaskB = this.reusableByteBuffer64.get(2) != 0;
        boolean colorMaskA = this.reusableByteBuffer64.get(3) != 0;
        boolean cullFace = GL11.glIsEnabled((int)2884);
        int cullMode = GL11.glGetInteger((int)2885);
        if (this.lastModelRenderDetected == null || !this.lastModelRenderDetected.hasProperties(model, textureId, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, cullFace, cullMode)) {
            this.lastModelRenderDetected = new ModelRenderDetectionElement(model, textureId, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, red, green, blue, alpha, cullFace, cullMode);
            this.modelRenderDetectionList.add(this.lastModelRenderDetected);
        }
    }

    public void onModelPartRenderDetection(ModelRenderer modelRenderer) {
        ModelBase model = ((IXaeroMinimapModelRenderer)modelRenderer).getXaero_model();
        if (this.modelRenderDetectionEntityModelClass == null) {
            ModelBase currentMainModel = this.getEntityRendererModel(this.modelRenderDetectionEntityRenderer);
            Class<?> clazz = this.modelRenderDetectionEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
        }
        if (this.modelRenderDetectionEntityModelClass != model.getClass()) {
            return;
        }
        this.reusableFloatBuffer16.clear();
        GL11.glGetFloat((int)2816, (FloatBuffer)this.reusableFloatBuffer16);
        float red = this.reusableFloatBuffer16.get(0);
        float green = this.reusableFloatBuffer16.get(1);
        float blue = this.reusableFloatBuffer16.get(2);
        float alpha = this.reusableFloatBuffer16.get(3);
        this.onModelRenderDetection(model, red, green, blue, alpha);
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private boolean renderIcon(Render entityRenderer, ModelBase mainEntityModel, List<ModelRenderDetectionElement> detectedModels, Entity entity, EntityIconModelConfig modelConfig) {
        EntityIconCustomRenderer entityIconCustomRenderer;
        boolean forceFieldCheck;
        boolean bl = forceFieldCheck = (modelConfig.renderingFullModel == null || modelConfig.renderingFullModel == false) && modelConfig.modelPartsFields != null;
        boolean fullModelIcon = modelConfig.renderingFullModel == null ? !forceFieldCheck && EntityIconDefinitions.fullModelIcon(mainEntityModel) : modelConfig.renderingFullModel;
        ModelRenderer mainPart = null;
        boolean renderedSomething = false;
        ArrayList<ModelRenderer> mainRenderedModels = new ArrayList<ModelRenderer>();
        ResourceLocation mainEntityTexture = EntityIconDefinitions.getEntityTexture(entityRenderer, entity);
        if (detectedModels.isEmpty() && mainEntityTexture != null) {
            TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
            ITextureObject mainTextureObject = textureManager.func_110581_b(mainEntityTexture);
            detectedModels.add(new ModelRenderDetectionElement(mainEntityModel, mainTextureObject == null ? 0 : mainTextureObject.func_110552_b(), 770, 771, 1, 771, true, 515, true, true, true, true, true, 1.0f, 1.0f, 1.0f, 1.0f, false, 1029));
        }
        boolean allEmpty = true;
        for (ModelRenderDetectionElement modelRenderDetectionElement : detectedModels) {
            if (modelRenderDetectionElement.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            for (ModelRenderDetectionElement modelRenderDetectionElement : detectedModels) {
                modelRenderDetectionElement.allVisible = true;
            }
        }
        ModelRenderDetectionElement mainMrde = null;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            boolean mainPartsVisibility;
            if (mrde.isEmpty() || renderedSomething && !modelConfig.layersAllowed) continue;
            ModelBase detectedModel = mrde.model;
            int detectedTexture = mrde.renderTexture;
            boolean mainModel = detectedModel == mainEntityModel;
            boolean bl2 = mainPartsVisibility = mainModel && mainMrde != null && mrde.sameVisibility(mainMrde);
            if (mainModel && !mainPartsVisibility) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                mainRenderedModels.clear();
                mainPart = this.renderModel(entityRenderer, detectedModel, entity, modelConfig, mainPart, mainRenderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde);
                mainMrde = mrde;
                renderedSomething = renderedSomething || !mainRenderedModels.isEmpty();
                continue;
            }
            if (!mainModel) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                ArrayList<ModelRenderer> renderedModels = new ArrayList<ModelRenderer>();
                mainPart = this.renderModel(entityRenderer, detectedModel, entity, modelConfig, mainPart, renderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde);
                renderedSomething = renderedSomething || !renderedModels.isEmpty();
                continue;
            }
            if (mainRenderedModels.isEmpty()) continue;
            this.setupModelRenderType(detectedTexture, mrde);
            this.entityModelPartsRenderer.renderPartsIterable(mainRenderedModels, new ArrayList<ModelRenderer>(), mainPart, modelConfig.modelPartsRotationReset, mrde);
            this.clearModelRenderType();
        }
        if (!mainRenderedModels.isEmpty() && modelConfig.layersAllowed && (entityIconCustomRenderer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = entityIconCustomRenderer.render(this, entityRenderer, entity, mainEntityModel, this.entityModelPartsRenderer, mainRenderedModels, mainPart, modelConfig, mainMrde);
        }
        return renderedSomething;
    }

    private boolean resetModelRotations(Entity entity, ModelBase model) {
        try {
            if (entity instanceof EntityLivingBase) {
                model.func_78086_a((EntityLivingBase)entity, 0.0f, 0.0f, 1.0f);
            }
            model.func_78087_a(0.0f, 0.0f, (float)entity.field_70173_aa, 0.0f, 0.0f, 0.0625f, entity);
            OpenGLException.checkGLError();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private ModelBase getEntityRendererModel(Render entityRenderer) {
        if (entityRenderer instanceof RendererLivingEntity) {
            return this.getLivingModel((RendererLivingEntity)entityRenderer);
        }
        return null;
    }
}

