/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.lwjgl.opengl.GLContext;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.OldAnimation;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapRadar;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.settings.ModSettings;

public class MinimapProcessor {
    public static final boolean DEBUG = false;
    public static final int FRAME = 9;
    private static final double log128 = Math.log(128.0);
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private MinimapWriter minimapWriter;
    private MinimapRadar entityRadar;
    private MinimapInterface minimapInterface;
    private double minimapZoom;
    private boolean toResetImage;
    private boolean enlargedMap = false;
    public final Object mainStuffSync;
    public World mainWorld;
    public double mainPlayerX;
    public double mainPlayerY;
    public double mainPlayerZ;

    public MinimapProcessor(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, MinimapWriter minimapWriter, MinimapRadar entityRadar) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.minimapWriter = minimapWriter;
        this.entityRadar = entityRadar;
        this.minimapZoom = 1.0;
        this.toResetImage = true;
        this.mainStuffSync = new Object();
        this.minimapInterface = modMain.getInterfaces().getMinimapInterface();
    }

    public int getMinimapSize(double scale) {
        return this.enlargedMap ? 500 : this.modMain.getSettings().getMinimapSize(scale) * 2;
    }

    public int getMinimapBufferSize(int minimapSize) {
        int bufferSize = 128 * (int)Math.pow(2.0, Math.ceil(Math.log((double)minimapSize / 128.0) / Math.log(2.0)));
        if (bufferSize < 128) {
            return 128;
        }
        if (bufferSize > 512) {
            return 512;
        }
        return bufferSize;
    }

    public boolean isEnlargedMap() {
        return this.enlargedMap;
    }

    public void setEnlargedMap(boolean enlargedMap) {
        this.enlargedMap = enlargedMap;
    }

    public double getMinimapZoom() {
        return this.minimapZoom;
    }

    private double getTargetZoom() {
        float target;
        float settingsZoom = this.modMain.getSettings().zooms[this.modMain.getSettings().zoom];
        if (this.enlargedMap && this.modMain.getSettings().zoomedOutEnlarged) {
            settingsZoom = 1.0f;
        }
        if ((target = settingsZoom * (this.modMain.getSettings().caveZoom > 0 && this.minimapWriter.getLoadedCaving() != -1 ? (float)(1 + this.modMain.getSettings().caveZoom) : 1.0f)) > this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1]) {
            target = this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1];
        }
        return target;
    }

    public void instantZoom() {
        this.minimapZoom = this.getTargetZoom();
    }

    public void updateZoom() {
        double target = this.getTargetZoom();
        double off = target - this.minimapZoom;
        off = off > 0.01 || off < -0.01 ? (double)((float)OldAnimation.animate(off, 0.8)) : 0.0;
        this.minimapZoom = target - off;
    }

    public MinimapWriter getMinimapWriter() {
        return this.minimapWriter;
    }

    public boolean canUseFrameBuffer() {
        return !(!GLContext.getCapabilities().OpenGL14 || !GLContext.getCapabilities().GL_ARB_framebuffer_object && !GLContext.getCapabilities().GL_EXT_framebuffer_object && !GLContext.getCapabilities().OpenGL30 || !GLContext.getCapabilities().OpenGL15 && !GLContext.getCapabilities().GL_ARB_vertex_buffer_object || !GLContext.getCapabilities().OpenGL21 && !GLContext.getCapabilities().GL_EXT_pixel_buffer_object && !GLContext.getCapabilities().GL_ARB_pixel_buffer_object);
    }

    public int getFBOBufferSize() {
        return 512;
    }

    public void onClientTick() {
        WorldClient world = null;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70170_p instanceof WorldClient) {
            world = (WorldClient)player.field_70170_p;
        }
        if (this.modMain.getSettings().getMinimap()) {
            this.entityRadar.updateRadar(world, (EntityPlayer)player, (Entity)Minecraft.func_71410_x().field_71451_h, this);
        }
    }

    public void onPlayerTick() {
    }

    public void onRender(int x, int y, int width, int height, int scale, int size, int boxSize, float partial) {
        try {
            if (this.minimapInterface.getMinimapFBORenderer().isLoadedFBO() && !this.canUseFrameBuffer()) {
                this.minimapInterface.getMinimapFBORenderer().setLoadedFBO(false);
                this.minimapInterface.getMinimapFBORenderer().deleteFramebuffers();
                this.toResetImage = true;
            }
            if (!(this.minimapInterface.getMinimapFBORenderer().isLoadedFBO() || this.modMain.getSettings().mapSafeMode || this.minimapInterface.getMinimapFBORenderer().isTriedFBO())) {
                this.minimapInterface.getMinimapFBORenderer().loadFrameBuffer(this);
            }
            if (this.enlargedMap && this.modMain.getSettings().centeredEnlarged) {
                x = (width - boxSize) / 2;
                y = (height - boxSize) / 2;
            }
            if (this.minimapInterface.usingFBO()) {
                this.minimapInterface.getMinimapFBORenderer().renderMinimap(this.minimapSession, this, x, y, width, height, scale, size, partial);
            } else {
                this.minimapInterface.getMinimapSafeModeRenderer().renderMinimap(this.minimapSession, this, x, y, width, height, scale, size, partial);
            }
        }
        catch (Throwable e) {
            this.minimapInterface.setCrashedWith(e);
            this.minimapInterface.checkCrashes();
        }
    }

    public static boolean hasMinimapItem(EntityPlayer player) {
        for (int i = 0; i < 9; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != ModSettings.minimapItem) continue;
            return true;
        }
        return false;
    }

    public boolean isToResetImage() {
        return this.toResetImage;
    }

    public void setToResetImage(boolean toResetImage) {
        this.toResetImage = toResetImage;
    }

    public MinimapRadar getEntityRadar() {
        return this.entityRadar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainValues() {
        Object object = this.mainStuffSync;
        synchronized (object) {
            EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
            if (player != null) {
                this.mainWorld = player.field_70170_p;
                this.mainPlayerX = player.field_70165_t;
                this.mainPlayerY = player.field_70163_u;
                this.mainPlayerZ = player.field_70161_v;
            } else {
                this.mainWorld = null;
            }
        }
    }

    public void cleanup() {
        this.minimapWriter.cleanup();
    }
}

