/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world;

import chylex.hee.world.biome.BiomeGenHardcoreEnd;
import chylex.hee.world.structure.island.MapGenIsland;
import chylex.hee.world.structure.tower.MapGenTower;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ConcurrentModificationException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class ChunkProviderHardcoreEnd
extends ChunkProviderEnd {
    private final World world;
    private final Random randCopy;
    private final MapGenScatteredFeature islandGen;
    private final MapGenScatteredFeature towerGen;

    public ChunkProviderHardcoreEnd(World world, long seed) {
        super(world, seed);
        this.world = world;
        this.randCopy = this.field_73204_i;
        this.islandGen = new MapGenIsland();
        this.towerGen = new MapGenTower();
    }

    public void replaceBiomeBlocks(int x, int z, Block[] blocks, BiomeGenBase[] biomes, byte[] metadata) {
        if (!BiomeGenHardcoreEnd.overrideWorldGen) {
            ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, x, z, blocks, metadata, biomes, this.world);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return;
            }
        }
        for (int index = 0; index < 32768; ++index) {
            if (blocks[index] != Blocks.field_150348_b) continue;
            blocks[index] = Blocks.field_150377_bs;
        }
        if (this.world.field_73011_w.field_76574_g == 1) {
            this.islandGen.func_151539_a((IChunkProvider)this, this.world, x, z, blocks);
            this.towerGen.func_151539_a((IChunkProvider)this, this.world, x, z, blocks);
        }
    }

    public void func_73153_a(IChunkProvider chunkProvider, int x, int z) {
        BlockFalling.field_149832_M = true;
        if (!BiomeGenHardcoreEnd.overrideWorldGen) {
            MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunkProvider, this.world, this.randCopy, x, z, false));
        }
        if (this.world.field_73011_w.field_76574_g == 1) {
            try {
                this.islandGen.func_75051_a(this.world, this.randCopy, x, z);
                this.towerGen.func_75051_a(this.world, this.randCopy, x, z);
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
        ((BiomeGenHardcoreEnd)BiomeGenBase.field_76779_k).func_76728_a(this.world, this.randCopy, x * 16, z * 16);
        if (!BiomeGenHardcoreEnd.overrideWorldGen) {
            MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunkProvider, this.world, this.randCopy, x, z, false));
        }
        BlockFalling.field_149832_M = false;
    }

    public void func_82695_e(int x, int z) {
        if (this.world.field_73011_w.field_76574_g == 1) {
            this.islandGen.func_151539_a((IChunkProvider)this, this.world, x, z, (Block[])null);
            this.towerGen.func_151539_a((IChunkProvider)this, this.world, x, z, (Block[])null);
        }
    }

    public ChunkPosition func_147416_a(World world, String identifier, int x, int y, int z) {
        return null;
    }
}

