/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.block;

import chylex.hee.block.BlockAbstractSubtypes;
import chylex.hee.system.abstractions.Pos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGloomrock
extends BlockAbstractSubtypes {
    public static final State[] colored = new State[]{State.COL_RED, State.COL_ORANGE, State.COL_YELLOW, State.COL_GREEN, State.COL_CYAN, State.COL_LIGHT_BLUE, State.COL_BLUE, State.COL_PURPLE, State.COL_MAGENTA, State.COL_PINK, State.COL_WHITE, State.COL_GRAY, State.COL_BLACK};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockGloomrock() {
        super(Material.field_151576_e);
    }

    public int countSubtypes() {
        return State.count;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        return Pos.at((int)x, (int)y, (int)z).getMetadata((IBlockAccess)world) == State.PLAIN.value ? this.blockHardness * 0.5f : this.blockHardness;
    }

    public String getUnlocalizedName(int meta) {
        switch (meta) {
            case 0: {
                return "tile.gloomrock.plain";
            }
            case 1: {
                return "tile.gloomrock.smooth";
            }
            case 2: {
                return "tile.gloomrock.brick";
            }
        }
        return "tile.gloomrock.color." + (meta - 3);
    }

    protected String getTextureName(int meta) {
        switch (meta) {
            case 0: {
                return "hardcoreenderexpansion:gloomrock_plain";
            }
            case 1: {
                return "hardcoreenderexpansion:gloomrock_smooth";
            }
            case 2: {
                return "hardcoreenderexpansion:gloomrock_brick";
            }
        }
        return "hardcoreenderexpansion:gloomrock_color_" + (meta - 2);
    }

    public static enum State {
        PLAIN,
        SMOOTH,
        BRICK,
        COL_RED,
        COL_ORANGE,
        COL_YELLOW,
        COL_GREEN,
        COL_CYAN,
        COL_LIGHT_BLUE,
        COL_BLUE,
        COL_PURPLE,
        COL_MAGENTA,
        COL_PINK,
        COL_WHITE,
        COL_GRAY,
        COL_BLACK;

        public final byte value = (byte)this.ordinal();
        public static final byte count;
        public static final byte firstColor;

        static {
            count = (byte)State.values().length;
            firstColor = State.COL_RED.value;
        }
    }
}

