/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thaumicenergistics.common.container.TheContainerBase;
import thaumicenergistics.common.utils.ThEUtils;

public abstract class ContainerWithPlayerInventory
extends TheContainerBase {
    private static int ROWS = 3;
    private static int COLUMNS = 9;
    protected static final int SLOT_SIZE = 18;
    private static final int INVENTORY_X_OFFSET = 8;
    private final Slot[] hotbarSlots = new Slot[COLUMNS];
    private final Slot[] playerSlots = new Slot[COLUMNS * ROWS];

    public ContainerWithPlayerInventory(EntityPlayer player) {
        super(player);
    }

    protected final boolean mergeSlotWithHotbarInventory(ItemStack slotStack) {
        return this.func_75135_a(slotStack, this.hotbarSlots[0].field_75222_d, this.hotbarSlots[ContainerWithPlayerInventory.COLUMNS - 1].field_75222_d + 1, false);
    }

    protected final boolean mergeSlotWithPlayerInventory(ItemStack slotStack) {
        return this.func_75135_a(slotStack, this.playerSlots[0].field_75222_d, this.playerSlots[ContainerWithPlayerInventory.COLUMNS * ContainerWithPlayerInventory.ROWS - 1].field_75222_d + 1, false);
    }

    protected final boolean slotClickedWasInHotbarInventory(int slotNumber) {
        return slotNumber >= this.hotbarSlots[0].field_75222_d && slotNumber <= this.hotbarSlots[ContainerWithPlayerInventory.COLUMNS - 1].field_75222_d;
    }

    protected final boolean slotClickedWasInPlayerInventory(int slotNumber) {
        return slotNumber >= this.playerSlots[0].field_75222_d && slotNumber <= this.playerSlots[ContainerWithPlayerInventory.COLUMNS * ContainerWithPlayerInventory.ROWS - 1].field_75222_d;
    }

    protected final boolean swapSlotInventoryHotbar(int slotNumber, ItemStack slotStack) {
        if (this.slotClickedWasInHotbarInventory(slotNumber)) {
            return this.mergeSlotWithPlayerInventory(slotStack);
        }
        if (this.slotClickedWasInPlayerInventory(slotNumber)) {
            return this.mergeSlotWithHotbarInventory(slotStack);
        }
        return false;
    }

    @Nullable
    protected final ItemStack takeItemFromPlayer(ItemStack searchStack, int amount) {
        if (searchStack == null || amount <= 0) {
            return null;
        }
        Slot matchingSlot = null;
        for (Slot slot : this.playerSlots) {
            if (!slot.func_75216_d() || !ThEUtils.areStacksEqualIgnoreAmount(searchStack, slot.func_75211_c())) continue;
            matchingSlot = slot;
            break;
        }
        if (matchingSlot == null) {
            for (Slot slot : this.hotbarSlots) {
                if (!slot.func_75216_d() || !ThEUtils.areStacksEqualIgnoreAmount(searchStack, slot.func_75211_c())) continue;
                matchingSlot = slot;
                break;
            }
        }
        if (matchingSlot == null) {
            return null;
        }
        ItemStack matchStack = matchingSlot.func_75211_c();
        if (matchStack.field_77994_a < amount) {
            return null;
        }
        ItemStack result = matchStack.func_77979_a(amount);
        if (matchStack.field_77994_a == 0) {
            matchingSlot.func_75215_d(null);
        } else {
            matchingSlot.func_75215_d(matchStack);
        }
        return result;
    }

    public final void bindPlayerInventory(IInventory playerInventory, int inventoryOffsetY, int hotbarPositionY) {
        for (int column = 0; column < COLUMNS; ++column) {
            this.hotbarSlots[column] = new Slot(playerInventory, column, 8 + column * 18, hotbarPositionY);
            this.func_75146_a(this.hotbarSlots[column]);
        }
        for (int row = 0; row < ROWS; ++row) {
            for (int column = 0; column < COLUMNS; ++column) {
                int index = column + row * COLUMNS;
                this.playerSlots[index] = new Slot(playerInventory, COLUMNS + index, 8 + column * 18, row * 18 + inventoryOffsetY);
                this.func_75146_a(this.playerSlots[index]);
            }
        }
    }

    public final ArrayList<Slot> getNonEmptySlotsFromHotbar() {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (Slot slot : this.hotbarSlots) {
            if (!slot.func_75216_d()) continue;
            list.add(slot);
        }
        return list;
    }

    public final ArrayList<Slot> getNonEmptySlotsFromPlayerInventory() {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (Slot slot : this.playerSlots) {
            if (!slot.func_75216_d()) continue;
            list.add(slot);
        }
        return list;
    }

    public final Slot locateMergeSlot(ItemStack stack) {
        Slot emptySlot = null;
        for (Slot slot : this.playerSlots) {
            if (slot.func_75216_d()) {
                ItemStack slotStack = slot.func_75211_c();
                if (slotStack.field_77994_a >= slotStack.func_77976_d() || !slotStack.func_77969_a(stack)) continue;
                return slot;
            }
            if (emptySlot != null) continue;
            emptySlot = slot;
        }
        return emptySlot;
    }
}

