/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.thaumicexploration.misc.brazier;

import flaxbeard.thaumicexploration.misc.brazier.SoulBrazierQueueData;
import flaxbeard.thaumicexploration.tile.TileEntitySoulBrazier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;

public class SoulBrazierUtils {
    public static final String PlayerWarpDataFileName = "PlayerWarpQueueData.dat";
    public static final File PlayerWarpDataFile = SoulBrazierUtils.getPlayerWarpDataFile();

    public static UUID getPlayerUUID(EntityPlayer aPlayer) {
        return aPlayer.func_146103_bH().getId();
    }

    public static EntityPlayer getPlayerFromUUID(String aUUID) {
        return SoulBrazierUtils.getPlayerFromUUID(UUID.fromString(aUUID));
    }

    public static EntityPlayer getPlayerFromUUID(UUID aUUID) {
        List allPlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP player : allPlayers) {
            if (!player.func_146103_bH().getId().equals(aUUID)) continue;
            return player;
        }
        return null;
    }

    public static boolean isPlayerOnline(UUID aUUID) {
        return SoulBrazierUtils.getPlayerFromUUID(aUUID) != null;
    }

    public static boolean isPlayerInRangeOfBrazier(EntityPlayer aPlayer, TileEntitySoulBrazier aTile) {
        double aDistance = aTile.func_145835_a(aPlayer.field_70165_t, aPlayer.field_70163_u, aPlayer.field_70161_v);
        return aDistance <= 50.0;
    }

    public static int doesPlayerHaveWarpQueued(UUID aPlayer) {
        if (aPlayer == null) {
            return 0;
        }
        ArrayList<String> aWarpData = SoulBrazierUtils.readPlayerWarpQueueDataFromFile();
        int aQueueCount = 0;
        for (String warpData : aWarpData) {
            if (warpData == null || warpData.length() <= 0 || !warpData.contains(aPlayer.toString())) continue;
            ++aQueueCount;
        }
        return aQueueCount;
    }

    public static void writePlayerWarpToQueueFile(UUID aPlayer, TileEntitySoulBrazier aTile) {
        if (aPlayer == null || aTile.storedWarp < 0) {
            return;
        }
        String aUUID = aPlayer.toString();
        String warpKey = aUUID + "@" + aTile.storedWarp + "@" + aTile.field_145851_c + "@" + aTile.field_145848_d + "@" + aTile.field_145849_e + "" + aTile.func_145831_w().field_73011_w.field_76574_g;
        ArrayList<String> aNewDataList = new ArrayList<String>();
        ArrayList<String> aWarpData = SoulBrazierUtils.readPlayerWarpQueueDataFromFile();
        if (aWarpData.contains(warpKey)) {
            for (String warpData : aWarpData) {
                if (warpData == null || warpData.length() <= 0) continue;
                if (warpData.contains(aUUID)) {
                    aNewDataList.add(warpKey);
                    continue;
                }
                aNewDataList.add(warpData);
            }
        } else {
            aNewDataList.addAll(aWarpData);
            aNewDataList.add(warpKey);
        }
        if (!aNewDataList.isEmpty()) {
            SoulBrazierUtils.writePlayerWarpQueueDataToFile(aNewDataList);
        }
    }

    public static SoulBrazierQueueData getPlayerDataFromWarpQueue(UUID aPlayer) {
        if (aPlayer == null) {
            return null;
        }
        ArrayList<String> aWarpData = SoulBrazierUtils.readPlayerWarpQueueDataFromFile();
        for (String warpData : aWarpData) {
            String[] playerData;
            if (warpData == null || warpData.length() <= 0 || !warpData.contains(aPlayer.toString()) || (playerData = warpData.split("@")).length != 6) continue;
            int aQueuedWarp = Integer.parseInt(playerData[1]);
            int aX = Integer.parseInt(playerData[2]);
            int aY = Integer.parseInt(playerData[3]);
            int aZ = Integer.parseInt(playerData[4]);
            int aDimID = Integer.parseInt(playerData[5]);
            return new SoulBrazierQueueData(aPlayer, aQueuedWarp, aX, aY, aZ, aDimID);
        }
        return null;
    }

    public static boolean removePlayerDataFromWarpQueue(UUID aPlayer, int aX, int aY, int aZ, int aDimID) {
        if (aPlayer == null) {
            return false;
        }
        ArrayList<String> aNewDataList = new ArrayList<String>();
        ArrayList<String> aWarpData = SoulBrazierUtils.readPlayerWarpQueueDataFromFile();
        for (String warpData : aWarpData) {
            if (warpData == null || warpData.length() <= 0) continue;
            if (!warpData.contains(aPlayer.toString())) {
                aNewDataList.add(warpData);
                continue;
            }
            if (warpData.contains(aX + "@" + aY + "@" + aZ + "@" + aDimID)) continue;
            aNewDataList.add(warpData);
        }
        if (!aNewDataList.isEmpty()) {
            SoulBrazierUtils.writePlayerWarpQueueDataToFile(aNewDataList);
        }
        return true;
    }

    private static void writePlayerWarpQueueDataToFile(ArrayList<String> aData) {
        File warpFile = SoulBrazierUtils.getPlayerWarpDataFile();
        SoulBrazierUtils.sortWarpDataList(aData);
        try {
            if (!warpFile.exists()) {
                warpFile.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(warpFile.getPath()));
            for (String aPlayerData : aData) {
                writer.write(aPlayerData);
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ArrayList<String> readPlayerWarpQueueDataFromFile() {
        File warpFile = SoulBrazierUtils.getPlayerWarpDataFile();
        ArrayList<String> aData = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(warpFile.getPath()));
            while ((line = reader.readLine()) != null && line.length() > 0) {
                aData.add(line);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return aData;
    }

    private static void sortWarpDataList(ArrayList<String> aData) {
        Collections.sort(aData);
    }

    private static File getSaveDirectory() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), "ThaumicExploration");
    }

    private static File getPlayerWarpDataFile() {
        if (PlayerWarpDataFile != null && PlayerWarpDataFile.exists()) {
            return PlayerWarpDataFile;
        }
        String dir = SoulBrazierUtils.getSaveDirectory().getPath();
        File warpFile = new File(dir + PlayerWarpDataFileName);
        if (!warpFile.exists()) {
            try {
                warpFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return warpFile;
    }
}

