/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.recipe;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.recipe.JSONRecipe;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class JSONRecipeList {
    static List<JSONRecipe> recipesList = new ArrayList<JSONRecipe>();
    public static final Gson gson = new Gson();
    private static FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".recipe") || name.endsWith(".recipes");
        }
    };

    public static void loadRecipesFromDir(String dir) {
        try {
            File file = new File(dir);
            if (file.exists()) {
                if (file.isDirectory()) {
                    String[] filenames;
                    for (String filename : filenames = file.list(filter)) {
                        String json = JSONRecipeList.readFile(dir + "/" + filename, Charsets.UTF_8);
                        MuseLogger.logDebug("Loading recipes from " + filename);
                        JSONRecipeList.loadRecipesFromString(json);
                    }
                } else {
                    String json = JSONRecipeList.readFile(dir, Charsets.UTF_8);
                    MuseLogger.logDebug("Loading recipes from " + dir);
                    JSONRecipeList.loadRecipesFromString(json);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadRecipesFromResource(URL resource) {
        try {
            String json = Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
            JSONRecipeList.loadRecipesFromString(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadRecipesFromString(String json) {
        JSONRecipe[] newrecipes;
        for (JSONRecipe recipe : newrecipes = (JSONRecipe[])gson.fromJson(json, JSONRecipe[].class)) {
            if (recipe != null && !recipesList.contains(recipe)) {
                recipesList.add(recipe);
                JSONRecipeList.getCraftingRecipeList().add(recipe);
                MuseLogger.logDebug("Recipe received:" + recipe.result.oredictName + " / " + recipe.result.registryName);
                continue;
            }
            MuseLogger.logDebug("Recipe duplicate, not added:" + recipe.result.oredictName + " / " + recipe.result.registryName);
        }
    }

    public static List<IRecipe> getCraftingRecipeList() {
        return CraftingManager.func_77594_a().func_77592_b();
    }

    public static List<JSONRecipe> getJSONRecipesList() {
        return recipesList;
    }

    static String readFile(String path, Charset encoding) throws IOException {
        File file = new File(path);
        DataInputStream is = new DataInputStream(new FileInputStream(file));
        byte[] bytes = new byte[(int)file.length()];
        is.readFully(bytes);
        return encoding.decode(ByteBuffer.wrap(bytes)).toString();
    }
}

