/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.network;

import java.io.DataInputStream;
import java.io.IOException;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.numina.network.RichInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MusePackager {
    private static MusePackager INSTANCE;
    public short READ_ERROR = (short)-150;

    public static MusePackager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MusePackager();
        }
        return INSTANCE;
    }

    public MusePacket read(DataInputStream datain, EntityPlayer player) {
        return null;
    }

    public byte readByte(DataInputStream datain) {
        try {
            return datain.readByte();
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET D:", exception);
            return Byte.parseByte(null);
        }
    }

    public short readShort(DataInputStream datain) {
        try {
            return datain.readShort();
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET D:", exception);
            return Short.parseShort(null);
        }
    }

    public int readInt(DataInputStream datain) {
        try {
            return datain.readInt();
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET D:", exception);
            return Integer.parseInt(null);
        }
    }

    public long readLong(DataInputStream datain) {
        try {
            return datain.readLong();
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET D:", exception);
            return Long.parseLong(null);
        }
    }

    public boolean readBoolean(DataInputStream datain) {
        try {
            return datain.readBoolean();
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET D:", exception);
            return Boolean.parseBoolean(null);
        }
    }

    public float readFloat(DataInputStream datain) {
        try {
            return datain.readFloat();
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET D:", exception);
            return Float.parseFloat(null);
        }
    }

    public double readDouble(DataInputStream datain) {
        try {
            return datain.readDouble();
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET D:", exception);
            return Double.parseDouble(null);
        }
    }

    public int[] readIntArray(DataInputStream datain) {
        return RichInputStream.toRichStream(datain).readIntArray();
    }

    public String readString(DataInputStream datain) {
        return RichInputStream.toRichStream(datain).readString();
    }

    public ItemStack readItemStack(DataInputStream datain) {
        return RichInputStream.toRichStream(datain).readItemStack();
    }

    public NBTTagCompound readNBTTagCompound(DataInputStream datain) {
        return RichInputStream.toRichStream(datain).readNBTTagCompound();
    }
}

