/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin;

import com.falsepattern.lib.StableAPI;
import java.util.Optional;

@StableAPI(since="0.10.2")
public final class MixinInfo {
    @StableAPI.Expose
    public static final MixinBootstrapperType mixinBootstrapper = MixinInfo.detect();

    @StableAPI.Expose
    public static boolean isMixinsInstalled() {
        return mixinBootstrapper != MixinBootstrapperType.None;
    }

    @StableAPI.Expose
    public static boolean isOfficialSpongeMixins() {
        return mixinBootstrapper == MixinBootstrapperType.SpongeMixins && MixinInfo.getVerUnsafe().equals("0.7.11");
    }

    @StableAPI.Expose
    public static boolean isTamperedSpongeMixins() {
        return mixinBootstrapper == MixinBootstrapperType.SpongeMixins && MixinInfo.getVerUnsafe().equals("0.7.12");
    }

    @StableAPI.Expose
    public static boolean isGrimoire() {
        return mixinBootstrapper == MixinBootstrapperType.Grimoire;
    }

    @StableAPI.Expose
    public static boolean isMixinBooterLegacy() {
        return mixinBootstrapper == MixinBootstrapperType.MixinBooterLegacy;
    }

    @StableAPI.Expose
    public static MixinBootstrapperType bootstrapperType() {
        return mixinBootstrapper;
    }

    @StableAPI.Expose
    public static Optional<String> mixinVersion() {
        return mixinBootstrapper != MixinBootstrapperType.None ? Optional.of(MixinInfo.getVerUnsafe()) : Optional.empty();
    }

    private static String getVerUnsafe() {
        return "0.8.3";
    }

    private static MixinBootstrapperType detect() {
        try {
            Class.forName("org.spongepowered.asm.launch.MixinBootstrap");
        }
        catch (ClassNotFoundException ignored) {
            return MixinBootstrapperType.None;
        }
        try {
            Class.forName("com.falsepattern.gasstation.core.GasStationCore");
            return MixinBootstrapperType.GasStation;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("ru.timeconqueror.spongemixins.core.SpongeMixinsCore");
                return MixinBootstrapperType.SpongeMixins;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    Class.forName("io.github.crucible.grimoire.Grimoire");
                    return MixinBootstrapperType.Grimoire;
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    try {
                        Class.forName("io.github.crucible.grimoire.common.GrimoireCore");
                        return MixinBootstrapperType.Grimoire;
                    }
                    catch (ClassNotFoundException classNotFoundException4) {
                        try {
                            Class.forName("io.github.tox1cozz.mixinbooterlegacy.MixinBooterLegacyPlugin");
                            return MixinBootstrapperType.MixinBooterLegacy;
                        }
                        catch (ClassNotFoundException classNotFoundException5) {
                            return MixinBootstrapperType.Other;
                        }
                    }
                }
            }
        }
    }

    @StableAPI(since="0.10.2")
    public static enum MixinBootstrapperType {
        None,
        GasStation,
        SpongeMixins,
        Grimoire,
        MixinBooterLegacy,
        Other;

    }
}

