/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mapping;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.dependencies.DependencyLoader;
import com.falsepattern.lib.dependencies.Library;
import com.falsepattern.lib.dependencies.SemanticVersion;
import com.falsepattern.lib.internal.asm.CoreLoadingPlugin;
import com.falsepattern.lib.mapping.storage.Lookup;
import com.falsepattern.lib.mapping.types.MappingType;
import com.falsepattern.lib.mapping.types.NameType;
import com.falsepattern.lib.mapping.types.UniversalClass;
import com.falsepattern.lib.mapping.types.UniversalField;
import com.falsepattern.lib.mapping.types.UniversalMethod;
import com.falsepattern.lib.util.ResourceUtil;
import java.io.DataInputStream;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.tukaani.xz.LZMA2Options;

@StableAPI(since="0.10.0")
public class MappingManager {
    private static final Lookup<UniversalClass> internalLookup = new Lookup();
    private static final Lookup<UniversalClass> regularLookup = new Lookup();
    private static final Map<String, String> stringPool = new HashMap<String, String>();
    private static boolean initialized = false;

    private static synchronized void initialize() {
        UniversalClass clazz;
        String[] line;
        int i;
        if (initialized) {
            return;
        }
        initialized = true;
        DependencyLoader.addMavenRepo("https://repo1.maven.org/maven2/");
        DependencyLoader.loadLibraries(Library.builder().groupId("org.tukaani").artifactId("xz").minVersion(SemanticVersion.builder().majorVersion(1).minorVersion(9).patchVersion(-1).build()).preferredVersion(SemanticVersion.builder().majorVersion(1).minorVersion(9).patchVersion(-1).build()).build());
        DataInputStream input = new DataInputStream(new LZMA2Options(6).getInputStream(ResourceUtil.getResourceFromJar("/mappings.lzma2", CoreLoadingPlugin.class)));
        byte[] classBytes = new byte[input.readInt()];
        input.readFully(classBytes);
        String[] classMappings = new String(classBytes).split("\n");
        for (i = 1; i < classMappings.length; ++i) {
            line = classMappings[i].split(",");
            clazz = new UniversalClass(line, stringPool);
            internalLookup.unwrap(clazz.internalName, clazz);
            regularLookup.unwrap(clazz.regularName, clazz);
        }
        byte[] fieldBytes = new byte[input.readInt()];
        input.readFully(fieldBytes);
        String[] fieldMappings = new String(fieldBytes).split("\n");
        for (i = 1; i < fieldMappings.length; ++i) {
            line = fieldMappings[i].split(",");
            clazz = internalLookup.get(MappingType.Notch, line[0].substring(0, line[0].lastIndexOf(47)));
            UniversalField.createAndAddToParent(clazz, line, stringPool);
        }
        byte[] methodBytes = new byte[input.readInt()];
        input.readFully(methodBytes);
        String[] methodMappings = new String(methodBytes).split("\n");
        for (i = 1; i < methodMappings.length; ++i) {
            line = methodMappings[i].split(",");
            clazz = internalLookup.get(MappingType.Notch, line[0].substring(0, line[0].lastIndexOf(47)));
            UniversalMethod.createAndAddToParent(clazz, line, stringPool);
        }
    }

    @StableAPI.Expose
    public static UniversalClass classForName(NameType nameType, MappingType mappingType, String className) throws ClassNotFoundException {
        MappingManager.initialize();
        try {
            switch (nameType) {
                case Internal: {
                    return internalLookup.get(mappingType, className);
                }
                case Regular: {
                    return regularLookup.get(mappingType, className);
                }
            }
            throw new IllegalArgumentException("Invalid enum value " + (Object)((Object)nameType));
        }
        catch (Lookup.LookupException e) {
            throw new ClassNotFoundException("Could not find class \"" + className + "\" with " + nameType.name().toLowerCase() + " name in the " + mappingType.name() + " mapping.");
        }
    }

    @StableAPI.Expose
    public static boolean containsClass(NameType nameType, MappingType mappingType, String className) {
        switch (nameType) {
            case Internal: {
                return internalLookup.containsKey(mappingType, className);
            }
            case Regular: {
                return regularLookup.containsKey(mappingType, className);
            }
        }
        throw new IllegalArgumentException("Invalid enum value " + (Object)((Object)nameType));
    }

    @StableAPI.Expose
    public static UniversalField getField(FieldInsnNode instruction) throws ClassNotFoundException, NoSuchFieldException {
        if (!CoreLoadingPlugin.isObfuscated()) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.MCP, instruction.owner).getField(MappingType.MCP, instruction.name);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException("Could not find the class " + instruction.owner + " in the MCP mappings. Are you sure it's a Minecraft class? (we're in dev, cannot use SRG or Notch here).");
            }
        }
        try {
            return MappingManager.classForName(NameType.Internal, MappingType.SRG, instruction.owner).getField(MappingType.SRG, instruction.name);
        }
        catch (ClassNotFoundException e) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.Notch, instruction.owner).getField(MappingType.Notch, instruction.name);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Could not find the class " + instruction.owner + " neither in the SRG nor in the Notch mappings. Are you sure it's a Minecraft class? (we're in obf, cannot use MCP here)");
            }
        }
    }

    @StableAPI.Expose
    public static UniversalMethod getMethod(MethodInsnNode instruction) throws ClassNotFoundException, NoSuchMethodException {
        if (!CoreLoadingPlugin.isObfuscated()) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.MCP, instruction.owner).getMethod(MappingType.MCP, instruction.name, instruction.desc);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException("Could not find the class " + instruction.owner + " in the MCP mappings. Are you sure it's a Minecraft class? (we're in dev, cannot use SRG or Notch here).");
            }
        }
        try {
            return MappingManager.classForName(NameType.Internal, MappingType.SRG, instruction.owner).getMethod(MappingType.SRG, instruction.name, instruction.desc);
        }
        catch (ClassNotFoundException e) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.Notch, instruction.owner).getMethod(MappingType.Notch, instruction.name, instruction.desc);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Could not find the class " + instruction.owner + " neither in the SRG nor in the Notch mappings. Are you sure it's a Minecraft class? (we're in obf, cannot use MCP here)");
            }
        }
    }
}

