/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.Share;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class StringConfigField
extends AConfigField<String> {
    private final int maxLength;
    private final Pattern pattern;
    private final String defaultValue;

    public StringConfigField(Field field, Configuration configuration, String category) {
        super(field, configuration, category, Property.Type.STRING);
        this.pattern = Optional.ofNullable(field.getAnnotation(Config.Pattern.class)).map(ptr -> Pattern.compile(ptr.value())).orElse(null);
        this.defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultString.class)).map(Config.DefaultString::value).orElseGet(() -> {
            Share.LOG.warn("The field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " has no DefaultString annotation!\nThis will be a crash in FalsePatternLib 0.11, update your code!");
            try {
                return (String)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        this.maxLength = Optional.ofNullable(field.getAnnotation(Config.StringMaxLength.class)).map(Config.StringMaxLength::value).orElse(256);
        this.property.setDefaultValue(this.defaultValue);
        this.property.comment = this.property.comment + "\n[max length: " + this.maxLength + (this.pattern != null ? ", pattern: \"" + this.pattern.pattern() + "\"" : "") + ", default: \"" + this.defaultValue + "\"]";
    }

    public static boolean validateString(String value, int maxLength, Pattern pattern, Field field, int listIndex) {
        if (value == null) {
            ConfigValidationFailureEvent.fieldIsNull(field, listIndex);
            return false;
        }
        if (value.length() > maxLength) {
            ConfigValidationFailureEvent.postStringSizeOutOfBounds(field, listIndex, value, maxLength);
            return false;
        }
        if (pattern != null && !pattern.matcher(value).matches()) {
            ConfigValidationFailureEvent.postStringPatternMismatch(field, listIndex, value, pattern.pattern());
            return false;
        }
        return true;
    }

    public static void transmitString(DataOutput output, String value) throws IOException {
        output.writeInt(value.length());
        output.writeChars(value);
    }

    public static String receiveString(DataInput input, int maxLength, String valueName, String className) throws IOException {
        int length = input.readInt();
        if (length > maxLength || length < 0) {
            throw new IOException("Error while retrieving value for " + valueName + " in class " + className + ":\nIllegal string length received!");
        }
        char[] arr = new char[length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = input.readChar();
        }
        return new String(arr);
    }

    @Override
    protected String getField() {
        return (String)this.field.get(null);
    }

    @Override
    protected void putField(String value) {
        this.field.set(null, value);
    }

    @Override
    protected String getConfig() {
        return this.property.getString();
    }

    @Override
    protected void putConfig(String value) {
        this.property.set(value);
    }

    @Override
    protected String getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean validateField() {
        return StringConfigField.validateString(this.getField(), this.maxLength, this.pattern, this.field, -1);
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        StringConfigField.transmitString(output, this.getField());
    }

    @Override
    public void receive(DataInput input) throws IOException {
        this.putField(StringConfigField.receiveString(input, this.maxLength, this.field.getName(), this.field.getDeclaringClass().getName()));
    }
}

