/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.Share;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class EnumConfigField<T extends Enum<T>>
extends AConfigField<T> {
    private final int maxLength;
    private final Class<T> enumClass;
    private final T defaultValue;
    private final BiMap<String, T> enumNameMap = HashBiMap.create();

    public EnumConfigField(Field field, Configuration configuration, String category) {
        super(field, configuration, category, Property.Type.STRING);
        this.enumClass = field.getType();
        for (Enum e : (Enum[])this.enumClass.getEnumConstants()) {
            this.enumNameMap.put((Object)e.name(), (Object)e);
        }
        this.defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultEnum.class)).map(Config.DefaultEnum::value).map(defName -> this.enumNameMap.values().stream().filter(e -> e.name().equals(defName)).findAny().orElseThrow(() -> new IllegalArgumentException("Default value \"" + defName + "\" was not found in enum " + this.enumClass.getName()))).orElseGet(() -> {
            Share.LOG.warn("The field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " has no DefaultEnum annotation!\nThis will be a crash in FalsePatternLib 0.11, update your code!");
            try {
                return (Enum)this.enumClass.cast(field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        this.maxLength = this.enumNameMap.keySet().stream().mapToInt(String::length).max().orElse(0);
        this.property.setDefaultValue(((Enum)this.defaultValue).name());
        this.property.setValidValues(this.enumNameMap.keySet().toArray(new String[0]));
        if (!this.enumNameMap.containsValue(this.getConfig())) {
            this.setToDefault();
        }
        this.property.comment = this.property.comment + "\n[default: " + this.defaultValue + ", possible values: " + Arrays.toString(this.enumNameMap.keySet().toArray(new String[0])) + "]";
    }

    public static void transmitString(DataOutput output, String value) throws IOException {
        output.writeInt(value.length());
        output.writeChars(value);
    }

    public static String receiveString(DataInput input, int maxLength, String fieldName, String className) throws IOException {
        int length = input.readInt();
        if (length > maxLength || length < 0) {
            throw new IOException("Error while retrieving config value for field " + fieldName + " in class " + className + ":\nIllegal string length received!");
        }
        char[] arr = new char[length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = input.readChar();
        }
        return new String(arr);
    }

    private T getEnumByName(String name) {
        if (!this.enumNameMap.containsKey((Object)name)) {
            Share.LOG.warn("Invalid value " + name + " for enum configuration field " + this.field.getName() + " of type " + this.enumClass.getName() + " in config class " + this.field.getDeclaringClass().getName() + "! Using default value of " + ((Enum)this.defaultValue).name() + "!");
            return this.defaultValue;
        }
        return (T)((Enum)this.enumNameMap.get((Object)name));
    }

    @Override
    protected T getField() {
        return (T)((Enum)this.enumClass.cast(this.field.get(null)));
    }

    @Override
    protected void putField(T value) {
        this.field.set(null, value);
    }

    @Override
    protected T getConfig() {
        return this.getEnumByName(this.property.getString());
    }

    @Override
    protected void putConfig(T value) {
        this.property.set(((Enum)value).name());
    }

    @Override
    protected T getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean validateField() {
        if (this.getField() == null) {
            ConfigValidationFailureEvent.fieldIsNull(this.field, -1);
            return false;
        }
        return true;
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        EnumConfigField.transmitString(output, ((Enum)this.getField()).name());
    }

    @Override
    public void receive(DataInput input) throws IOException {
        this.putField(this.getEnumByName(EnumConfigField.receiveString(input, this.maxLength, this.field.getName(), this.field.getDeclaringClass().getName())));
    }
}

