/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.internal.Share;
import com.falsepattern.lib.internal.impl.config.fields.AListConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class BooleanListConfigField
extends AListConfigField<boolean[]> {
    private final boolean[] defaultValue;

    public BooleanListConfigField(Field field, Configuration configuration, String category) throws ConfigException {
        super(field, configuration, category, Property.Type.BOOLEAN);
        this.defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultBooleanList.class)).map(Config.DefaultBooleanList::value).orElseGet(() -> {
            Share.LOG.warn("The field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " has no DefaultBooleanList annotation!\nThis will be a crash in FalsePatternLib 0.11, update your code!");
            try {
                return (boolean[])field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        this.property.setDefaultValues(this.defaultValue);
        if (!this.property.isBooleanList()) {
            this.setToDefault();
        }
        this.property.comment = this.property.comment + "\n[default: " + Arrays.toString(this.defaultValue) + "]";
    }

    @Override
    protected int length(boolean[] arr) {
        return arr.length;
    }

    @Override
    protected boolean[] arrayCopy(boolean[] arr) {
        return Arrays.copyOf(arr, arr.length);
    }

    @Override
    protected void transmitElements(DataOutput output, boolean[] arr) throws IOException {
        byte[] transfer = new byte[arr.length + 7 >>> 3];
        for (int i = 0; i < arr.length; ++i) {
            int n = i >>> 3;
            transfer[n] = (byte)(transfer[n] | (arr[i] ? 1 << (i & 7) : 0));
        }
        for (byte i : transfer) {
            output.writeByte(i);
        }
    }

    @Override
    protected void receiveElements(DataInput input, boolean[] arr) throws IOException {
        int i;
        byte[] transfer = new byte[arr.length + 7 >>> 3];
        for (i = 0; i < transfer.length; ++i) {
            transfer[i] = input.readByte();
        }
        for (i = 0; i < arr.length; ++i) {
            arr[i] = (transfer[i >>> 3] & 1 << (i & 7)) != 0;
        }
    }

    @Override
    protected boolean[] createArray(int length) {
        return new boolean[length];
    }

    @Override
    protected boolean[] getConfig() {
        return this.property.getBooleanList();
    }

    @Override
    protected void putConfig(boolean[] value) {
        this.property.set(value);
    }

    @Override
    protected boolean[] getDefault() {
        return Arrays.copyOf(this.defaultValue, this.defaultValue.length);
    }
}

