/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.config;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigurationManager;

@Config(modid="falsepatternlib")
public class LibraryConfig {
    @Config.Comment(value={"Used to control whether FalsePatternLib should check for outdated mods.", "If you're building a public modpack, you should turn this off so that your users don't get nagged about outdated mods."})
    @Config.LangKey(value="config.falsepatternlib.updatecheck")
    @Config.DefaultBoolean(value=true)
    public static boolean ENABLE_UPDATE_CHECKER;
    @Config.Comment(value={"Used to control whether FalsePatternLib should be allowed to use the internet.", "If this is disabled, library downloads will be blocked.", "Note that if a mod tries to download a library that is not downloaded yet, the game will crash."})
    @Config.LangKey(value="config.falsepatternlib.disableinternet")
    @Config.DefaultBoolean(value=true)
    public static boolean ENABLE_LIBRARY_DOWNLOADS;
    @Config.Comment(value={"How \"loud\" the config error logging should be."})
    @Config.LangKey(value="config.falsepatternlib.configlogging")
    @Config.DefaultEnum(value="Log")
    public static ValidationLogging CONFIG_ERROR_LOUDNESS;

    static {
        ConfigurationManager.selfInit();
    }

    public static enum ValidationLogging {
        None,
        Log,
        LogAndToast;

    }
}

