/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.compat;

import com.falsepattern.lib.StableAPI;
import lombok.NonNull;
import net.minecraft.util.EnumFacing;

@StableAPI(since="0.6.0")
public enum Rotation {
    NONE,
    CLOCKWISE_90,
    CLOCKWISE_180,
    COUNTERCLOCKWISE_90;


    @StableAPI.Expose
    public Rotation add(@NonNull Rotation rotation) {
        if (rotation == null) {
            throw new NullPointerException("rotation is marked non-null but is null");
        }
        Rotation[] values = Rotation.values();
        return values[(this.ordinal() + rotation.ordinal()) % values.length];
    }

    @StableAPI.Expose
    public EnumFacing rotate(@NonNull EnumFacing facing) {
        if (facing == null) {
            throw new NullPointerException("facing is marked non-null but is null");
        }
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            return facing;
        }
        switch (this) {
            case CLOCKWISE_90: {
                switch (facing) {
                    case NORTH: {
                        return EnumFacing.EAST;
                    }
                    case EAST: {
                        return EnumFacing.SOUTH;
                    }
                    case SOUTH: {
                        return EnumFacing.WEST;
                    }
                    case WEST: {
                        return EnumFacing.NORTH;
                    }
                }
                throw new IllegalStateException("Unable to get Y-rotated facing of " + facing);
            }
            case CLOCKWISE_180: {
                switch (facing) {
                    case NORTH: {
                        return EnumFacing.SOUTH;
                    }
                    case EAST: {
                        return EnumFacing.WEST;
                    }
                    case SOUTH: {
                        return EnumFacing.NORTH;
                    }
                    case WEST: {
                        return EnumFacing.EAST;
                    }
                }
                throw new IllegalStateException("Unable to get Y-rotated facing of " + facing);
            }
            case COUNTERCLOCKWISE_90: {
                switch (facing) {
                    case NORTH: {
                        return EnumFacing.WEST;
                    }
                    case EAST: {
                        return EnumFacing.NORTH;
                    }
                    case SOUTH: {
                        return EnumFacing.EAST;
                    }
                    case WEST: {
                        return EnumFacing.SOUTH;
                    }
                }
                throw new IllegalStateException("Unable to get Y-rotated facing of " + facing);
            }
        }
        return facing;
    }

    @StableAPI.Expose
    public int rotate(int x, int z) {
        switch (this) {
            case CLOCKWISE_90: {
                return (x + z / 4) % z;
            }
            case CLOCKWISE_180: {
                return (x + z / 2) % z;
            }
            case COUNTERCLOCKWISE_90: {
                return (x + z * 3 / 4) % z;
            }
        }
        return x;
    }
}

