/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeHandlerQuery;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class GuiUsageRecipe
extends GuiRecipe<IUsageHandler> {
    public static ArrayList<IUsageHandler> usagehandlers = new ArrayList();
    public static ArrayList<IUsageHandler> serialUsageHandlers = new ArrayList();

    public static boolean openRecipeGui(String inputId, Object ... ingredients) {
        RecipeHandlerQuery<IUsageHandler> recipeQuery = new RecipeHandlerQuery<IUsageHandler>(h -> GuiUsageRecipe.getUsageOrCatalystHandler(h, inputId, ingredients), usagehandlers, serialUsageHandlers);
        ArrayList<IUsageHandler> handlers = recipeQuery.runWithProfiling("recipe.concurrent.usage");
        if (handlers.isEmpty()) {
            return false;
        }
        Minecraft mc = NEIClientUtils.mc();
        BookmarkRecipeId recipeId = GuiUsageRecipe.getCurrentRecipe(mc.field_71462_r);
        GuiUsageRecipe gui = new GuiUsageRecipe(handlers, recipeId);
        mc.func_147108_a((GuiScreen)gui);
        gui.openTargetRecipe(gui.recipeId);
        return true;
    }

    private GuiUsageRecipe(ArrayList<IUsageHandler> handlers, BookmarkRecipeId recipeId) {
        super(NEIClientUtils.mc().field_71462_r);
        this.currenthandlers = handlers;
        this.recipeId = recipeId;
    }

    public static void registerUsageHandler(IUsageHandler handler) {
        String handlerId = handler.getHandlerId();
        if (usagehandlers.stream().anyMatch(h -> h.getHandlerId().equals(handlerId)) || serialUsageHandlers.stream().anyMatch(h -> h.getHandlerId().equals(handlerId))) {
            return;
        }
        if (NEIClientConfig.serialHandlers.contains(handlerId)) {
            serialUsageHandlers.add(handler);
        } else {
            usagehandlers.add(handler);
        }
    }

    private static IUsageHandler getUsageOrCatalystHandler(IUsageHandler handler, String inputId, Object ... ingredients) {
        boolean skipCatalyst = NEIClientUtils.controlKey();
        if (NEIClientConfig.areJEIStyleRecipeCatalystsVisible() && !skipCatalyst) {
            return handler.getUsageAndCatalystHandler(inputId, ingredients);
        }
        return handler.getUsageHandler(inputId, ingredients);
    }

    @Override
    public ArrayList<IUsageHandler> getCurrentRecipeHandlers() {
        return this.currenthandlers;
    }
}

