/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.ItemPanel;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ItemsGrid {
    public static final int SLOT_SIZE = 18;
    protected int width;
    protected int height;
    protected int marginLeft;
    protected int marginTop;
    protected int paddingLeft;
    protected ArrayList<ItemStack> realItems = new ArrayList();
    protected int page;
    protected int perPage;
    protected int rows;
    protected int columns;
    protected boolean[] invalidSlotMap;
    protected Label messageLabel = new Label(this.getMessageOnEmpty(), true);
    @Nullable
    private Framebuffer framebuffer = null;
    protected boolean refreshBuffer = true;

    public ArrayList<ItemStack> getItems() {
        return this.realItems;
    }

    public ItemStack getItem(int idx) {
        return this.realItems.get(idx);
    }

    public int size() {
        return this.realItems.size();
    }

    public int indexOf(ItemStack stackA, boolean useNBT) {
        for (int idx = 0; idx < this.realItems.size(); ++idx) {
            if (!StackInfo.equalItemAndNBT(stackA, this.getItem(idx), useNBT)) continue;
            return idx;
        }
        return -1;
    }

    public int getPage() {
        return this.page + 1;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getNumPages() {
        if (this.perPage > 0) {
            return (int)Math.ceil((float)this.realItems.size() / (float)this.perPage);
        }
        return 0;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setGridSize(int mleft, int mtop, int w, int h) {
        this.marginLeft = mleft;
        this.marginTop = mtop;
        this.width = Math.max(0, w);
        this.height = Math.max(0, h);
        this.columns = this.width / 18;
        this.rows = this.height / 18;
        this.paddingLeft = this.width % 18 / 2;
        this.messageLabel.x = this.marginLeft + this.width / 2;
        this.messageLabel.y = this.marginTop + this.height / 2;
    }

    public void shiftPage(int shift) {
        if (this.perPage == 0) {
            this.page = 0;
            return;
        }
        int numPages = this.getNumPages();
        int oldPage = this.page;
        this.page += shift;
        if (this.page >= numPages) {
            this.page -= numPages;
        }
        if (this.page < 0) {
            this.page = numPages + this.page;
        }
        this.page = Math.max(0, Math.min(this.page, numPages - 1));
        if (this.page != oldPage) {
            this.onGridChanged();
        }
    }

    protected void onGridChanged() {
        this.refreshBuffer = true;
    }

    public void refresh(GuiContainer gui) {
        this.updateGuiOverlapSlots(gui);
        this.shiftPage(0);
    }

    protected void updateGuiOverlapSlots(GuiContainer gui) {
        boolean[] oldSlotMap = this.invalidSlotMap;
        int oldRows = this.rows;
        int oldColumns = this.columns;
        this.invalidSlotMap = new boolean[this.rows * this.columns];
        this.perPage = this.columns * this.rows;
        if (NEIClientConfig.optimizeGuiOverlapComputation()) {
            this.checkGuiOverlap(gui, 0, this.columns - 2, 1);
            this.checkGuiOverlap(gui, this.columns - 1, 1, -1);
        } else {
            this.checkGuiOverlap(gui, 0, this.columns, 1);
        }
        if (oldRows != this.rows || oldColumns != this.columns || !Arrays.equals(oldSlotMap, this.invalidSlotMap)) {
            this.onGridChanged();
        }
    }

    private void checkGuiOverlap(GuiContainer gui, int start, int end, int dir) {
        boolean validColumn = false;
        for (int c = start; !(c == end || NEIClientConfig.optimizeGuiOverlapComputation() && validColumn); c += dir) {
            validColumn = true;
            for (int r = 0; r < this.rows; ++r) {
                int idx = this.columns * r + c;
                if (!GuiInfo.hideItemPanelSlot(gui, this.getSlotRect(r, c)) || idx < 0 || idx >= this.invalidSlotMap.length || this.invalidSlotMap[idx]) continue;
                this.invalidSlotMap[idx] = true;
                validColumn = false;
                --this.perPage;
            }
        }
    }

    public Rectangle4i getItemRect(int idx) {
        List<Integer> mask = this.getMask();
        for (int i = 0; i < mask.size(); ++i) {
            if (mask.get(i) == null || idx != mask.get(i)) continue;
            return this.getSlotRect(i);
        }
        return null;
    }

    public Rectangle4i getSlotRect(int i) {
        return this.getSlotRect(i / this.columns, i % this.columns);
    }

    public Rectangle4i getSlotRect(int row, int column) {
        return new Rectangle4i(this.marginLeft + this.paddingLeft + column * 18, this.marginTop + row * 18, 18, 18);
    }

    public boolean isInvalidSlot(int index) {
        return this.invalidSlotMap[index];
    }

    protected List<Integer> getMask() {
        ArrayList<Integer> mask = new ArrayList<Integer>();
        int idx = this.page * this.perPage;
        for (int i = 0; i < this.rows * this.columns && idx < this.size(); ++i) {
            mask.add(this.isInvalidSlot(i) ? null : Integer.valueOf(idx++));
        }
        return mask;
    }

    private void drawSlotOutlines(int mousex, int mousey) {
        ItemPanel.ItemPanelSlot focused = this.getSlotMouseOver(mousex, mousey);
        List<Integer> mask = this.getMask();
        for (int i = 0; i < mask.size(); ++i) {
            if (mask.get(i) == null) continue;
            this.drawSlotOutline(focused, mask.get(i), this.getSlotRect(i));
        }
    }

    protected void drawSlotOutline(@Nullable ItemPanel.ItemPanelSlot focused, int slotIdx, Rectangle4i rect) {
        if (focused != null && focused.slotIndex == slotIdx) {
            GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
        }
    }

    private void blitExistingBuffer() {
        Minecraft minecraft = Minecraft.func_71410_x();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)1, (int)771, (int)1, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getFrameBuffer().func_147612_c();
        GL11.glEnable((int)3553);
        ScaledResolution res = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, res.func_78324_d(), 0.0, 0.0, 0.0);
        tessellator.func_78374_a(res.func_78327_c(), res.func_78324_d(), 0.0, 1.0, 0.0);
        tessellator.func_78374_a(res.func_78327_c(), 0.0, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 1.0);
        tessellator.func_78381_a();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
    }

    private Framebuffer getFrameBuffer() {
        if (this.framebuffer == null) {
            this.framebuffer = new Framebuffer(1, 1, true);
            this.framebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.framebuffer;
    }

    private void drawItems() {
        GuiContainerManager.enableMatrixStackLogging();
        List<Integer> mask = this.getMask();
        for (int i = 0; i < mask.size(); ++i) {
            if (mask.get(i) == null) continue;
            this.drawItem(this.getSlotRect(i), mask.get(i));
        }
        GuiContainerManager.disableMatrixStackLogging();
    }

    public void draw(int mousex, int mousey) {
        if (this.getPerPage() == 0) {
            return;
        }
        if (NEIClientConfig.shouldCacheItemRendering()) {
            if (this.refreshBuffer) {
                Minecraft minecraft = Minecraft.func_71410_x();
                Framebuffer framebuffer = this.getFrameBuffer();
                framebuffer.func_147613_a(minecraft.field_71443_c, minecraft.field_71440_d);
                framebuffer.func_147614_f();
                framebuffer.func_147610_a(false);
                GL11.glDisable((int)3042);
                GL11.glDepthMask((boolean)true);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.drawItems();
                Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
                this.refreshBuffer = false;
            }
            this.drawSlotOutlines(mousex, mousey);
            this.blitExistingBuffer();
        } else {
            this.drawSlotOutlines(mousex, mousey);
            this.drawItems();
        }
    }

    public void setVisible() {
        if (this.getItems().isEmpty() && this.getMessageOnEmpty() != null) {
            LayoutManager.addWidget(this.messageLabel);
        }
    }

    protected void drawItem(Rectangle4i rect, int idx) {
        GuiContainerManager.drawItem(rect.x + 1, rect.y + 1, this.getItem(idx));
    }

    public ItemPanel.ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return null;
        }
        int overRow = (mousey - this.marginTop) / 18;
        int overColumn = (mousex - this.marginLeft - this.paddingLeft) / 18;
        int slt = this.columns * overRow + overColumn;
        if (overRow >= this.rows || overColumn >= this.columns) {
            return null;
        }
        List<Integer> mask = this.getMask();
        if (mask.size() > slt && mask.get(slt) != null) {
            int idx = mask.get(slt);
            return new ItemPanel.ItemPanelSlot(idx, this.getItem(idx));
        }
        return null;
    }

    public boolean contains(int px, int py) {
        if (!new Rectangle4i(this.marginLeft + this.paddingLeft, this.marginTop, this.columns * 18, this.height).contains(px, py)) {
            return false;
        }
        int r = (py - this.marginTop) / 18;
        int c = (px - this.marginLeft - this.paddingLeft) / 18;
        int slt = this.columns * r + c;
        return r >= this.rows || c >= this.columns || !this.isInvalidSlot(slt);
    }

    public String getMessageOnEmpty() {
        return null;
    }
}

