/*
 * Decompiled with CFR 0.152.
 */
package morph.common.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ichun.common.core.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import morph.common.Morph;
import morph.common.morph.MorphHandler;
import morph.common.morph.MorphState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PacketMorphStates
extends AbstractPacket {
    public boolean clear;
    public ArrayList<NBTTagCompound> stateTags = new ArrayList();

    public PacketMorphStates() {
    }

    public PacketMorphStates(boolean clear, ArrayList<MorphState> states) {
        this.clear = clear;
        for (MorphState state : states) {
            this.stateTags.add(state.getTag());
        }
    }

    public void writeTo(ByteBuf buffer, Side side) {
        buffer.writeBoolean(this.clear);
        for (NBTTagCompound tag : this.stateTags) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)"state");
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tag);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)"##end");
    }

    public void readFrom(ByteBuf buffer, Side side) {
        this.clear = buffer.readBoolean();
        while (ByteBufUtils.readUTF8String((ByteBuf)buffer).equalsIgnoreCase("state")) {
            this.stateTags.add(ByteBufUtils.readTag((ByteBuf)buffer));
        }
    }

    public void execute(Side side, EntityPlayer player) {
        if (side.isClient()) {
            this.handleClient(side, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient(Side side, EntityPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.clear) {
            Morph.proxy.tickHandlerClient.playerMorphCatMap.clear();
        }
        boolean requireReorder = false;
        for (NBTTagCompound tag : this.stateTags) {
            MorphState state = new MorphState((World)mc.field_71441_e, mc.field_71439_g.func_70005_c_(), "", null, true);
            if (tag == null) continue;
            state.readTag((World)mc.field_71441_e, tag);
            String name = state.entInstance.func_70005_c_();
            if (name == null) continue;
            ArrayList<MorphState> states = Morph.proxy.tickHandlerClient.playerMorphCatMap.get(name);
            if (states == null) {
                requireReorder = true;
                states = new ArrayList();
                Morph.proxy.tickHandlerClient.playerMorphCatMap.put(name, states);
            }
            MorphHandler.addOrGetMorphState(states, state);
        }
        if (requireReorder) {
            MorphHandler.reorderMorphs(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), Morph.proxy.tickHandlerClient.playerMorphCatMap);
        }
    }
}

