/*
 * Decompiled with CFR 0.152.
 */
package morph.common.ability;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import morph.api.Ability;
import morph.common.Morph;
import morph.common.morph.MorphInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

public class AbilityFly
extends Ability {
    public boolean slowdownInWater;
    public static final ResourceLocation iconResource = new ResourceLocation("morph", "textures/icon/fly.png");

    public AbilityFly() {
        this.slowdownInWater = true;
    }

    public AbilityFly(boolean slowdown) {
        this.slowdownInWater = slowdown;
    }

    @Override
    public Ability parse(String[] args) {
        this.slowdownInWater = Boolean.parseBoolean(args[0]);
        return this;
    }

    @Override
    public String getType() {
        return "fly";
    }

    @Override
    public void tick() {
        if (this.getParent() instanceof EntityPlayer) {
            if (Morph.config.getSessionInt("allowFlight") == 0) {
                return;
            }
            EntityPlayer player = (EntityPlayer)this.getParent();
            if (!player.field_71075_bZ.field_75101_c) {
                player.field_71075_bZ.field_75101_c = true;
                player.func_71016_p();
            }
            if (player.field_71075_bZ.field_75100_b && !player.field_71075_bZ.field_75098_d) {
                MorphInfo info;
                double motionZ;
                double motionX = player.field_70170_p.field_72995_K ? player.field_70159_w : player.field_70165_t - player.field_70142_S;
                int i = Math.round(MathHelper.func_76133_a((double)(motionX * motionX + (motionZ = player.field_70170_p.field_72995_K ? player.field_70179_y : player.field_70161_v - player.field_70136_U) * motionZ)) * 100.0f);
                if (i > 0 && i < 10) {
                    if (player.func_70090_H() && this.slowdownInWater) {
                        player.func_71020_j(0.125f * (float)i * 0.01f);
                    } else {
                        player.func_71020_j(0.035f * (float)i * 0.01f);
                    }
                } else {
                    player.func_71020_j(0.002f);
                }
                if (player.field_70170_p.field_72995_K && player.func_70090_H() && this.slowdownInWater && (info = (MorphInfo)Morph.proxy.tickHandlerClient.playerMorphInfo.get(player.func_70005_c_())) != null) {
                    boolean swim = false;
                    for (Ability ability : info.morphAbilities) {
                        if (!ability.getType().equalsIgnoreCase("swim")) continue;
                        swim = true;
                        break;
                    }
                    if (!swim) {
                        player.field_70159_w *= 0.65;
                        player.field_70179_y *= 0.65;
                        player.field_70181_x *= 0.2;
                    }
                }
            }
        }
        this.getParent().field_70143_R = 0.0f;
    }

    @Override
    public void kill() {
        if (this.getParent() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.getParent();
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
                if (player.field_71075_bZ.field_75100_b) {
                    player.field_71075_bZ.field_75100_b = false;
                }
                player.func_71016_p();
            }
        }
    }

    @Override
    public Ability clone() {
        return new AbilityFly(this.slowdownInWater);
    }

    @Override
    public void postRender() {
    }

    @Override
    public void save(NBTTagCompound tag) {
        tag.func_74757_a("slowdownInWater", this.slowdownInWater);
    }

    @Override
    public void load(NBTTagCompound tag) {
        this.slowdownInWater = tag.func_74767_n("slowdownInWater");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIcon() {
        return Morph.config.getSessionInt("allowFlight") == 1 ? iconResource : null;
    }
}

