/*
 * Decompiled with CFR 0.152.
 */
package morph.common.ability;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import morph.api.Ability;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class AbilityFloat
extends Ability {
    public double terminalVelocity;
    public boolean negateFallDistance;
    public static final ResourceLocation iconResource = new ResourceLocation("morph", "textures/icon/float.png");

    public AbilityFloat() {
        this.terminalVelocity = -1000.0;
        this.negateFallDistance = false;
    }

    public AbilityFloat(double termVelo, boolean negateFall) {
        this.terminalVelocity = termVelo;
        this.negateFallDistance = negateFall;
    }

    @Override
    public Ability parse(String[] args) {
        this.terminalVelocity = Double.parseDouble(args[0]);
        this.negateFallDistance = Boolean.parseBoolean(args[1]);
        return this;
    }

    @Override
    public String getType() {
        return "float";
    }

    @Override
    public void tick() {
        boolean flying = false;
        if (this.getParent() instanceof EntityPlayer) {
            flying = ((EntityPlayer)this.getParent()).field_71075_bZ.field_75100_b;
        }
        if (!flying && this.getParent().field_70181_x < this.terminalVelocity) {
            this.getParent().field_70181_x = this.terminalVelocity;
            if (this.negateFallDistance) {
                this.getParent().field_70143_R = 0.0f;
            }
        }
    }

    @Override
    public void kill() {
    }

    @Override
    public Ability clone() {
        return new AbilityFloat(this.terminalVelocity, this.negateFallDistance);
    }

    @Override
    public void postRender() {
    }

    @Override
    public void save(NBTTagCompound tag) {
        tag.func_74780_a("terminalVelocity", this.terminalVelocity);
        tag.func_74757_a("negateFallDistance", this.negateFallDistance);
    }

    @Override
    public void load(NBTTagCompound tag) {
        this.terminalVelocity = tag.func_74769_h("terminalVelocity");
        this.negateFallDistance = tag.func_74767_n("negateFallDistance");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIcon() {
        return iconResource;
    }
}

