/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.maxhenkel.gravestone.ModItems;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import de.maxhenkel.gravestone.util.BlockPos;
import de.maxhenkel.gravestone.util.Tools;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGraveStone
extends BlockContainer {
    public static final String NAME = "gravestone";

    public BlockGraveStone() {
        super(new Material(MapColor.field_151664_l));
        this.func_149663_c(NAME);
        this.func_149711_c(0.3f);
        this.func_149752_b(Float.MAX_VALUE);
        this.field_149783_u = true;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return ModItems.GRAVESTONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("minecraft:dirt");
    }

    public void func_149723_a(World p_149723_1_, int p_149723_2_, int p_149723_3_, int p_149723_4_, Explosion p_149723_5_) {
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149747_d(IBlockAccess p_149747_1_, int p_149747_2_, int p_149747_3_, int p_149747_4_, int p_149747_5_) {
        return false;
    }

    public boolean func_149646_a(IBlockAccess p_149646_1_, int p_149646_2_, int p_149646_3_, int p_149646_4_, int p_149646_5_) {
        return true;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149643_k(World p_149643_1_, int p_149643_2_, int p_149643_3_, int p_149643_4_) {
        return super.func_149643_k(p_149643_1_, p_149643_2_, p_149643_3_, p_149643_4_);
    }

    public void func_149689_a(World world, int p_149689_2_, int p_149689_3_, int p_149689_4_, EntityLivingBase entity, ItemStack p_149689_6_) {
        int l = ((MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) + 2) % 4;
        world.func_72921_c(p_149689_2_, p_149689_3_, p_149689_4_, l, 3);
        super.func_149689_a(world, p_149689_2_, p_149689_3_, p_149689_4_, entity, p_149689_6_);
    }

    public int func_150162_k(int p_150162_1_) {
        return p_150162_1_ & 3;
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149719_a(IBlockAccess p_149719_1_, int p_149719_2_, int p_149719_3_, int p_149719_4_) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.11f, 1.0f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGraveStone();
    }

    public void func_149749_a(World worldIn, int x, int y, int z, Block block, int damage) {
        TileEntity tileentity = worldIn.func_147438_o(x, y, z);
        if (tileentity instanceof TileEntityGraveStone) {
            Tools.dropInventoryItems(worldIn, new BlockPos(x, y, z), (TileEntityGraveStone)tileentity);
        }
        super.func_149749_a(worldIn, x, y, z, block, damage);
    }

    protected boolean func_149700_E() {
        return true;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer playerIn, int damage, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_147438_o(x, y, z);
        if (!(tileentity instanceof TileEntityGraveStone)) {
            return super.func_149727_a(worldIn, x, y, z, playerIn, damage, hitX, hitY, hitZ);
        }
        TileEntityGraveStone grave = (TileEntityGraveStone)tileentity;
        return this.displayGraveInfo(grave, playerIn);
    }

    private boolean displayGraveInfo(TileEntityGraveStone grave, EntityPlayer player) {
        String name = grave.getPlayerName();
        String time = grave.getTimeString();
        if (name == null || name.isEmpty()) {
            return true;
        }
        if (time == null || time.isEmpty()) {
            player.func_145747_a((IChatComponent)new ChatComponentText(name));
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentText(Tools.translate("message.died", name, time)));
        }
        return true;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

