/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.Log;
import de.maxhenkel.gravestone.ModBlocks;
import de.maxhenkel.gravestone.ModItems;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import de.maxhenkel.gravestone.util.BlockPos;
import de.maxhenkel.gravestone.util.NoSpaceException;
import de.maxhenkel.gravestone.util.Tools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GraveProcessor {
    private EntityLivingBase entity;
    private World world;
    private BlockPos deathPosition;
    private BlockPos gravePosition;
    private static List<Block> replaceableBlocks;
    private List<ItemStack> drops;
    private long time;

    public GraveProcessor(EntityLivingBase entity) {
        this.entity = entity;
        this.world = entity.field_70170_p;
        this.deathPosition = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        System.out.println(this.deathPosition);
        this.gravePosition = this.deathPosition;
        this.drops = new ArrayList<ItemStack>();
        this.time = System.currentTimeMillis();
        if (replaceableBlocks == null) {
            replaceableBlocks = Config.instance().replaceableBlocks;
        }
    }

    public boolean placeGraveStone(List<EntityItem> drops) {
        for (EntityItem ei : drops) {
            this.drops.add(ei.func_92059_d());
        }
        try {
            this.gravePosition = this.getGraveStoneLocation();
        }
        catch (NoSpaceException e) {
            this.gravePosition = this.deathPosition;
            Log.i("Grave from '" + this.entity.func_70005_c_() + "' cant be created (No space)");
            return false;
        }
        try {
            int l = Tools.oppositeSite(this.entity);
            this.world.func_147465_d(this.gravePosition.getX(), this.gravePosition.getY(), this.gravePosition.getZ(), (Block)ModBlocks.GRAVESTONE, l, 2);
            System.out.println(this.gravePosition);
            if (this.isReplaceable(this.gravePosition.down())) {
                this.world.func_147449_b(this.gravePosition.down().getX(), this.gravePosition.down().getY(), this.gravePosition.down().getZ(), Blocks.field_150346_d);
            }
        }
        catch (Exception e) {
            return false;
        }
        TileEntity tileentity = this.world.func_147438_o(this.gravePosition.getX(), this.gravePosition.getY(), this.gravePosition.getZ());
        if (tileentity == null || !(tileentity instanceof TileEntityGraveStone)) {
            return false;
        }
        try {
            TileEntityGraveStone graveTileEntity = (TileEntityGraveStone)tileentity;
            graveTileEntity.setPlayerName(this.entity.func_70005_c_());
            graveTileEntity.setPlayerUUID(this.entity.func_110124_au().toString());
            graveTileEntity.setDeathTime(this.time);
            graveTileEntity.setRenderHead(this.entity instanceof EntityPlayer);
            this.addItems(graveTileEntity, drops);
        }
        catch (Exception e) {
            Log.w("Failed to fill gravestone with data");
        }
        return true;
    }

    private void addItems(TileEntityGraveStone graveStone, List<EntityItem> items) {
        try {
            for (int i = 0; i < items.size(); ++i) {
                EntityItem item = items.get(i);
                try {
                    ItemStack stack = item.func_92059_d();
                    graveStone.func_70299_a(i, stack);
                    continue;
                }
                catch (Exception e) {
                    Log.w("Failed to add Item '" + item.func_92059_d().func_77977_a() + "' to gravestone");
                }
            }
        }
        catch (Exception e) {
            Log.w("Failed to add Ites to gravestone");
        }
    }

    public BlockPos getGraveStoneLocation() throws NoSpaceException {
        BlockPos location = new BlockPos(this.deathPosition.getX(), this.deathPosition.getY(), this.deathPosition.getZ());
        if (location.getY() < 1) {
            location = new BlockPos(location.getX(), 1, location.getZ());
        }
        while (location.getY() < this.entity.field_70170_p.func_72800_K()) {
            if (this.isReplaceable(location)) {
                return location;
            }
            location.setY(location.getY() + 1);
        }
        throw new NoSpaceException("No free Block above death Location");
    }

    private boolean isReplaceable(BlockPos pos) {
        Block b = this.world.func_147439_a(pos.getX(), pos.getY(), pos.getZ());
        if (b.func_149739_a().equals(Blocks.field_150350_a.func_149739_a())) {
            return true;
        }
        for (Block replaceableBlock : replaceableBlocks) {
            if (!b.func_149739_a().equals(replaceableBlock.func_149739_a())) continue;
            return true;
        }
        return false;
    }

    public void givePlayerNote() {
        ItemStack stack;
        if (!(this.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)this.entity;
        DeathInfo.ItemInfo[] items = new DeathInfo.ItemInfo[this.drops.size()];
        for (int i = 0; i < this.drops.size(); ++i) {
            stack = this.drops.get(i);
            if (stack == null) continue;
            items[i] = new DeathInfo.ItemInfo(Tools.getStringFromItem(stack.func_77973_b()), stack.field_77994_a, stack.func_77960_j());
        }
        DeathInfo info = new DeathInfo(this.gravePosition, player.field_71093_bK, items, player.getDisplayName(), this.time, player.func_110124_au());
        stack = new ItemStack((Item)ModItems.DEATH_INFO);
        info.addToItemStack(stack);
        player.field_71071_by.func_70441_a(stack);
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getDeathPosition() {
        return this.deathPosition;
    }

    public static List<Block> getReplaceableBlocks() {
        return replaceableBlocks;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public long getTime() {
        return this.time;
    }

    public BlockPos getGravePosition() {
        return this.gravePosition;
    }
}

