/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robotics.boards.BCBoardNBT;
import buildcraft.robotics.boards.BoardRobotGenericBreakBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BoardRobotMiner
extends BoardRobotGenericBreakBlock {
    private static final int MAX_HARVEST_LEVEL = 3;
    private int harvestLevel = 0;

    public BoardRobotMiner(EntityRobotBase iRobot) {
        super(iRobot);
        this.detectHarvestLevel();
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        super.delegateAIEnded(ai);
        if (ai instanceof AIRobotFetchAndEquipItemStack && ai.success()) {
            this.detectHarvestLevel();
        }
    }

    private void detectHarvestLevel() {
        ItemStack stack = this.robot.func_70694_bm();
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b().getToolClasses(stack).contains("pickaxe")) {
            this.harvestLevel = stack.func_77973_b().getHarvestLevel(stack, "pickaxe");
        }
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("miner");
    }

    @Override
    public boolean isExpectedTool(ItemStack stack) {
        return stack != null && stack.func_77973_b().getToolClasses(stack).contains("pickaxe");
    }

    @Override
    public boolean isExpectedBlock(World world, int x, int y, int z) {
        return BuildCraftAPI.getWorldProperty("ore@hardness=" + Math.min(3, this.harvestLevel)).get(world, x, y, z);
    }
}

