/*
 * Decompiled with CFR 0.152.
 */
package mmdanggg2.doge.items;

import mmdanggg2.doge.Doge;
import mmdanggg2.doge.DogeInfo;
import mmdanggg2.doge.util.DogeLogger;
import mmdanggg2.doge.util.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class GPU
extends Item {
    private int coinChance;
    private float speedStart;
    private float speedStep;
    private int coolRate;

    public GPU() {
        this.field_77777_bU = 1;
        this.func_77656_e(20);
        this.func_77637_a(Doge.dogeTab);
        this.func_77655_b("gpu");
        this.func_111206_d("Doge".toLowerCase() + ":gpu");
        this.coinChance = DogeInfo.gpuChance;
        this.speedStart = DogeInfo.gpuSpeedStart;
        this.speedStep = DogeInfo.gpuSpeedStep;
        this.coolRate = DogeInfo.gpuCoolRate;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (stack.field_77990_d == null) {
                this.initTags(stack);
            }
            stack.func_77964_b(0);
        }
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return NBTHelper.getFloat(stack.field_77990_d, "speed", this.speedStart);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return 3;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int xPos, int yPos, int zPos, EntityLivingBase entityLiving) {
        if (!world.field_72995_K) {
            boolean mined = this.attemptMine(stack, world, this.coinChance);
            if (mined) {
                EntityItem coin = new EntityItem(world);
                coin.func_92058_a(new ItemStack((Item)Doge.dogecoin, 1));
                coin.func_70107_b((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5);
                world.func_72838_d((Entity)coin);
            }
            if (stack.func_77960_j() > stack.func_77958_k()) {
                world.func_72876_a((Entity)entityLiving, (double)xPos, (double)yPos, (double)zPos, 2.0f, true);
                stack.field_77994_a = 0;
            }
        }
        return super.func_150894_a(stack, world, block, xPos, yPos, zPos, entityLiving);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return super.func_77659_a(stack, world, player);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean inHand) {
        if (world.field_73012_v.nextInt(10) == 0 && inHand) {
            this.randomDisplayTick(stack, world, entity);
        }
        if (!world.field_72995_K) {
            if (stack.field_77990_d == null) {
                this.initTags(stack);
            }
            NBTTagCompound stackTag = stack.field_77990_d;
            if (!inHand) {
                int tickCount = NBTHelper.getInt(stackTag, "tickCount", 0);
                if (tickCount >= this.coolRate) {
                    tickCount = 0;
                    if (stack.func_77960_j() > 0) {
                        float speed = NBTHelper.getFloat(stackTag, "speed", this.speedStart);
                        if (speed > this.speedStart) {
                            DogeLogger.logDebug("GPU Speed = " + (speed -= this.speedStep));
                            stackTag.func_74776_a("speed", speed);
                        }
                        stack.func_77972_a(-1, (EntityLivingBase)entity);
                    }
                }
                stackTag.func_74768_a("tickCount", ++tickCount);
            }
        }
        super.func_77663_a(stack, world, entity, itemSlot, inHand);
    }

    public boolean canHarvestBlock(Block par1Block, ItemStack itemStack) {
        return true;
    }

    private void initTags(ItemStack stack) {
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74776_a("speed", this.speedStart);
        stack.field_77990_d.func_74768_a("tickCount", 0);
    }

    public boolean attemptMine(ItemStack stack, World world, int chance) {
        boolean mined = false;
        stack.func_96631_a(1, world.field_73012_v);
        if (world.field_73012_v.nextInt(chance) == 0) {
            mined = true;
        }
        if (stack.field_77990_d == null) {
            this.initTags(stack);
        }
        NBTTagCompound stackTag = stack.field_77990_d;
        float speed = NBTHelper.getFloat(stackTag, "speed", this.speedStart);
        DogeLogger.logDebug("GPU Speed = " + (speed += this.speedStep));
        stackTag.func_74776_a("speed", speed);
        return mined;
    }

    private void randomDisplayTick(ItemStack stack, World world, Entity entity) {
        if (entity instanceof EntityPlayer && world.field_72995_K) {
            double offsetY;
            double offsetZ;
            double offsetX;
            EntityPlayer player = (EntityPlayer)entity;
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            float yaw = player.field_70759_as;
            float pitch = player.field_70125_A;
            if (Minecraft.func_71410_x().field_71439_g == player && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                float depth = 0.3f;
                offsetX = -MathHelper.func_76126_a((float)((yaw += 60.0f) / 180.0f * (float)Math.PI)) * depth;
                offsetZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * depth;
                offsetY = -MathHelper.func_76126_a((float)((pitch += 30.0f) / 180.0f * (float)Math.PI)) * depth;
            } else {
                yaw = player.field_70761_aq;
                float depth = 0.5f;
                offsetX = -MathHelper.func_76126_a((float)((yaw += 35.0f) / 180.0f * (float)Math.PI)) * depth;
                offsetZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * depth;
                offsetY = -0.6;
            }
            if (stack.func_77960_j() > 5) {
                world.func_72869_a("reddust", x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
            }
            if (stack.func_77960_j() > 10) {
                world.func_72869_a("reddust", x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
            }
            if (stack.func_77960_j() > 15) {
                world.func_72869_a("smoke", x + offsetX, y + offsetY, z + offsetZ, player.field_70159_w, 0.0, player.field_70179_y);
            }
            if (stack.func_77960_j() > 18) {
                world.func_72869_a("flame", x + offsetX, y + offsetY, z + offsetZ, player.field_70159_w, 0.01, player.field_70179_y);
            }
        }
    }
}

