/*
 * Decompiled with CFR 0.152.
 */
package mmdanggg2.doge.blocks.tileentities;

import java.util.Map;
import mmdanggg2.doge.Doge;
import mmdanggg2.doge.DogeInfo;
import mmdanggg2.doge.blocks.MiningRig;
import mmdanggg2.doge.items.GPU;
import mmdanggg2.doge.util.DogeLogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class MiningRigTileEntity
extends TileEntity
implements ISidedInventory {
    private ItemStack[] items = new ItemStack[5];

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Items", (NBTBase)items);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList items = compound.func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(count);
            }
        }
        return stack;
    }

    public String func_145825_b() {
        return "MiningRig";
    }

    public int func_70297_j_() {
        return 1;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70304_b(int arg0) {
        ItemStack stack = this.func_70301_a(arg0);
        this.func_70299_a(arg0, null);
        return stack;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        boolean valid = false;
        Item item = stack.func_77973_b();
        valid = i == 4 ? item == Doge.dogecoin : item == Doge.gpu;
        return valid;
    }

    public boolean func_70300_a(EntityPlayer arg0) {
        return arg0.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.items[i] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_() && i != 4) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int gpus = 0;
            for (int i = 0; i < this.func_70302_i_() - 1; ++i) {
                ItemStack gpuStack = this.func_70301_a(i);
                if (gpuStack == null || !(gpuStack.func_77973_b() instanceof GPU)) continue;
                ++gpus;
                GPU gpu = (GPU)gpuStack.func_77973_b();
                ItemStack dogeStack = this.func_70301_a(4);
                if (dogeStack != null && (dogeStack.func_77973_b() != Doge.dogecoin || dogeStack.field_77994_a >= 64) || this.field_145850_b.field_73012_v.nextInt(DogeInfo.rigSpeed) != 0) continue;
                boolean mined = gpu.attemptMine(gpuStack, this.field_145850_b, DogeInfo.rigChance);
                DogeLogger.logDebug("stack dmg = " + gpuStack.func_77960_j() + "; mined = " + mined);
                if (mined) {
                    if (dogeStack == null) {
                        DogeLogger.logDebug("new coin stack!");
                        dogeStack = new ItemStack((Item)Doge.dogecoin, 1);
                    } else {
                        ++dogeStack.field_77994_a;
                        DogeLogger.logDebug("coin stack size = " + dogeStack.field_77994_a);
                    }
                    this.func_70299_a(4, dogeStack);
                }
                if (gpuStack.func_77960_j() < gpuStack.func_77958_k()) continue;
                DogeLogger.logDebug("setting stack to null");
                this.func_70299_a(i, null);
            }
            int meta = this.getMeta();
            if (gpus > 0) {
                if ((meta |= 4) != this.getMeta()) {
                    DogeLogger.logDebug("Setting meta to " + Integer.toBinaryString(meta) + ", " + meta);
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 2);
                }
            } else if ((meta &= 0xFFFFFFFB) != this.getMeta()) {
                DogeLogger.logDebug("Setting meta to " + Integer.toBinaryString(meta) + ", " + meta);
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 2);
            }
        }
    }

    public boolean isMining() {
        return (this.getMeta() & 4) != 0;
    }

    private int getMeta() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int[] func_94128_d(int side) {
        int[] inSlots = new int[]{0, 1, 2, 3};
        int[] outSlots = new int[]{4};
        Map<String, Integer> currRotation = MiningRig.getSidesOfCurrentRotation(this.getMeta());
        int front = currRotation.get("front");
        int right = currRotation.get("right");
        int back = currRotation.get("back");
        int left = currRotation.get("left");
        int top = currRotation.get("top");
        int bottom = currRotation.get("bottom");
        if (side == top || side == back || side == left) {
            return inSlots;
        }
        if (side == bottom || side == front || side == right) {
            return outSlots;
        }
        return null;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        Map<String, Integer> currRotation = MiningRig.getSidesOfCurrentRotation(this.getMeta());
        int front = currRotation.get("front");
        int right = currRotation.get("right");
        int back = currRotation.get("back");
        int left = currRotation.get("left");
        int top = currRotation.get("top");
        int bottom = currRotation.get("bottom");
        if (side == top || side == back || side == left) {
            DogeLogger.logDebug("Can't Extract Item");
            return false;
        }
        if (side == bottom || side == front || side == right) {
            DogeLogger.logDebug("Can Extract Item");
            return true;
        }
        return false;
    }
}

