/*
 * Decompiled with CFR 0.152.
 */
package mmdanggg2.doge.blocks;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mmdanggg2.doge.Doge;
import mmdanggg2.doge.blocks.tileentities.MiningRigTileEntity;
import mmdanggg2.doge.util.DogeLogger;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MiningRig
extends BlockContainer {
    private static IIcon iconBottom;
    private static IIcon iconTopBackOn;
    private static IIcon iconFrontOn;
    private static IIcon iconSideOn;
    private static IIcon iconTopBackOff;
    private static IIcon iconFrontOff;
    private static IIcon iconSideOff;

    public MiningRig(Material material) {
        super(material);
        this.func_149711_c(2.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c("miningRig");
        this.func_149647_a(Doge.dogeTab);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new MiningRigTileEntity();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Doge.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int rotation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (!world.field_72995_K) {
            DogeLogger.logDebug("MiningRig Placed, meta = " + rotation);
        }
        if (rotation == 0) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (rotation == 1) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        if (rotation == 2) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (rotation == 3) {
            world.func_72921_c(x, y, z, 3, 2);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70304_b(i);
                if (stack == null) continue;
                float spawnX = (float)x + world.field_73012_v.nextFloat();
                float spawnY = (float)y + world.field_73012_v.nextFloat();
                float spawnZ = (float)z + world.field_73012_v.nextFloat();
                EntityItem droppedItem = new EntityItem(world, (double)spawnX, (double)spawnY, (double)spawnZ, stack);
                float mult = 0.05f;
                droppedItem.field_70159_w = (-0.5f + world.field_73012_v.nextFloat()) * mult;
                droppedItem.field_70181_x = (4.0f + world.field_73012_v.nextFloat()) * mult;
                droppedItem.field_70179_y = (-0.5f + world.field_73012_v.nextFloat()) * mult;
                world.func_72838_d((Entity)droppedItem);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public IIcon func_149691_a(int side, int meta) {
        boolean mining = (meta & 4) != 0;
        Map<String, Integer> currRotation = MiningRig.getSidesOfCurrentRotation(meta);
        int front = currRotation.get("front");
        int right = currRotation.get("right");
        int back = currRotation.get("back");
        int left = currRotation.get("left");
        int top = currRotation.get("top");
        int bottom = currRotation.get("bottom");
        meta &= 0xFFFFFFFB;
        if (side == bottom) {
            return iconBottom;
        }
        if (mining) {
            if (side == top || side == back) {
                return iconTopBackOn;
            }
            if (side == front) {
                return iconFrontOn;
            }
            if (side == left || side == right) {
                return iconSideOn;
            }
        } else {
            if (side == top || side == back) {
                return iconTopBackOff;
            }
            if (side == front) {
                return iconFrontOff;
            }
            if (side == left || side == right) {
                return iconSideOff;
            }
        }
        return null;
    }

    public void func_149651_a(IIconRegister icon) {
        String name = "Doge".toLowerCase();
        iconBottom = icon.func_94245_a(name + ":miningRigBottom");
        iconTopBackOn = icon.func_94245_a(name + ":miningRigTopBackOn");
        iconFrontOn = icon.func_94245_a(name + ":miningRigFrontOn");
        iconSideOn = icon.func_94245_a(name + ":miningRigSideOn");
        iconTopBackOff = icon.func_94245_a(name + ":miningRigTopBackOff");
        iconFrontOff = icon.func_94245_a(name + ":miningRigFrontOff");
        iconSideOff = icon.func_94245_a(name + ":miningRigSideOff");
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        MiningRigTileEntity mrte;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof MiningRigTileEntity && (mrte = (MiningRigTileEntity)te).isMining()) {
            int meta = world.func_72805_g(x, y, z);
            float facingOffset = 1.05f;
            if ((meta &= 0xFFFFFFFB) == 1 && world.func_147437_c(x - 1, y, z)) {
                world.func_72869_a("smoke", (double)x, (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.05, 0.0, 0.0);
                world.func_72869_a("reddust", (double)x, (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), 0.0, 0.0, 0.0);
            } else if (meta == 3 && world.func_147437_c(x + 1, y, z)) {
                world.func_72869_a("smoke", (double)((float)x + facingOffset), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), 0.05, 0.0, 0.0);
                world.func_72869_a("reddust", (double)((float)x + facingOffset), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), 0.0, 0.0, 0.0);
            } else if (meta == 2 && world.func_147437_c(x, y, z - 1)) {
                world.func_72869_a("smoke", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)z, 0.0, 0.0, -0.05);
                world.func_72869_a("reddust", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)z, 0.0, 0.0, 0.0);
            } else if (meta == 0 && world.func_147437_c(x, y, z + 1)) {
                world.func_72869_a("smoke", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + facingOffset), 0.0, 0.0, 0.05);
                world.func_72869_a("reddust", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + facingOffset), 0.0, 0.0, 0.0);
            }
        }
    }

    public static Map<String, Integer> getSidesOfCurrentRotation(int meta) {
        int[] sideOrder;
        HashMap<String, Integer> sides = new HashMap<String, Integer>();
        sides.put("bottom", 0);
        sides.put("top", 1);
        switch (meta &= 0xFFFFFFFB) {
            case 0: {
                sideOrder = new int[]{2, 5, 3, 4};
                break;
            }
            case 1: {
                sideOrder = new int[]{5, 2, 4, 3};
                break;
            }
            case 2: {
                sideOrder = new int[]{3, 5, 2, 4};
                break;
            }
            case 3: {
                sideOrder = new int[]{4, 2, 5, 3};
                break;
            }
            default: {
                sideOrder = new int[]{2, 5, 3, 4};
            }
        }
        sides.put("front", sideOrder[0]);
        sides.put("left", sideOrder[1]);
        sides.put("back", sideOrder[2]);
        sides.put("right", sideOrder[3]);
        return sides;
    }
}

