/*
 * Decompiled with CFR 0.152.
 */
package com.jadarstudios.developercapes.cape;

import com.jadarstudios.developercapes.DevCapes;
import com.jadarstudios.developercapes.cape.ICape;
import com.jadarstudios.developercapes.cape.StaticCape;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;

public enum CapeManager {
    INSTANCE;

    private HashMap<String, ICape> capes = new HashMap();

    public void addCape(ICape cape) {
        if (!this.capes.containsValue(cape)) {
            this.capes.put(cape.getName(), cape);
        }
    }

    public void addCapes(Collection<ICape> capes) {
        for (ICape c : capes) {
            this.addCape(c);
        }
    }

    public ICape getCape(String capeName) {
        return this.capes.get(capeName);
    }

    public ICape newInstance(String name) {
        StaticCape cape = new StaticCape(name);
        this.capes.put(name, cape);
        return cape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICape parse(String name, Object object) {
        StaticCape cape = null;
        if (!(object instanceof String)) {
            DevCapes.logger.error(String.format("Cape, %s, could not be parsed because it is not a String!", object));
            return cape;
        }
        try {
            cape = new StaticCape(name, new URL((String)object));
            return cape;
        }
        catch (MalformedURLException e) {
            DevCapes.logger.error(String.format("Are you crazy?? %s is not a valid URL!", (String)object));
            e.printStackTrace();
        }
        finally {
            return cape;
        }
    }
}

