/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import openccsensors.common.util.InventoryUtils;

public class EntityUtils {
    public static HashMap<String, Entity> getEntities(World world, ChunkCoordinates location, double radius, Class filter) {
        HashMap<String, Entity> map = new HashMap<String, Entity>();
        int dChunk = (int)Math.ceil(radius / 16.0);
        int x = location.field_71574_a;
        int y = location.field_71572_b;
        int z = location.field_71573_c;
        for (int dx = -dChunk; dx <= dChunk; ++dx) {
            for (int dz = -dChunk; dz <= dChunk; ++dz) {
                Chunk chunk = world.func_72938_d(x + 16 * dx, z + 16 * dz);
                for (List subchunk : chunk.field_76645_j) {
                    for (Entity entity : subchunk) {
                        Vec3 livingPos = Vec3.func_72443_a((double)(entity.field_70165_t + 0.5), (double)(entity.field_70163_u + 0.5), (double)(entity.field_70161_v + 0.5));
                        if (!(Vec3.func_72443_a((double)location.field_71574_a, (double)location.field_71572_b, (double)location.field_71573_c).func_72438_d(livingPos) <= radius) || !filter.isAssignableFrom(entity.getClass())) continue;
                        String targetName = entity instanceof EntityPlayer ? entity.func_70005_c_() : entity.func_70005_c_() + entity.func_145782_y();
                        targetName = targetName.replaceAll("\\s", "");
                        map.put(targetName, entity);
                    }
                }
            }
        }
        return map;
    }

    public static HashMap livingToMap(EntityLivingBase living, ChunkCoordinates sensorPos, boolean additional) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Double> position = new HashMap<String, Double>();
        position.put("X", living.field_70165_t - (double)sensorPos.field_71574_a);
        position.put("Y", living.field_70163_u - (double)sensorPos.field_71572_b);
        position.put("Z", living.field_70161_v - (double)sensorPos.field_71573_c);
        map.put("Position", position);
        map.put("Name", living instanceof EntityPlayerMP ? "Player" : living.func_70005_c_());
        map.put("RawName", living.getClass().getName());
        map.put("IsPlayer", living instanceof EntityPlayerMP);
        if (additional) {
            map.put("HeldItem", InventoryUtils.itemstackToMap(living.func_70694_bm()));
            HashMap<String, HashMap> armour = new HashMap<String, HashMap>();
            armour.put("Boots", InventoryUtils.itemstackToMap(living.func_71124_b(1)));
            armour.put("Leggings", InventoryUtils.itemstackToMap(living.func_71124_b(2)));
            armour.put("Chestplate", InventoryUtils.itemstackToMap(living.func_71124_b(3)));
            armour.put("Helmet", InventoryUtils.itemstackToMap(living.func_71124_b(4)));
            map.put("Armour", armour);
            map.put("Health", Float.valueOf(living.func_110143_aJ()));
            map.put("IsAirborne", !living.field_70122_E);
            map.put("IsBurning", living.func_70027_ad());
            map.put("IsAlive", living.func_70089_S());
            map.put("IsInWater", living.func_70090_H());
            map.put("IsOnLadder", living.func_70617_f_());
            map.put("IsSleeping", living.func_70608_bn());
            map.put("IsRiding", living.func_70115_ae());
            map.put("IsSneaking", living.func_70093_af());
            map.put("IsSprinting", living.func_70051_ag());
            map.put("IsWet", living.func_70026_G());
            map.put("IsChild", living.func_70631_g_());
            map.put("Yaw", Float.valueOf(living.field_70177_z));
            map.put("Pitch", Float.valueOf(living.field_70125_A));
            map.put("YawHead", Float.valueOf(living.field_70759_as));
            HashMap<Integer, String> potionEffects = new HashMap<Integer, String>();
            Collection effects = living.func_70651_bq();
            int count = 1;
            for (PotionEffect effect : effects) {
                potionEffects.put(count, effect.func_76453_d());
                ++count;
            }
            map.put("PotionEffects", potionEffects);
        }
        if (living instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)living;
            map.put("Username", player.func_70005_c_());
            map.put("IsBlocking", player.func_70632_aY());
            map.put("ExperienceTotal", player.field_71067_cb);
            map.put("ExperienceLevel", player.field_71068_ca);
            map.put("Experience", Float.valueOf(player.field_71106_cc));
            if (additional) {
                map.put("FoodLevel", player.func_71024_bL().func_75116_a());
                map.put("Gamemode", player.field_71075_bZ.field_75098_d);
                map.put("Inventory", InventoryUtils.invToMap((IInventory)player.field_71071_by));
            }
            map.put("Experience", Float.valueOf(player.field_71106_cc));
        }
        if (living instanceof EntityTameable) {
            EntityTameable tameable = (EntityTameable)living;
            map.put("IsSitting", tameable.func_70906_o());
            map.put("IsTamed", tameable.func_70909_n());
            if (tameable.func_70909_n()) {
                map.put("OwnerName", tameable.func_70902_q().func_70005_c_());
            }
            if (tameable instanceof EntityWolf) {
                EntityWolf wolf = (EntityWolf)tameable;
                map.put("IsAngry", wolf.func_70919_bu());
                if (wolf.func_70909_n()) {
                    map.put("CollarColor", wolf.func_82186_bH());
                }
            }
        }
        return map;
    }
}

