/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.turtle;

import cpw.mods.fml.common.registry.GameRegistry;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import openccsensors.OpenCCSensors;
import openccsensors.common.peripheral.PeripheralSensor;
import openccsensors.common.turtle.TurtleSensorEnvironment;

public class TurtleUpgradeSensor
implements ITurtleUpgrade {
    private ArrayList<PeripheralSensor> peripheral = new ArrayList();

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this.peripheral.add(new PeripheralSensor(new TurtleSensorEnvironment(turtle), true));
        return this.peripheral.get(this.peripheral.size() - 1);
    }

    public String getUnlocalisedAdjective() {
        return "turtle.openccsensors.sensor.adjective";
    }

    public ItemStack getCraftingItem() {
        return new ItemStack((Block)OpenCCSensors.Blocks.sensorBlock);
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public int getUpgradeID() {
        return 180;
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return TurtleCommandResult.failure();
    }

    public IIcon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return OpenCCSensors.Blocks.sensorBlock.turtleIcon;
    }

    public void addTurtlesToCreative(List subItems) {
        for (int i = 0; i <= 7; ++i) {
            ItemStack turtle = GameRegistry.findItemStack((String)"CCTurtle", (String)"CC-TurtleExpanded", (int)1);
            if (turtle == null) continue;
            NBTTagCompound tag = turtle.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                turtle.func_77955_b(tag);
            }
            tag.func_74777_a("leftUpgrade", (short)this.getUpgradeID());
            tag.func_74777_a("rightUpgrade", (short)i);
            turtle.func_77982_d(tag);
            subItems.add(turtle);
        }
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
        if (this.peripheral != null) {
            for (PeripheralSensor peripheral : this.peripheral) {
                if (peripheral == null) continue;
                peripheral.update();
            }
        }
    }
}

