/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.storage;

import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import thaumicenergistics.common.items.ItemEnum;
import thaumicenergistics.common.registries.ThEStrings;

public enum EnumEssentiaStorageTypes {
    Type_1K(0, 1024, 12, "1k", EnumRarity.common, 0.5, ThEStrings.Item_EssentiaCell_1k, ThEStrings.Item_StorageComponent_1k),
    Type_4K(1, 4096, 12, "4k", EnumRarity.uncommon, 1.0, ThEStrings.Item_EssentiaCell_4k, ThEStrings.Item_StorageComponent_4k),
    Type_16K(2, 16348, 12, "16k", EnumRarity.uncommon, 1.5, ThEStrings.Item_EssentiaCell_16k, ThEStrings.Item_StorageComponent_16k),
    Type_64K(3, 65536, 12, "64k", EnumRarity.rare, 2.0, ThEStrings.Item_EssentiaCell_64k, ThEStrings.Item_StorageComponent_64k),
    Type_Creative(4, 0, 63, "creative", EnumRarity.epic, 0.0, ThEStrings.Item_EssentiaCell_Creative, null);

    public static final EnumEssentiaStorageTypes[] fromIndex;
    public final int index;
    public final String suffix;
    public final int capacity;
    public final EnumRarity rarity;
    public final int maxStoredTypes;
    public final double idleAEPowerDrain;
    public final ThEStrings cellName;
    public final ThEStrings componentName;

    private EnumEssentiaStorageTypes(int index, int capacity, int maxStoredTypes, String suffix, EnumRarity rarity, double aeDrain, ThEStrings cellName, ThEStrings componentName) {
        this.index = index;
        this.capacity = capacity;
        this.suffix = suffix;
        this.rarity = rarity;
        this.maxStoredTypes = maxStoredTypes;
        this.idleAEPowerDrain = aeDrain;
        this.cellName = cellName;
        this.componentName = componentName;
    }

    public ItemStack getCell() {
        return ItemEnum.ESSENTIA_CELL.getDMGStack(this.index);
    }

    public ItemStack getComponent(int stackSize) {
        if (this == Type_Creative) {
            return null;
        }
        return ItemEnum.STORAGE_COMPONENT.getDMGStack(this.index, stackSize);
    }

    static {
        fromIndex = new EnumEssentiaStorageTypes[5];
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_1K.index] = Type_1K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_4K.index] = Type_4K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_16K.index] = Type_16K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_64K.index] = Type_64K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_Creative.index] = Type_Creative;
    }
}

