/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.inventory;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.misc.PartInterface;
import appeng.tile.misc.TileInterface;
import appeng.util.Platform;
import net.minecraft.tileentity.TileEntity;
import thaumicenergistics.common.inventory.HandlerEssentiaStorageBusBase;
import thaumicenergistics.common.parts.PartEssentiaStorageBus;

class HandlerEssentiaStorageBusInterface
extends HandlerEssentiaStorageBusBase
implements IMEMonitorHandlerReceiver<IAEFluidStack> {
    private ITileStorageMonitorable MEInterface = null;
    private MEInventoryHandler<IAEFluidStack> handler;
    private int handlerHash;
    private boolean canPostUpdate = true;

    public HandlerEssentiaStorageBusInterface(PartEssentiaStorageBus part) {
        super(part);
    }

    @Override
    public boolean canAccept(IAEFluidStack fluidStack) {
        if (this.isFluidEssentiaGas(fluidStack) && this.handler != null) {
            return this.handler.canAccept((IAEStack)fluidStack);
        }
        return false;
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource source) {
        if (this.isFluidEssentiaGas(request) && this.handler != null) {
            IAEFluidStack extractedGas = (IAEFluidStack)this.handler.extractItems((IAEStack)request, mode, source);
            return extractedGas;
        }
        return null;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        if (this.handler != null) {
            IItemList subGridFluids = this.handler.getAvailableItems(AEApi.instance().storage().createFluidList());
            for (IAEFluidStack fluid : subGridFluids) {
                if (!this.isFluidEssentiaGas(fluid)) continue;
                out.add((IAEStack)fluid);
            }
        }
        return out;
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource source) {
        if (this.isFluidEssentiaGas(input) && this.handler != null) {
            IAEFluidStack remainingGas = (IAEFluidStack)this.handler.injectItems((IAEStack)input, mode, source);
            return remainingGas;
        }
        return input;
    }

    public boolean isValid(Object verificationToken) {
        return this.handler == verificationToken;
    }

    public void onListUpdate() {
        if (this.canPostUpdate) {
            this.canPostUpdate = false;
            try {
                this.partStorageBus.getGridBlock().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean onNeighborChange() {
        ITileStorageMonitorable facingInterface = null;
        TileEntity tileEntity = this.getFaceingTile();
        if (tileEntity instanceof IPartHost) {
            IPart facingPart = this.getFacingPartFromPartHost((IPartHost)tileEntity);
            if (facingPart instanceof PartInterface) {
                facingInterface = (ITileStorageMonitorable)facingPart;
            }
        } else if (tileEntity instanceof TileInterface) {
            facingInterface = (ITileStorageMonitorable)tileEntity;
        }
        if (facingInterface != null) {
            IMEMonitor inv;
            int newHandlerHash = Platform.generateTileHash((TileEntity)tileEntity);
            if (this.handlerHash == newHandlerHash && this.handlerHash != 0) {
                return false;
            }
            try {
                this.partStorageBus.getGridBlock().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.handlerHash = newHandlerHash;
            this.MEInterface = facingInterface;
            this.handler = null;
            IStorageMonitorable monitor = this.MEInterface.getMonitorable(this.partStorageBus.getSide().getOpposite(), (BaseActionSource)this.machineSource);
            if (monitor != null && (inv = monitor.getFluidInventory()) != null) {
                this.handler = new MEInventoryHandler((IMEInventory)inv, StorageChannel.FLUIDS);
                this.handler.setBaseAccess(this.getAccess());
                this.handler.setWhitelist(IncludeExclude.WHITELIST);
                this.handler.setPriority(this.getPriority());
                if (inv instanceof IMEMonitor) {
                    inv.addListener((IMEMonitorHandlerReceiver)this, this.handler);
                }
            }
            return true;
        }
        this.handlerHash = 0;
        this.MEInterface = null;
        if (this.handler != null) {
            this.handler = null;
            return true;
        }
        return false;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        try {
            IActionHost actionHost = null;
            if (actionSource instanceof PlayerSource) {
                actionHost = ((PlayerSource)actionSource).via;
            } else if (actionSource instanceof MachineSource) {
                actionHost = ((MachineSource)actionSource).via;
            }
            if (actionHost != null && actionHost.getActionableNode().getGrid() != this.partStorageBus.getActionableNode().getGrid()) {
                this.postAlterationToHostGrid(change);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void tickingRequest(IGridNode node, int TicksSinceLastCall) {
        this.canPostUpdate = true;
    }

    @Override
    public boolean validForPass(int pass) {
        if (this.handler != null) {
            return this.handler.validForPass(pass);
        }
        return false;
    }
}

