/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.api.ITeleportPipe;
import buildcraft.additionalpipes.api.PipeType;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.utils.PlayerUtils;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PipeTeleport<pipeType extends PipeTransport>
extends APPipe<pipeType>
implements ITeleportPipe {
    protected static final Random rand = new Random();
    private int frequency = 0;
    public byte state = 1;
    public UUID ownerUUID;
    public String ownerName = "";
    public int[] network = new int[0];
    public boolean isPublic = false;
    public final PipeType type;
    static Method updateSignalState;

    public PipeTeleport(pipeType transport, Item item, PipeType type) {
        super(transport, item);
        this.type = type;
        if (updateSignalState == null) {
            try {
                Class<?> pipeClass = this.getClass().getSuperclass().getSuperclass().getSuperclass();
                updateSignalState = pipeClass.getDeclaredMethod("updateSignalState", PipeWire.class);
                updateSignalState.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public byte getState() {
        return this.state;
    }

    @Override
    public void setState(byte state) {
        this.state = state;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    public PipeType getType() {
        return this.type;
    }

    public void initialize() {
        super.initialize();
        TeleportManager.instance.add(this, this.frequency);
    }

    public void invalidate() {
        super.invalidate();
        TeleportManager.instance.remove(this, this.frequency);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        TeleportManager.instance.remove(this, this.frequency);
    }

    public boolean blockActivated(EntityPlayer player, ForgeDirection direction) {
        ItemStack equippedItem;
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.ownerUUID == null) {
            this.ownerUUID = PlayerUtils.getUUID(player);
            this.ownerName = player.func_70005_c_();
        }
        if (!this.isPublic) {
            if (PlayerUtils.getUUID(player).equals(this.ownerUUID)) {
                if (!player.func_70005_c_().equals(this.ownerName)) {
                    this.ownerName = player.func_70005_c_();
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText("Access denied!  This pipe belongs to " + this.ownerName));
                return true;
            }
        }
        if (APConfiguration.filterRightclicks && (equippedItem = player.func_71045_bC()) != null && AdditionalPipes.isPipe(equippedItem.func_77973_b())) {
            return false;
        }
        player.openGui((Object)AdditionalPipes.instance, 1, this.getWorld(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        return true;
    }

    public void updateEntity() {
        super.updateEntity();
    }

    @Override
    public void setFrequency(int freq) {
        this.frequency = freq;
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe = null;
        if (tile instanceof TileGenericPipe) {
            pipe = ((TileGenericPipe)tile).pipe;
        }
        if (pipe != null && pipe instanceof PipeTeleport) {
            return false;
        }
        return super.canPipeConnect(tile, side);
    }

    public boolean outputOpen(ForgeDirection to) {
        return this.container.isPipeConnected(to);
    }

    public void updateSignalState() {
        ArrayList<PipeTeleport<?>> otherTeleportPipes = TeleportManager.instance.getConnectedPipes(this, true, true);
        for (PipeWire wire : PipeWire.values()) {
            if (!this.wireSet[wire.ordinal()]) continue;
            this.myUpdateSignalStateForColor(wire, otherTeleportPipes);
        }
    }

    private void myUpdateSignalStateForColor(PipeWire wire, ArrayList<PipeTeleport<?>> otherTeleportPipes) {
        try {
            int prevStrength = this.wireSignalStrength[wire.ordinal()];
            boolean isBroadcast = false;
            for (Gate gate : this.gates) {
                if (gate == null || (gate.broadcastSignal & 1 << wire.ordinal()) == 0) continue;
                isBroadcast = true;
                break;
            }
            ArrayList connectedPipes = new ArrayList();
            int maxStrength = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Pipe pipe;
                TileEntity tile = this.container.getTile(dir);
                if (!(tile instanceof IPipeTile) || !this.isWireConnectedTo(tile, pipe = (Pipe)((IPipeTile)tile).getPipe(), wire, dir)) continue;
                connectedPipes.add(pipe);
                int pipeStrength = pipe.wireSignalStrength[wire.ordinal()];
                if (pipeStrength <= maxStrength) continue;
                maxStrength = pipeStrength;
            }
            connectedPipes.addAll(otherTeleportPipes);
            if (isBroadcast) {
                if (prevStrength < 255) {
                    this.myPropagateSignalState(wire, 255, connectedPipes);
                }
            } else {
                for (Pipe pipe : otherTeleportPipes) {
                    int pipeStrength = pipe.wireSignalStrength[wire.ordinal()];
                    if (pipeStrength <= maxStrength) continue;
                    maxStrength = pipeStrength;
                }
                this.wireSignalStrength[wire.ordinal()] = maxStrength > prevStrength && maxStrength > 1 ? maxStrength - 1 : 0;
                if (prevStrength != this.wireSignalStrength[wire.ordinal()]) {
                    this.container.scheduleRenderUpdate();
                }
                if (this.wireSignalStrength[wire.ordinal()] == 0) {
                    for (Pipe pipe : connectedPipes) {
                        if (pipe.wireSignalStrength[wire.ordinal()] <= 0) continue;
                        updateSignalState.invoke((Object)pipe, wire);
                    }
                } else {
                    for (Pipe pipe : connectedPipes) {
                        if (pipe.wireSignalStrength[wire.ordinal()] >= this.wireSignalStrength[wire.ordinal()] - 1) continue;
                        updateSignalState.invoke((Object)pipe, wire);
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void myPropagateSignalState(PipeWire wire, int strength, ArrayList<Pipe<?>> connectedPipes) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.wireSignalStrength[wire.ordinal()] = strength;
        for (Pipe<?> pipe : connectedPipes) {
            if (strength == 0) {
                if (pipe.wireSignalStrength[wire.ordinal()] <= 0) continue;
                updateSignalState.invoke(pipe, wire);
                continue;
            }
            if (pipe.wireSignalStrength[wire.ordinal()] >= strength) continue;
            updateSignalState.invoke(pipe, wire);
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("freq", this.frequency);
        nbttagcompound.func_74774_a("state", this.state);
        if (this.ownerUUID != null) {
            nbttagcompound.func_74778_a("ownerUUID", this.ownerUUID.toString());
            nbttagcompound.func_74778_a("ownerName", this.ownerName);
        }
        nbttagcompound.func_74757_a("isPublic", this.isPublic);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.frequency = nbttagcompound.func_74762_e("freq");
        this.state = nbttagcompound.func_74771_c("state");
        if (nbttagcompound.func_74764_b("ownerUUID")) {
            this.ownerUUID = UUID.fromString(nbttagcompound.func_74779_i("ownerUUID"));
            this.ownerName = nbttagcompound.func_74779_i("ownerName");
        }
        this.isPublic = nbttagcompound.func_74767_n("isPublic");
    }

    public static boolean canPlayerModifyPipe(EntityPlayer player, PipeTeleport<?> pipe) {
        return pipe.isPublic || pipe.ownerUUID.equals(PlayerUtils.getUUID(player)) || player.field_71075_bZ.field_75098_d;
    }

    @Override
    public Position getPosition() {
        return new Position((double)this.container.field_145851_c, (double)this.container.field_145848_d, (double)this.container.field_145849_e);
    }

    @Override
    public boolean canReceive() {
        return (this.state & 2) > 0;
    }

    @Override
    public boolean canSend() {
        return (this.state & 1) > 0;
    }
}

